/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.task;

import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.james.task.TaskId;
import org.apache.james.task.TaskManagerWorker;
import org.apache.james.task.TaskWithId;
import org.apache.james.task.WorkQueue;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class MemoryWorkQueue
implements WorkQueue {
    private final TaskManagerWorker worker;
    private final Disposable subscription;
    private final LinkedBlockingQueue<TaskWithId> tasks;

    public MemoryWorkQueue(TaskManagerWorker worker) {
        this.worker = worker;
        this.tasks = new LinkedBlockingQueue();
        this.subscription = Mono.fromCallable(this.tasks::take).repeat().subscribeOn(Schedulers.elastic()).flatMapSequential(this::dispatchTaskToWorker).subscribe();
    }

    private Mono<?> dispatchTaskToWorker(TaskWithId taskWithId) {
        return this.worker.executeTask(taskWithId);
    }

    @Override
    public void submit(TaskWithId taskWithId) {
        try {
            this.tasks.put(taskWithId);
        }
        catch (InterruptedException e) {
            this.worker.cancelTask(taskWithId.getId());
        }
    }

    @Override
    public void cancel(TaskId taskId) {
        this.worker.cancelTask(taskId);
    }

    @Override
    public void close() throws IOException {
        try {
            this.subscription.dispose();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.worker.close();
    }
}

