/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.task;

import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.james.task.MemoryWorkQueue;
import org.apache.james.task.SerialTaskManagerWorker;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskExecutionDetailsUpdater;
import org.apache.james.task.TaskId;
import org.apache.james.task.TaskManager;
import org.apache.james.task.TaskManagerWorker;
import org.apache.james.task.TaskNotFoundException;
import org.apache.james.task.TaskWithId;
import org.apache.james.task.WorkQueue;
import org.apache.james.task.eventsourcing.Hostname;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class MemoryTaskManager
implements TaskManager {
    private static final Duration AWAIT_POLLING_DURATION = Duration.ofMillis(500L);
    public static final Duration NOW = Duration.ZERO;
    private final Hostname hostname;
    private final WorkQueue workQueue;
    private final TaskManagerWorker worker;
    private final ConcurrentHashMap<TaskId, TaskExecutionDetails> idToExecutionDetails;

    @Inject
    public MemoryTaskManager(Hostname hostname) {
        this.hostname = hostname;
        this.idToExecutionDetails = new ConcurrentHashMap();
        this.worker = new SerialTaskManagerWorker(this.updater());
        this.workQueue = new MemoryWorkQueue(this.worker);
    }

    @Override
    public TaskId submit(Task task) {
        TaskId taskId = TaskId.generateTaskId();
        TaskExecutionDetails executionDetails = TaskExecutionDetails.from(task, taskId, this.hostname);
        this.idToExecutionDetails.put(taskId, executionDetails);
        this.workQueue.submit(new TaskWithId(taskId, task));
        return taskId;
    }

    @Override
    public TaskExecutionDetails getExecutionDetails(TaskId id) {
        return Optional.ofNullable(this.idToExecutionDetails.get(id)).orElseThrow(TaskNotFoundException::new);
    }

    @Override
    public List<TaskExecutionDetails> list() {
        return ImmutableList.copyOf(this.idToExecutionDetails.values());
    }

    @Override
    public List<TaskExecutionDetails> list(TaskManager.Status status) {
        return ImmutableList.copyOf(this.tasksFiltered(status).values());
    }

    public Map<TaskId, TaskExecutionDetails> tasksFiltered(TaskManager.Status status) {
        return (Map)this.idToExecutionDetails.entrySet().stream().filter(details -> ((TaskExecutionDetails)details.getValue()).getStatus().equals((Object)status)).collect(Guavate.entriesToImmutableMap());
    }

    @Override
    public void cancel(TaskId id) {
        Optional.ofNullable(this.idToExecutionDetails.get(id)).ifPresent(details -> {
            this.updateDetails(id).accept(taskExecutionDetails -> taskExecutionDetails.cancelRequested(this.hostname));
            this.workQueue.cancel(id);
        });
    }

    @Override
    public TaskExecutionDetails await(TaskId id) {
        if (Optional.ofNullable(this.idToExecutionDetails.get(id)).isPresent()) {
            return (TaskExecutionDetails)Flux.interval((Duration)NOW, (Duration)AWAIT_POLLING_DURATION, (Scheduler)Schedulers.elastic()).map(ignored -> this.getExecutionDetails(id)).filter(details -> details.getStatus() == TaskManager.Status.COMPLETED || details.getStatus() == TaskManager.Status.FAILED || details.getStatus() == TaskManager.Status.CANCELLED).take(1L).blockFirst();
        }
        return null;
    }

    @PreDestroy
    public void stop() {
        try {
            this.workQueue.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private DetailsUpdater updater() {
        return new DetailsUpdater(this::updateDetails, this.hostname);
    }

    private Consumer<TaskExecutionDetailsUpdater> updateDetails(TaskId taskId) {
        return updater -> {
            TaskExecutionDetails currentDetails = this.idToExecutionDetails.get(taskId);
            TaskExecutionDetails newDetails = updater.update(currentDetails);
            this.idToExecutionDetails.replace(taskId, newDetails);
        };
    }

    private static class DetailsUpdater
    implements TaskManagerWorker.Listener {
        private final TaskExecutionDetailsUpdaterFactory updaterFactory;
        private final Hostname hostname;

        DetailsUpdater(TaskExecutionDetailsUpdaterFactory updaterFactory, Hostname hostname) {
            this.updaterFactory = updaterFactory;
            this.hostname = hostname;
        }

        @Override
        public void started(TaskId taskId) {
            this.updaterFactory.apply(taskId).accept(details -> details.started(this.hostname));
        }

        @Override
        public void completed(TaskId taskId, Task.Result result) {
            this.updaterFactory.apply(taskId).accept(TaskExecutionDetails::completed);
        }

        @Override
        public void failed(TaskId taskId, Throwable t) {
            this.failed(taskId);
        }

        @Override
        public void failed(TaskId taskId) {
            this.updaterFactory.apply(taskId).accept(TaskExecutionDetails::failed);
        }

        @Override
        public void cancelled(TaskId taskId) {
            this.updaterFactory.apply(taskId).accept(TaskExecutionDetails::cancelEffectively);
        }
    }

    @FunctionalInterface
    private static interface TaskExecutionDetailsUpdaterFactory {
        public Consumer<TaskExecutionDetailsUpdater> apply(TaskId var1);
    }
}

