/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.util.SharedByteArrayInputStream;
import javax.mail.util.SharedFileInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.apache.james.lifecycle.api.Disposable;
import org.apache.james.server.core.MimeMessageSource;

public class MimeMessageInputStreamSource
extends MimeMessageSource
implements Disposable {
    private final List<InputStream> streams = new ArrayList<InputStream>();
    private DeferredFileOutputStream out;
    private final String sourceId;
    private static final int THRESHOLD = 102400;
    private static final File TMPDIR = new File(System.getProperty("java.io.tmpdir"));

    public MimeMessageInputStreamSource(String key, InputStream in) throws MessagingException {
        try {
            this.out = new DeferredFileOutputStream(102400, "mimemessage-" + key, ".m64", TMPDIR);
            IOUtils.copy((InputStream)in, (OutputStream)this.out);
            this.sourceId = key;
        }
        catch (IOException ioe) {
            File file = this.out.getFile();
            if (file != null) {
                FileUtils.deleteQuietly((File)file);
            }
            throw new MessagingException("Unable to retrieve the data: " + ioe.getMessage(), (Exception)ioe);
        }
        finally {
            try {
                if (this.out != null) {
                    this.out.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public MimeMessageInputStreamSource(String key) {
        this.out = new DeferredFileOutputStream(102400, key, ".m64", TMPDIR);
        this.sourceId = key;
    }

    @Override
    public String getSourceId() {
        return this.sourceId;
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        Object in = this.out.isInMemory() ? new SharedByteArrayInputStream(this.out.getData()) : new SharedFileInputStream(this.out.getFile());
        this.streams.add((InputStream)in);
        return in;
    }

    @Override
    public long getMessageSize() throws IOException {
        return this.out.getByteCount();
    }

    public OutputStream getWritableOutputStream() {
        return this.out;
    }

    public void dispose() {
        for (InputStream stream : this.streams) {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            File file = this.out.getFile();
            if (file != null) {
                FileUtils.deleteQuietly((File)file);
                file = null;
            }
            this.out = null;
        }
    }
}

