/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import javax.mail.internet.InternetHeaders;

public class InternetHeadersInputStream
extends InputStream {
    private static final String LINE_SEPERATOR = "\r\n";
    private final Enumeration<String> headerLines;
    private byte[] currLine;
    private int pos = 0;

    public InternetHeadersInputStream(InternetHeaders headers) {
        this(headers.getAllHeaderLines());
    }

    public InternetHeadersInputStream(Enumeration<String> headerLines) {
        this.headerLines = headerLines;
    }

    @Override
    public int read() throws IOException {
        if (!(this.currLine != null && this.pos != this.currLine.length || this.readNextLine())) {
            return -1;
        }
        return this.currLine[this.pos++];
    }

    private boolean readNextLine() throws IOException {
        if (this.headerLines.hasMoreElements()) {
            try {
                this.pos = 0;
                String line = this.headerLines.nextElement() + LINE_SEPERATOR;
                if (!this.headerLines.hasMoreElements()) {
                    line = line + LINE_SEPERATOR;
                }
                this.currLine = line.getBytes("US-ASCII");
                return true;
            }
            catch (UnsupportedEncodingException e) {
                throw new IOException("US-ASCII encoding not supported by this platform ?!");
            }
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        this.currLine = null;
    }
}

