/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import com.google.common.math.LongMath;

public class Size {
    public static final String UNKNOWN = "UNKNOWN";
    public static final String UNLIMITED = "UNLIMITED";
    public static final long UNKNOWN_VALUE = Long.MIN_VALUE;
    public static final long UNLIMITED_VALUE = -1L;
    private static final long base = 1024L;
    Unit unit;
    Long value;

    private Size(Unit unit, Long value) {
        this.unit = unit;
        this.value = value;
    }

    public static Size parse(String providedLongWithUnitString) throws Exception {
        if (providedLongWithUnitString.equalsIgnoreCase(UNKNOWN)) {
            return new Size(Unit.NoUnit, Long.MIN_VALUE);
        }
        if (providedLongWithUnitString.equalsIgnoreCase(UNLIMITED)) {
            return new Size(Unit.NoUnit, -1L);
        }
        char lastChar = providedLongWithUnitString.charAt(providedLongWithUnitString.length() - 1);
        Unit unit = Size.getUnit(lastChar);
        String argWithoutUnit = Size.removeLastCharIfNeeded(providedLongWithUnitString, unit);
        return new Size(unit, Long.parseLong(argWithoutUnit));
    }

    public Unit getUnit() {
        return this.unit;
    }

    public Long getValue() {
        return this.value;
    }

    public long asBytes() {
        switch (this.unit) {
            case G: {
                return this.value * LongMath.pow((long)1024L, (int)3);
            }
            case M: {
                return this.value * LongMath.pow((long)1024L, (int)2);
            }
            case K: {
                return this.value * LongMath.pow((long)1024L, (int)1);
            }
        }
        return this.value;
    }

    private static String removeLastCharIfNeeded(String providedLongWithUnitString, Unit unit) {
        if (unit != Unit.NoUnit) {
            return providedLongWithUnitString.substring(0, providedLongWithUnitString.length() - 1);
        }
        return providedLongWithUnitString;
    }

    private static Unit getUnit(char lastChar) throws Exception {
        switch (lastChar) {
            case 'K': 
            case 'k': {
                return Unit.K;
            }
            case 'M': 
            case 'm': {
                return Unit.M;
            }
            case 'G': 
            case 'g': {
                return Unit.G;
            }
            case 'B': 
            case 'b': {
                return Unit.B;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return Unit.NoUnit;
            }
        }
        throw new Exception("No unit corresponding to char : " + lastChar);
    }

    private static enum Unit {
        NoUnit,
        B,
        K,
        M,
        G;

    }
}

