/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import com.github.steveash.guavate.Guavate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class MDCBuilder {
    public static final String HOST = "host";
    public static final String IP = "ip";
    public static final String PROTOCOL = "protocol";
    public static final String USER = "user";
    public static final String ACTION = "action";
    public static final String SESSION_ID = "sessionId";
    public static final String CHARSET = "charset";
    private static final Logger LOGGER = LoggerFactory.getLogger(MDCBuilder.class);
    private final ImmutableMap.Builder<String, String> contextMap = ImmutableMap.builder();
    private final ImmutableList.Builder<MDCBuilder> nestedBuilder = ImmutableList.builder();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T withMdc(MDCBuilder mdcBuilder, Supplier<T> answerSupplier) {
        try {
            Closeable closeable = mdcBuilder.build();
            try {
                T t = answerSupplier.get();
                return t;
            }
            catch (RuntimeException e) {
                LOGGER.error("Got error, logging its context", (Throwable)e);
                throw e;
            }
            finally {
                if (closeable != null) {
                    try {
                        closeable.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void withMdc(MDCBuilder mdcBuilder, VoidOperation logOperation) {
        MDCBuilder.withMdc(mdcBuilder, () -> {
            logOperation.perform();
            return null;
        });
    }

    public static MDCBuilder create() {
        return new MDCBuilder();
    }

    private MDCBuilder() {
    }

    public MDCBuilder addContext(MDCBuilder nested) {
        this.nestedBuilder.add((Object)nested);
        return this;
    }

    public MDCBuilder addContext(String key, Object value) {
        Preconditions.checkNotNull((Object)key);
        Optional.ofNullable(value).ifPresent(nonNullValue -> this.contextMap.put((Object)key, (Object)nonNullValue.toString()));
        return this;
    }

    @VisibleForTesting
    Map<String, String> buildContextMap() {
        return ImmutableMap.builder().putAll((Map)this.nestedBuilder.build().stream().map(MDCBuilder::buildContextMap).flatMap(map -> map.entrySet().stream()).collect(Guavate.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue))).putAll((Map)this.contextMap.build()).build();
    }

    public <T> T execute(Supplier<T> supplier) {
        return MDCBuilder.withMdc(this, supplier);
    }

    public <T> Supplier<T> wrapArround(Supplier<T> supplier) {
        return () -> this.execute(supplier);
    }

    public Closeable build() {
        return new Closeables((List)this.buildContextMap().entrySet().stream().map(entry -> MDC.putCloseable((String)((String)entry.getKey()), (String)((String)entry.getValue()))).collect(Guavate.toImmutableList()));
    }

    public static class Closeables
    implements Closeable {
        private final List<Closeable> closeables;

        public Closeables(List<Closeable> closeables) {
            Preconditions.checkNotNull(closeables);
            this.closeables = ImmutableList.copyOf(closeables);
        }

        @Override
        public void close() throws IOException {
            this.closeables.forEach(this::closeQuietly);
        }

        private void closeQuietly(Closeable closeable) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                LOGGER.warn("Failed to close Closeable", (Throwable)e);
            }
        }
    }

    public static interface VoidOperation {
        public void perform();
    }
}

