/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DurationParser {
    private static final String PATTERN_STRING = "\\s*([0-9]+)\\s*([a-z,A-Z]*)\\s*";
    private static final int AMOUNT = 1;
    private static final int UNIT = 2;
    private static Pattern PATTERN = Pattern.compile("\\s*([0-9]+)\\s*([a-z,A-Z]*)\\s*");

    private DurationParser() {
    }

    public static Duration parse(String rawString) throws NumberFormatException {
        return DurationParser.parse(rawString, ChronoUnit.MILLIS);
    }

    public static Duration parse(String rawString, ChronoUnit defaultUnit) throws NumberFormatException {
        Matcher res = PATTERN.matcher(rawString);
        if (res.matches() && res.group(1) != null && res.group(2) != null) {
            long time = Integer.parseInt(res.group(1).trim());
            return DurationParser.parseUnitAsDuration(res.group(2)).orElse(defaultUnit.getDuration()).multipliedBy(time);
        }
        throw new NumberFormatException("The supplied String is not a supported format " + rawString);
    }

    private static Optional<Duration> parseUnitAsDuration(String unit) {
        if (Strings.isNullOrEmpty((String)unit)) {
            return Optional.empty();
        }
        return Optional.of(Unit.parse(unit).getDuration());
    }

    private static enum Unit {
        MILLI_SECONDS((List<String>)ImmutableList.of((Object)"ms", (Object)"msec", (Object)"msecs"), ChronoUnit.MILLIS),
        SECONDS((List<String>)ImmutableList.of((Object)"s", (Object)"sec", (Object)"secs", (Object)"second", (Object)"seconds"), ChronoUnit.SECONDS),
        MINUTES((List<String>)ImmutableList.of((Object)"m", (Object)"min", (Object)"mins", (Object)"minute", (Object)"minutes"), ChronoUnit.MINUTES),
        HOURS((List<String>)ImmutableList.of((Object)"h", (Object)"hour", (Object)"hours"), ChronoUnit.HOURS),
        DAYS((List<String>)ImmutableList.of((Object)"d", (Object)"day", (Object)"days"), ChronoUnit.DAYS),
        WEEKS((List<String>)ImmutableList.of((Object)"w", (Object)"week", (Object)"weeks"), ChronoUnit.WEEKS),
        MONTH((List<String>)ImmutableList.of((Object)"month", (Object)"months"), ChronoUnit.MONTHS),
        YEARS((List<String>)ImmutableList.of((Object)"y", (Object)"year", (Object)"years"), ChronoUnit.YEARS);

        private final List<String> validPatterns;
        private final ChronoUnit unit;

        public static ChronoUnit parse(String string) {
            return Arrays.stream(Unit.values()).filter(value -> value.validPatterns.contains(string.toLowerCase(Locale.US))).findFirst().map(entry -> entry.unit).orElseThrow(() -> new NumberFormatException("Unknown unit: " + string));
        }

        private Unit(List<String> validPatterns, ChronoUnit unit) {
            this.validPatterns = validPatterns;
            this.unit = unit;
        }
    }
}

