/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.james.core.quota.QuotaValue;

public class SerializableQuotaValue<T extends QuotaValue<T>>
implements Serializable {
    public static final long UNLIMITED = -1L;
    private final Long value;

    public static <U extends QuotaValue<U>> SerializableQuotaValue<U> valueOf(Optional<U> input) {
        return new SerializableQuotaValue<QuotaValue>(input.orElse(null));
    }

    public SerializableQuotaValue(T value) {
        this(SerializableQuotaValue.encodeAsLong(value));
    }

    SerializableQuotaValue(Long value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o instanceof SerializableQuotaValue) {
            SerializableQuotaValue that = (SerializableQuotaValue)o;
            return Objects.equals(this.value, that.value);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).toString();
    }

    private static <U extends QuotaValue<U>> Long encodeAsLong(U quota) {
        if (quota.isLimited()) {
            return quota.asLong();
        }
        return -1L;
    }

    public Long encodeAsLong() {
        return this.value;
    }

    public Optional<T> toValue(Function<Long, T> factory, T unlimited) {
        Long longValue = this.encodeAsLong();
        if (longValue == null) {
            return Optional.empty();
        }
        if (longValue == -1L) {
            return Optional.of(unlimited);
        }
        return Optional.of((QuotaValue)factory.apply(longValue));
    }
}

