/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.indexer;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.model.MailboxId;

public class ReIndexingExecutionFailures {
    private final List<ReIndexingFailure> failures;

    public ReIndexingExecutionFailures(List<ReIndexingFailure> failures) {
        this.failures = failures;
    }

    public List<ReIndexingFailure> failures() {
        return ImmutableList.copyOf(this.failures);
    }

    public final boolean equals(Object o) {
        if (o instanceof ReIndexingExecutionFailures) {
            ReIndexingExecutionFailures that = (ReIndexingExecutionFailures)o;
            return Objects.equals(this.failures, that.failures);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.failures);
    }

    public static class ReIndexingFailure {
        private final MailboxId mailboxId;
        private final MessageUid uid;

        public ReIndexingFailure(MailboxId mailboxId, MessageUid uid) {
            this.mailboxId = mailboxId;
            this.uid = uid;
        }

        public MailboxId getMailboxId() {
            return this.mailboxId;
        }

        public MessageUid getUid() {
            return this.uid;
        }

        public final boolean equals(Object o) {
            if (o instanceof ReIndexingFailure) {
                ReIndexingFailure that = (ReIndexingFailure)o;
                return Objects.equals(this.mailboxId, that.mailboxId) && Objects.equals(this.uid, that.uid);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.mailboxId, this.uid);
        }
    }
}

