/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.events;

import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import org.apache.james.core.User;
import org.apache.james.core.quota.QuotaCount;
import org.apache.james.core.quota.QuotaSize;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.acl.ACLDiff;
import org.apache.james.mailbox.events.Event;
import org.apache.james.mailbox.events.Group;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.model.UpdatedFlags;

public interface MailboxListener {
    default public ExecutionMode getExecutionMode() {
        return ExecutionMode.SYNCHRONOUS;
    }

    default public boolean isHandling(Event event) {
        return true;
    }

    public void event(Event var1) throws Exception;

    public static class Added
    extends MetaDataHoldingEvent {
        private final Map<MessageUid, MessageMetaData> added;

        public Added(MailboxSession.SessionId sessionId, User user, MailboxPath path, MailboxId mailboxId, SortedMap<MessageUid, MessageMetaData> uids, Event.EventId eventId) {
            super(sessionId, user, path, mailboxId, eventId);
            this.added = ImmutableMap.copyOf(uids);
        }

        @Override
        public MessageMetaData getMetaData(MessageUid uid) {
            return this.added.get(uid);
        }

        @Override
        public Collection<MessageUid> getUids() {
            return this.added.keySet();
        }

        public Map<MessageUid, MessageMetaData> getAdded() {
            return this.added;
        }

        @Override
        public boolean isNoop() {
            return this.added.isEmpty();
        }

        public final boolean equals(Object o) {
            if (o instanceof Added) {
                Added that = (Added)o;
                return Objects.equals(this.eventId, that.eventId) && Objects.equals(this.sessionId, that.sessionId) && Objects.equals(this.user, that.user) && Objects.equals(this.path, that.path) && Objects.equals(this.mailboxId, that.mailboxId) && Objects.equals(this.added, that.added);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.eventId, this.sessionId, this.user, this.path, this.mailboxId, this.added);
        }
    }

    public static class FlagsUpdated
    extends MessageEvent {
        private final List<MessageUid> uids;
        private final List<UpdatedFlags> updatedFlags;

        public FlagsUpdated(MailboxSession.SessionId sessionId, User user, MailboxPath path, MailboxId mailboxId, List<UpdatedFlags> updatedFlags, Event.EventId eventId) {
            super(sessionId, user, path, mailboxId, eventId);
            this.updatedFlags = ImmutableList.copyOf(updatedFlags);
            this.uids = (List)updatedFlags.stream().map(UpdatedFlags::getUid).collect(Guavate.toImmutableList());
        }

        @Override
        public Collection<MessageUid> getUids() {
            return this.uids;
        }

        public List<UpdatedFlags> getUpdatedFlags() {
            return this.updatedFlags;
        }

        @Override
        public boolean isNoop() {
            return this.updatedFlags.isEmpty();
        }

        public final boolean equals(Object o) {
            if (o instanceof FlagsUpdated) {
                FlagsUpdated that = (FlagsUpdated)o;
                return Objects.equals(this.eventId, that.eventId) && Objects.equals(this.sessionId, that.sessionId) && Objects.equals(this.user, that.user) && Objects.equals(this.path, that.path) && Objects.equals(this.mailboxId, that.mailboxId) && Objects.equals(this.uids, that.uids) && Objects.equals(this.updatedFlags, that.updatedFlags);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.eventId, this.sessionId, this.user, this.path, this.mailboxId, this.uids, this.updatedFlags);
        }
    }

    public static class Expunged
    extends MetaDataHoldingEvent {
        private final Map<MessageUid, MessageMetaData> expunged;

        public Expunged(MailboxSession.SessionId sessionId, User user, MailboxPath path, MailboxId mailboxId, Map<MessageUid, MessageMetaData> uids, Event.EventId eventId) {
            super(sessionId, user, path, mailboxId, eventId);
            this.expunged = ImmutableMap.copyOf(uids);
        }

        @Override
        public Collection<MessageUid> getUids() {
            return this.expunged.keySet();
        }

        @Override
        public MessageMetaData getMetaData(MessageUid uid) {
            return this.expunged.get(uid);
        }

        public Map<MessageUid, MessageMetaData> getExpunged() {
            return this.expunged;
        }

        @Override
        public boolean isNoop() {
            return this.expunged.isEmpty();
        }

        public final boolean equals(Object o) {
            if (o instanceof Expunged) {
                Expunged that = (Expunged)o;
                return Objects.equals(this.eventId, that.eventId) && Objects.equals(this.sessionId, that.sessionId) && Objects.equals(this.user, that.user) && Objects.equals(this.path, that.path) && Objects.equals(this.mailboxId, that.mailboxId) && Objects.equals(this.expunged, that.expunged);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.eventId, this.sessionId, this.user, this.path, this.mailboxId, this.expunged);
        }
    }

    public static abstract class MetaDataHoldingEvent
    extends MessageEvent {
        public MetaDataHoldingEvent(MailboxSession.SessionId sessionId, User user, MailboxPath path, MailboxId mailboxId, Event.EventId eventId) {
            super(sessionId, user, path, mailboxId, eventId);
        }

        public abstract MessageMetaData getMetaData(MessageUid var1);
    }

    public static abstract class MessageEvent
    extends MailboxEvent {
        public MessageEvent(MailboxSession.SessionId sessionId, User user, MailboxPath path, MailboxId mailboxId, Event.EventId eventId) {
            super(sessionId, user, path, mailboxId, eventId);
        }

        public abstract Collection<MessageUid> getUids();
    }

    public static class MailboxACLUpdated
    extends MailboxEvent {
        private final ACLDiff aclDiff;

        public MailboxACLUpdated(MailboxSession.SessionId sessionId, User user, MailboxPath path, ACLDiff aclDiff, MailboxId mailboxId, Event.EventId eventId) {
            super(sessionId, user, path, mailboxId, eventId);
            this.aclDiff = aclDiff;
        }

        public ACLDiff getAclDiff() {
            return this.aclDiff;
        }

        @Override
        public boolean isNoop() {
            return this.aclDiff.getNewACL().equals(this.aclDiff.getOldACL());
        }

        public final boolean equals(Object o) {
            if (o instanceof MailboxACLUpdated) {
                MailboxACLUpdated that = (MailboxACLUpdated)o;
                return Objects.equals(this.eventId, that.eventId) && Objects.equals(this.sessionId, that.sessionId) && Objects.equals(this.user, that.user) && Objects.equals(this.path, that.path) && Objects.equals(this.aclDiff, that.aclDiff) && Objects.equals(this.mailboxId, that.mailboxId);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.eventId, this.sessionId, this.user, this.path, this.aclDiff, this.mailboxId);
        }
    }

    public static class MailboxRenamed
    extends MailboxEvent {
        private final MailboxPath newPath;

        public MailboxRenamed(MailboxSession.SessionId sessionId, User user, MailboxPath path, MailboxId mailboxId, MailboxPath newPath, Event.EventId eventId) {
            super(sessionId, user, path, mailboxId, eventId);
            this.newPath = newPath;
        }

        @Override
        public boolean isNoop() {
            return this.newPath.equals(this.path);
        }

        public MailboxPath getNewPath() {
            return this.newPath;
        }

        public final boolean equals(Object o) {
            if (o instanceof MailboxRenamed) {
                MailboxRenamed that = (MailboxRenamed)o;
                return Objects.equals(this.eventId, that.eventId) && Objects.equals(this.sessionId, that.sessionId) && Objects.equals(this.user, that.user) && Objects.equals(this.path, that.path) && Objects.equals(this.mailboxId, that.mailboxId) && Objects.equals(this.newPath, that.newPath);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.eventId, this.sessionId, this.user, this.path, this.mailboxId, this.newPath);
        }
    }

    public static class MailboxAdded
    extends MailboxEvent {
        public MailboxAdded(MailboxSession.SessionId sessionId, User user, MailboxPath path, MailboxId mailboxId, Event.EventId eventId) {
            super(sessionId, user, path, mailboxId, eventId);
        }

        @Override
        public boolean isNoop() {
            return false;
        }

        public final boolean equals(Object o) {
            if (o instanceof MailboxAdded) {
                MailboxAdded that = (MailboxAdded)o;
                return Objects.equals(this.eventId, that.eventId) && Objects.equals(this.sessionId, that.sessionId) && Objects.equals(this.user, that.user) && Objects.equals(this.path, that.path) && Objects.equals(this.mailboxId, that.mailboxId);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.eventId, this.sessionId, this.user, this.path, this.mailboxId);
        }
    }

    public static class MailboxDeletion
    extends MailboxEvent {
        private final QuotaRoot quotaRoot;
        private final QuotaCount deletedMessageCount;
        private final QuotaSize totalDeletedSize;

        public MailboxDeletion(MailboxSession.SessionId sessionId, User user, MailboxPath path, QuotaRoot quotaRoot, QuotaCount deletedMessageCount, QuotaSize totalDeletedSize, MailboxId mailboxId, Event.EventId eventId) {
            super(sessionId, user, path, mailboxId, eventId);
            this.quotaRoot = quotaRoot;
            this.deletedMessageCount = deletedMessageCount;
            this.totalDeletedSize = totalDeletedSize;
        }

        @Override
        public boolean isNoop() {
            return false;
        }

        public QuotaRoot getQuotaRoot() {
            return this.quotaRoot;
        }

        public QuotaCount getDeletedMessageCount() {
            return this.deletedMessageCount;
        }

        public QuotaSize getTotalDeletedSize() {
            return this.totalDeletedSize;
        }

        public final boolean equals(Object o) {
            if (o instanceof MailboxDeletion) {
                MailboxDeletion that = (MailboxDeletion)o;
                return Objects.equals(this.eventId, that.eventId) && Objects.equals(this.sessionId, that.sessionId) && Objects.equals(this.user, that.user) && Objects.equals(this.path, that.path) && Objects.equals(this.mailboxId, that.mailboxId) && Objects.equals(this.quotaRoot, that.quotaRoot) && Objects.equals(this.deletedMessageCount, that.deletedMessageCount) && Objects.equals(this.totalDeletedSize, that.totalDeletedSize);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.eventId, this.sessionId, this.user, this.path, this.mailboxId, this.quotaRoot, this.deletedMessageCount, this.totalDeletedSize);
        }
    }

    public static abstract class MailboxEvent
    implements Event {
        protected final MailboxPath path;
        protected final MailboxId mailboxId;
        protected final User user;
        protected final MailboxSession.SessionId sessionId;
        protected final Event.EventId eventId;

        public MailboxEvent(MailboxSession.SessionId sessionId, User user, MailboxPath path, MailboxId mailboxId, Event.EventId eventId) {
            this.user = user;
            this.path = path;
            this.mailboxId = mailboxId;
            this.sessionId = sessionId;
            this.eventId = eventId;
        }

        @Override
        public User getUser() {
            return this.user;
        }

        @Override
        public Event.EventId getEventId() {
            return this.eventId;
        }

        public MailboxSession.SessionId getSessionId() {
            return this.sessionId;
        }

        public MailboxPath getMailboxPath() {
            return this.path;
        }

        public MailboxId getMailboxId() {
            return this.mailboxId;
        }
    }

    public static class QuotaUsageUpdatedEvent
    implements QuotaEvent {
        private final Event.EventId eventId;
        private final User user;
        private final QuotaRoot quotaRoot;
        private final Quota<QuotaCount> countQuota;
        private final Quota<QuotaSize> sizeQuota;
        private final Instant instant;

        public QuotaUsageUpdatedEvent(Event.EventId eventId, User user, QuotaRoot quotaRoot, Quota<QuotaCount> countQuota, Quota<QuotaSize> sizeQuota, Instant instant) {
            this.eventId = eventId;
            this.user = user;
            this.quotaRoot = quotaRoot;
            this.countQuota = countQuota;
            this.sizeQuota = sizeQuota;
            this.instant = instant;
        }

        @Override
        public boolean isNoop() {
            return false;
        }

        @Override
        public User getUser() {
            return this.user;
        }

        public Quota<QuotaCount> getCountQuota() {
            return this.countQuota;
        }

        public Quota<QuotaSize> getSizeQuota() {
            return this.sizeQuota;
        }

        @Override
        public QuotaRoot getQuotaRoot() {
            return this.quotaRoot;
        }

        public Instant getInstant() {
            return this.instant;
        }

        @Override
        public Event.EventId getEventId() {
            return this.eventId;
        }

        public final boolean equals(Object o) {
            if (o instanceof QuotaUsageUpdatedEvent) {
                QuotaUsageUpdatedEvent that = (QuotaUsageUpdatedEvent)o;
                return Objects.equals(this.eventId, that.eventId) && Objects.equals(this.user, that.user) && Objects.equals(this.quotaRoot, that.quotaRoot) && Objects.equals(this.countQuota, that.countQuota) && Objects.equals(this.sizeQuota, that.sizeQuota) && Objects.equals(this.instant, that.instant);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.eventId, this.user, this.quotaRoot, this.countQuota, this.sizeQuota, this.instant);
        }
    }

    public static interface QuotaEvent
    extends Event {
        public QuotaRoot getQuotaRoot();
    }

    public static enum ExecutionMode {
        SYNCHRONOUS,
        ASYNCHRONOUS;

    }

    public static interface GroupMailboxListener
    extends MailboxListener {
        public Group getDefaultGroup();
    }
}

