/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.events;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Objects;
import org.apache.james.mailbox.events.GenericGroup;

public class Group {
    public static Group deserialize(String serializedGroup) throws GroupDeserializationException {
        try {
            Preconditions.checkNotNull((Object)serializedGroup, (Object)"A serialized group can not be null");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)serializedGroup) ? 1 : 0) != 0, (Object)"A serialized group can not be empty");
            if (serializedGroup.startsWith(GenericGroup.class.getName() + "-")) {
                return new GenericGroup(serializedGroup.substring(GenericGroup.class.getName().length() + 1));
            }
            Class<?> groupClass = Class.forName(serializedGroup);
            return Group.instanciateGroup(groupClass);
        }
        catch (Exception e) {
            throw new GroupDeserializationException(e);
        }
    }

    private static Group instanciateGroup(Class<?> aClass) throws InstantiationException, IllegalAccessException {
        Preconditions.checkArgument((boolean)Group.class.isAssignableFrom(aClass), (Object)("The supplied class is not a group: " + aClass.getName()));
        return (Group)aClass.newInstance();
    }

    public String asString() {
        return this.getClass().getName();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return this.getClass().equals(o.getClass());
    }

    public int hashCode() {
        return Objects.hash(this.getClass());
    }

    public static class GroupDeserializationException
    extends Exception {
        GroupDeserializationException(Throwable cause) {
            super(cause);
        }
    }
}

