/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.events;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.UUID;
import org.apache.james.mailbox.events.Event;
import org.apache.james.mailbox.events.Group;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface EventDeadLetters {
    public static final String REGISTERED_GROUP_CANNOT_BE_NULL = "registeredGroup cannot be null";
    public static final String FAIL_DELIVERED_EVENT_CANNOT_BE_NULL = "failDeliveredEvent cannot be null";
    public static final String FAIL_DELIVERED_ID_INSERTION_CANNOT_BE_NULL = "failDeliveredInsertionId cannot be null";

    public Mono<Void> store(Group var1, Event var2, InsertionId var3);

    public Mono<Void> remove(Group var1, InsertionId var2);

    public Mono<Event> failedEvent(Group var1, InsertionId var2);

    public Flux<InsertionId> failedIds(Group var1);

    public Flux<Group> groupsWithFailedEvents();

    public static class InsertionId {
        private final UUID id;

        public static InsertionId of(UUID uuid) {
            return new InsertionId(uuid);
        }

        public static InsertionId random() {
            return new InsertionId(UUID.randomUUID());
        }

        public static InsertionId of(String serialized) {
            return InsertionId.of(UUID.fromString(serialized));
        }

        private InsertionId(UUID id) {
            Preconditions.checkNotNull((Object)id);
            this.id = id;
        }

        public UUID getId() {
            return this.id;
        }

        public final boolean equals(Object o) {
            if (o instanceof InsertionId) {
                InsertionId insertionId = (InsertionId)o;
                return Objects.equals(this.id, insertionId.id);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.id);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).toString();
        }
    }
}

