/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.managesieveserver.netty;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.managesieve.api.SieveParser;
import org.apache.james.managesieve.api.commands.CoreCommands;
import org.apache.james.managesieve.core.CoreProcessor;
import org.apache.james.managesieve.jsieve.Parser;
import org.apache.james.managesieve.transcode.ArgumentParser;
import org.apache.james.managesieve.transcode.ManageSieveProcessor;
import org.apache.james.managesieveserver.netty.ManageSieveServer;
import org.apache.james.protocols.lib.netty.AbstractConfigurableAsyncServer;
import org.apache.james.protocols.lib.netty.AbstractServerFactory;
import org.apache.james.sieverepository.api.SieveRepository;
import org.apache.james.user.api.UsersRepository;
import org.jboss.netty.util.HashedWheelTimer;

public class ManageSieveServerFactory
extends AbstractServerFactory {
    private FileSystem fileSystem;
    private ManageSieveProcessor manageSieveProcessor;
    private SieveRepository sieveRepository;
    private UsersRepository usersRepository;
    private Parser sieveParser;
    private HashedWheelTimer hashedWheelTimer;

    @Inject
    public void setFileSystem(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    @Inject
    public void setSieveRepository(SieveRepository sieveRepository) {
        this.sieveRepository = sieveRepository;
    }

    @Inject
    public void setUsersRepository(UsersRepository usersRepository) {
        this.usersRepository = usersRepository;
    }

    @Inject
    public void setParser(Parser sieveParser) {
        this.sieveParser = sieveParser;
    }

    @Inject
    public void setHashedWheelTimer(HashedWheelTimer hashedWheelTimer) {
        this.hashedWheelTimer = hashedWheelTimer;
    }

    @PostConstruct
    public void init() throws Exception {
        this.manageSieveProcessor = new ManageSieveProcessor(new ArgumentParser((CoreCommands)new CoreProcessor(this.sieveRepository, this.usersRepository, (SieveParser)this.sieveParser)));
        super.init();
    }

    protected List<AbstractConfigurableAsyncServer> createServers(HierarchicalConfiguration config) throws Exception {
        ArrayList<AbstractConfigurableAsyncServer> servers = new ArrayList<AbstractConfigurableAsyncServer>();
        List configs = config.configurationsAt("managesieveserver");
        for (HierarchicalConfiguration serverConfig : configs) {
            ManageSieveServer server = new ManageSieveServer(8000, this.manageSieveProcessor);
            server.setFileSystem(this.fileSystem);
            server.setHashWheelTimer(this.hashedWheelTimer);
            server.configure(serverConfig);
            servers.add(server);
        }
        return servers;
    }
}

