/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.sieve.jpa;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import org.apache.commons.io.IOUtils;
import org.apache.james.backends.jpa.TransactionRunner;
import org.apache.james.core.User;
import org.apache.james.core.quota.QuotaSize;
import org.apache.james.sieve.jpa.model.JPASieveQuota;
import org.apache.james.sieve.jpa.model.JPASieveScript;
import org.apache.james.sieverepository.api.ScriptContent;
import org.apache.james.sieverepository.api.ScriptName;
import org.apache.james.sieverepository.api.ScriptSummary;
import org.apache.james.sieverepository.api.SieveRepository;
import org.apache.james.sieverepository.api.exception.DuplicateException;
import org.apache.james.sieverepository.api.exception.IsActiveException;
import org.apache.james.sieverepository.api.exception.QuotaExceededException;
import org.apache.james.sieverepository.api.exception.QuotaNotFoundException;
import org.apache.james.sieverepository.api.exception.ScriptNotFoundException;
import org.apache.james.sieverepository.api.exception.StorageException;
import org.apache.james.util.OptionalUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPASieveRepository
implements SieveRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(JPASieveRepository.class);
    private static final String DEFAULT_SIEVE_QUOTA_USERNAME = "default.quota";
    private final TransactionRunner transactionRunner;

    @Inject
    public JPASieveRepository(EntityManagerFactory entityManagerFactory) {
        this.transactionRunner = new TransactionRunner(entityManagerFactory);
    }

    public void haveSpace(User user, ScriptName name, long size) throws QuotaExceededException, StorageException {
        QuotaSize quota;
        long usedSpace = this.findAllSieveScriptsForUser(user).stream().filter(sieveScript -> !sieveScript.getScriptName().equals(name.getValue())).mapToLong(JPASieveScript::getScriptSize).sum();
        if (this.overQuotaAfterModification(usedSpace, size, quota = this.limitToUser(user))) {
            throw new QuotaExceededException();
        }
    }

    private QuotaSize limitToUser(User user) throws StorageException {
        return OptionalUtils.orSuppliers((Supplier[])new Supplier[]{Throwing.supplier(() -> this.findQuotaForUser(user.asString())).sneakyThrow(), Throwing.supplier(() -> this.findQuotaForUser(DEFAULT_SIEVE_QUOTA_USERNAME)).sneakyThrow()}).map(JPASieveQuota::toQuotaSize).orElse(QuotaSize.unlimited());
    }

    private boolean overQuotaAfterModification(long usedSpace, long size, QuotaSize quota) {
        return QuotaSize.size((long)usedSpace).add(size).isGreaterThan(quota);
    }

    public void putScript(User user, ScriptName name, ScriptContent content) throws StorageException, QuotaExceededException {
        this.transactionRunner.runAndHandleException(Throwing.consumer(entityManager -> {
            try {
                this.haveSpace(user, name, content.length());
                JPASieveScript jpaSieveScript = JPASieveScript.builder().username(user.asString()).scriptName(name.getValue()).scriptContent(content).build();
                entityManager.persist((Object)jpaSieveScript);
            }
            catch (QuotaExceededException | StorageException e) {
                this.rollbackTransactionIfActive(entityManager.getTransaction());
                throw e;
            }
        }).sneakyThrow(), this.throwStorageException("Unable to put script for user " + user.asString()));
    }

    public List<ScriptSummary> listScripts(User user) throws StorageException {
        return (List)this.findAllSieveScriptsForUser(user).stream().map(JPASieveScript::toSummary).collect(ImmutableList.toImmutableList());
    }

    private List<JPASieveScript> findAllSieveScriptsForUser(User user) throws StorageException {
        return (List)this.transactionRunner.runAndRetrieveResult(entityManager -> {
            List sieveScripts = entityManager.createNamedQuery("findAllByUsername", JPASieveScript.class).setParameter("username", (Object)user.asString()).getResultList();
            return Optional.ofNullable(sieveScripts).orElse((List)ImmutableList.of());
        }, this.throwStorageException("Unable to list scripts for user " + user.asString()));
    }

    public ZonedDateTime getActivationDateForActiveScript(User user) throws StorageException, ScriptNotFoundException {
        Optional<JPASieveScript> script = this.findActiveSieveScript(user);
        JPASieveScript activeSieveScript = script.orElseThrow(() -> new ScriptNotFoundException("Unable to find active script for user " + user.asString()));
        return activeSieveScript.getActivationDateTime().toZonedDateTime();
    }

    public InputStream getActive(User user) throws ScriptNotFoundException, StorageException {
        Optional<JPASieveScript> script = this.findActiveSieveScript(user);
        JPASieveScript activeSieveScript = script.orElseThrow(() -> new ScriptNotFoundException("Unable to find active script for user " + user.asString()));
        return IOUtils.toInputStream((String)activeSieveScript.getScriptContent(), (Charset)StandardCharsets.UTF_8);
    }

    private Optional<JPASieveScript> findActiveSieveScript(User user) throws StorageException {
        return (Optional)this.transactionRunner.runAndRetrieveResult(Throwing.function(entityManager -> this.findActiveSieveScript(user, (EntityManager)entityManager)).sneakyThrow(), this.throwStorageException("Unable to find active script for user " + user.asString()));
    }

    private Optional<JPASieveScript> findActiveSieveScript(User user, EntityManager entityManager) throws StorageException {
        try {
            JPASieveScript activeSieveScript = (JPASieveScript)entityManager.createNamedQuery("findActiveByUsername", JPASieveScript.class).setParameter("username", (Object)user.asString()).getSingleResult();
            return Optional.ofNullable(activeSieveScript);
        }
        catch (NoResultException e) {
            LOGGER.debug("Sieve script not found for user {}", (Object)user.asString());
            return Optional.empty();
        }
    }

    public void setActive(User user, ScriptName name) throws ScriptNotFoundException, StorageException {
        this.transactionRunner.runAndHandleException(Throwing.consumer(entityManager -> {
            try {
                if (SieveRepository.NO_SCRIPT_NAME.equals((Object)name)) {
                    this.switchOffActiveScript(user, (EntityManager)entityManager);
                } else {
                    this.setActiveScript(user, name, (EntityManager)entityManager);
                }
            }
            catch (ScriptNotFoundException | StorageException e) {
                this.rollbackTransactionIfActive(entityManager.getTransaction());
                throw e;
            }
        }).sneakyThrow(), this.throwStorageException("Unable to set active script " + name.getValue() + " for user " + user.asString()));
    }

    private void switchOffActiveScript(User user, EntityManager entityManager) throws StorageException {
        Optional<JPASieveScript> activeSieveScript = this.findActiveSieveScript(user, entityManager);
        activeSieveScript.ifPresent(JPASieveScript::deactivate);
    }

    private void setActiveScript(User user, ScriptName name, EntityManager entityManager) throws StorageException, ScriptNotFoundException {
        JPASieveScript sieveScript = this.findSieveScript(user, name, entityManager).orElseThrow(() -> new ScriptNotFoundException("Unable to find script " + name.getValue() + " for user " + user.asString()));
        this.findActiveSieveScript(user, entityManager).ifPresent(JPASieveScript::deactivate);
        sieveScript.activate();
    }

    public InputStream getScript(User user, ScriptName name) throws ScriptNotFoundException, StorageException {
        Optional<JPASieveScript> script = this.findSieveScript(user, name);
        JPASieveScript sieveScript = script.orElseThrow(() -> new ScriptNotFoundException("Unable to find script " + name.getValue() + " for user " + user.asString()));
        return IOUtils.toInputStream((String)sieveScript.getScriptContent(), (Charset)StandardCharsets.UTF_8);
    }

    private Optional<JPASieveScript> findSieveScript(User user, ScriptName scriptName) throws StorageException {
        return (Optional)this.transactionRunner.runAndRetrieveResult(entityManager -> this.findSieveScript(user, scriptName, (EntityManager)entityManager), this.throwStorageException("Unable to find script " + scriptName.getValue() + " for user " + user.asString()));
    }

    private Optional<JPASieveScript> findSieveScript(User user, ScriptName scriptName, EntityManager entityManager) {
        try {
            JPASieveScript sieveScript = (JPASieveScript)entityManager.createNamedQuery("findSieveScript", JPASieveScript.class).setParameter("username", (Object)user.asString()).setParameter("scriptName", (Object)scriptName.getValue()).getSingleResult();
            return Optional.ofNullable(sieveScript);
        }
        catch (NoResultException e) {
            LOGGER.debug("Sieve script not found for user {}", (Object)user.asString());
            return Optional.empty();
        }
    }

    public void deleteScript(User user, ScriptName name) throws ScriptNotFoundException, IsActiveException, StorageException {
        this.transactionRunner.runAndHandleException(Throwing.consumer(entityManager -> {
            Optional<JPASieveScript> sieveScript = this.findSieveScript(user, name, (EntityManager)entityManager);
            if (!sieveScript.isPresent()) {
                this.rollbackTransactionIfActive(entityManager.getTransaction());
                throw new ScriptNotFoundException("Unable to find script " + name.getValue() + " for user " + user.asString());
            }
            JPASieveScript sieveScriptToRemove = sieveScript.get();
            if (sieveScriptToRemove.isActive()) {
                this.rollbackTransactionIfActive(entityManager.getTransaction());
                throw new IsActiveException("Unable to delete active script " + name.getValue() + " for user " + user.asString());
            }
            entityManager.remove((Object)sieveScriptToRemove);
        }).sneakyThrow(), this.throwStorageException("Unable to delete script " + name.getValue() + " for user " + user.asString()));
    }

    public void renameScript(User user, ScriptName oldName, ScriptName newName) throws ScriptNotFoundException, DuplicateException, StorageException {
        this.transactionRunner.runAndHandleException(Throwing.consumer(entityManager -> {
            Optional<JPASieveScript> sieveScript = this.findSieveScript(user, oldName, (EntityManager)entityManager);
            if (!sieveScript.isPresent()) {
                this.rollbackTransactionIfActive(entityManager.getTransaction());
                throw new ScriptNotFoundException("Unable to find script " + oldName.getValue() + " for user " + user.asString());
            }
            Optional<JPASieveScript> duplicatedSieveScript = this.findSieveScript(user, newName, (EntityManager)entityManager);
            if (duplicatedSieveScript.isPresent()) {
                this.rollbackTransactionIfActive(entityManager.getTransaction());
                throw new DuplicateException("Unable to rename script. Duplicate found " + newName.getValue() + " for user " + user.asString());
            }
            JPASieveScript sieveScriptToRename = sieveScript.get();
            sieveScriptToRename.renameTo(newName);
        }).sneakyThrow(), this.throwStorageException("Unable to rename script " + oldName.getValue() + " for user " + user.asString()));
    }

    private void rollbackTransactionIfActive(EntityTransaction transaction) {
        if (transaction.isActive()) {
            transaction.rollback();
        }
    }

    public boolean hasDefaultQuota() throws StorageException {
        Optional<JPASieveQuota> defaultQuota = this.findQuotaForUser(DEFAULT_SIEVE_QUOTA_USERNAME);
        return defaultQuota.isPresent();
    }

    public QuotaSize getDefaultQuota() throws QuotaNotFoundException, StorageException {
        JPASieveQuota jpaSieveQuota = this.findQuotaForUser(DEFAULT_SIEVE_QUOTA_USERNAME).orElseThrow(() -> new QuotaNotFoundException("Unable to find quota for default user"));
        return QuotaSize.size((long)jpaSieveQuota.getSize());
    }

    public void setDefaultQuota(QuotaSize quota) throws StorageException {
        this.setQuotaForUser(DEFAULT_SIEVE_QUOTA_USERNAME, quota);
    }

    public void removeQuota() throws QuotaNotFoundException, StorageException {
        this.removeQuotaForUser(DEFAULT_SIEVE_QUOTA_USERNAME);
    }

    public boolean hasQuota(User user) throws StorageException {
        Optional<JPASieveQuota> quotaForUser = this.findQuotaForUser(user.asString());
        return quotaForUser.isPresent();
    }

    public QuotaSize getQuota(User user) throws QuotaNotFoundException, StorageException {
        JPASieveQuota jpaSieveQuota = this.findQuotaForUser(user.asString()).orElseThrow(() -> new QuotaNotFoundException("Unable to find quota for user " + user.asString()));
        return QuotaSize.size((long)jpaSieveQuota.getSize());
    }

    public void setQuota(User user, QuotaSize quota) throws StorageException {
        this.setQuotaForUser(user.asString(), quota);
    }

    public void removeQuota(User user) throws QuotaNotFoundException, StorageException {
        this.removeQuotaForUser(user.asString());
    }

    private Optional<JPASieveQuota> findQuotaForUser(String username) throws StorageException {
        return (Optional)this.transactionRunner.runAndRetrieveResult(entityManager -> this.findQuotaForUser(username, (EntityManager)entityManager), this.throwStorageException("Unable to find quota for user " + username));
    }

    private <T> Function<PersistenceException, T> throwStorageException(String message) {
        return Throwing.function(e -> {
            throw new StorageException(message, (Throwable)e);
        }).sneakyThrow();
    }

    private Optional<JPASieveQuota> findQuotaForUser(String username, EntityManager entityManager) {
        try {
            JPASieveQuota sieveQuota = (JPASieveQuota)entityManager.createNamedQuery("findByUsername", JPASieveQuota.class).setParameter("username", (Object)username).getSingleResult();
            return Optional.of(sieveQuota);
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    private void setQuotaForUser(String username, QuotaSize quota) throws StorageException {
        this.transactionRunner.runAndHandleException((Consumer)Throwing.consumer(entityManager -> {
            Optional<JPASieveQuota> sieveQuota = this.findQuotaForUser(username, (EntityManager)entityManager);
            if (sieveQuota.isPresent()) {
                JPASieveQuota jpaSieveQuota = sieveQuota.get();
                jpaSieveQuota.setSize(quota);
                entityManager.merge((Object)jpaSieveQuota);
            } else {
                JPASieveQuota jpaSieveQuota = new JPASieveQuota(username, quota.asLong());
                entityManager.persist((Object)jpaSieveQuota);
            }
        }), this.throwStorageException("Unable to set quota for user " + username));
    }

    private void removeQuotaForUser(String username) throws StorageException {
        this.transactionRunner.runAndHandleException((Consumer)Throwing.consumer(entityManager -> {
            Optional<JPASieveQuota> quotaForUser = this.findQuotaForUser(username, (EntityManager)entityManager);
            quotaForUser.ifPresent(arg_0 -> ((EntityManager)entityManager).remove(arg_0));
        }), this.throwStorageException("Unable to remove quota for user " + username));
    }
}

