/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.jpa;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;
import javax.persistence.PersistenceUnit;
import org.apache.james.core.Domain;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.jpa.model.JPARecipientRewrite;
import org.apache.james.rrt.lib.AbstractRecipientRewriteTable;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.rrt.lib.Mappings;
import org.apache.james.rrt.lib.MappingsImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPARecipientRewriteTable
extends AbstractRecipientRewriteTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JPARecipientRewriteTable.class);
    private EntityManagerFactory entityManagerFactory;

    @Inject
    @PersistenceUnit(unitName="James")
    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public void addMapping(MappingSource source, Mapping mapping) throws RecipientRewriteTableException {
        Mappings map = this.getStoredMappings(source);
        if (!map.isEmpty()) {
            MappingsImpl updatedMappings = MappingsImpl.from((Mappings)map).add(mapping).build();
            this.doUpdateMapping(source, updatedMappings.serialize());
        } else {
            this.doAddMapping(source, mapping.asString());
        }
    }

    protected Mappings mapAddress(String user, Domain domain) throws RecipientRewriteTableException {
        Mappings userDomainMapping = this.getStoredMappings(MappingSource.fromUser((String)user, (Domain)domain));
        if (userDomainMapping != null && !userDomainMapping.isEmpty()) {
            return userDomainMapping;
        }
        Mappings domainMapping = this.getStoredMappings(MappingSource.fromDomain((Domain)domain));
        if (domainMapping != null && !domainMapping.isEmpty()) {
            return domainMapping;
        }
        return MappingsImpl.empty();
    }

    public Mappings getStoredMappings(MappingSource source) throws RecipientRewriteTableException {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        try {
            transaction.begin();
            List virtualUsers = entityManager.createNamedQuery("selectUserDomainMapping").setParameter("user", (Object)source.getFixedUser()).setParameter("domain", (Object)source.getFixedDomain()).getResultList();
            transaction.commit();
            if (virtualUsers.size() > 0) {
                MappingsImpl mappingsImpl = MappingsImpl.fromRawString((String)((JPARecipientRewrite)virtualUsers.get(0)).getTargetAddress());
                return mappingsImpl;
            }
            MappingsImpl mappingsImpl = MappingsImpl.empty();
            return mappingsImpl;
        }
        catch (PersistenceException e) {
            LOGGER.debug("Failed to get user domain mappings", (Throwable)e);
            if (transaction.isActive()) {
                transaction.rollback();
            }
            throw new RecipientRewriteTableException("Error while retrieve mappings", (Throwable)e);
        }
        finally {
            entityManager.close();
        }
    }

    public Map<MappingSource, Mappings> getAllMappings() throws RecipientRewriteTableException {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        HashMap<MappingSource, MappingsImpl> mapping = new HashMap<MappingSource, MappingsImpl>();
        try {
            transaction.begin();
            List virtualUsers = entityManager.createNamedQuery("selectAllMappings").getResultList();
            transaction.commit();
            for (JPARecipientRewrite virtualUser : virtualUsers) {
                mapping.put(MappingSource.fromUser((String)virtualUser.getUser(), (String)virtualUser.getDomain()), MappingsImpl.fromRawString((String)virtualUser.getTargetAddress()));
            }
            HashMap<MappingSource, MappingsImpl> hashMap = mapping;
            return hashMap;
        }
        catch (PersistenceException e) {
            LOGGER.debug("Failed to get all mappings", (Throwable)e);
            if (transaction.isActive()) {
                transaction.rollback();
            }
            throw new RecipientRewriteTableException("Error while retrieve mappings", (Throwable)e);
        }
        finally {
            entityManager.close();
        }
    }

    public void removeMapping(MappingSource source, Mapping mapping) throws RecipientRewriteTableException {
        Mappings map = this.getStoredMappings(source);
        if (map.size() > 1) {
            Mappings updatedMappings = map.remove(mapping);
            this.doUpdateMapping(source, updatedMappings.serialize());
        } else {
            this.doRemoveMapping(source, mapping.asString());
        }
    }

    private boolean doUpdateMapping(MappingSource source, String mapping) throws RecipientRewriteTableException {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        try {
            transaction.begin();
            int updated = entityManager.createNamedQuery("updateMapping").setParameter("targetAddress", (Object)mapping).setParameter("user", (Object)source.getFixedUser()).setParameter("domain", (Object)source.getFixedDomain()).executeUpdate();
            transaction.commit();
            if (updated > 0) {
                boolean bl = true;
                return bl;
            }
        }
        catch (PersistenceException e) {
            LOGGER.debug("Failed to update mapping", (Throwable)e);
            if (transaction.isActive()) {
                transaction.rollback();
            }
            throw new RecipientRewriteTableException("Unable to update mapping", (Throwable)e);
        }
        finally {
            entityManager.close();
        }
        return false;
    }

    private void doRemoveMapping(MappingSource source, String mapping) throws RecipientRewriteTableException {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        try {
            transaction.begin();
            entityManager.createNamedQuery("deleteMapping").setParameter("user", (Object)source.getFixedUser()).setParameter("domain", (Object)source.getFixedDomain()).setParameter("targetAddress", (Object)mapping).executeUpdate();
            transaction.commit();
        }
        catch (PersistenceException e) {
            LOGGER.debug("Failed to remove mapping", (Throwable)e);
            if (transaction.isActive()) {
                transaction.rollback();
            }
            throw new RecipientRewriteTableException("Unable to remove mapping", (Throwable)e);
        }
        finally {
            entityManager.close();
        }
    }

    private void doAddMapping(MappingSource source, String mapping) throws RecipientRewriteTableException {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        try {
            transaction.begin();
            JPARecipientRewrite jpaRecipientRewrite = new JPARecipientRewrite(source.getFixedUser(), Domain.of((String)source.getFixedDomain()), mapping);
            entityManager.persist((Object)jpaRecipientRewrite);
            transaction.commit();
        }
        catch (PersistenceException e) {
            LOGGER.debug("Failed to save virtual user", (Throwable)e);
            if (transaction.isActive()) {
                transaction.rollback();
            }
            throw new RecipientRewriteTableException("Unable to add mapping", (Throwable)e);
        }
        finally {
            entityManager.close();
        }
    }
}

