/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.jdbc;

import com.google.common.collect.ImmutableMap;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.core.Domain;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.lib.AbstractRecipientRewriteTable;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.rrt.lib.Mappings;
import org.apache.james.rrt.lib.MappingsImpl;
import org.apache.james.util.sql.JDBCUtil;
import org.apache.james.util.sql.SqlResources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class JDBCRecipientRewriteTable
extends AbstractRecipientRewriteTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JDBCRecipientRewriteTable.class);
    private DataSource dataSource = null;
    private String tableName = "RecipientRewriteTable";
    private SqlResources sqlQueries;
    private String sqlFileName;
    private FileSystem fileSystem;
    private final JDBCUtil theJDBCUtil = new JDBCUtil();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void init() throws Exception {
        LOGGER.debug("{}.initialize()", (Object)((Object)((Object)this)).getClass().getName());
        Connection conn = this.dataSource.getConnection();
        PreparedStatement createStatement = null;
        try {
            InputStream sqlFile;
            try {
                sqlFile = this.fileSystem.getResource(this.sqlFileName);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw e;
            }
            LOGGER.debug("Reading SQL resources from file: {}, section {}.", (Object)this.sqlFileName, (Object)((Object)((Object)this)).getClass().getName());
            HashMap<String, String> sqlParameters = new HashMap<String, String>();
            if (this.tableName != null) {
                sqlParameters.put("table", this.tableName);
            }
            this.sqlQueries = new SqlResources();
            this.sqlQueries.init(sqlFile, ((Object)((Object)this)).getClass().getName(), conn, sqlParameters);
            DatabaseMetaData dbMetaData = conn.getMetaData();
            if (!this.theJDBCUtil.tableExists(dbMetaData, this.tableName)) {
                createStatement = conn.prepareStatement(this.sqlQueries.getSqlString("createTable", true));
                createStatement.execute();
                LOGGER.info("JdbcVirtalUserTable: Created table '{}'.", (Object)this.tableName);
            }
        }
        finally {
            this.theJDBCUtil.closeJDBCStatement(createStatement);
            this.theJDBCUtil.closeJDBCConnection(conn);
        }
    }

    @Inject
    public void setFileSystem(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    @Inject
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected void doConfigure(HierarchicalConfiguration conf) throws ConfigurationException {
        String destination = conf.getString("[@destinationURL]", null);
        if (destination == null) {
            throw new ConfigurationException("destinationURL must configured");
        }
        if (!destination.endsWith("/")) {
            destination = destination + "/";
        }
        ArrayList<String> urlParams = new ArrayList<String>();
        int start = 5;
        int end = destination.indexOf(47, start);
        while (end > -1) {
            urlParams.add(destination.substring(start, end));
            start = end + 1;
            end = destination.indexOf(47, start);
        }
        if (urlParams.size() == 0) {
            String exceptionBuffer = "Malformed destinationURL - Must be of the format 'db://<data-source>'.  Was passed " + conf.getString("[@destinationURL]");
            throw new ConfigurationException(exceptionBuffer);
        }
        if (urlParams.size() >= 2) {
            this.tableName = (String)urlParams.get(1);
        }
        LOGGER.debug("Parsed URL: table = '{}'", (Object)this.tableName);
        this.sqlFileName = conf.getString("sqlFile");
    }

    public void addMapping(MappingSource source, Mapping mapping) throws RecipientRewriteTableException {
        Mappings map = this.getStoredMappings(source);
        if (!map.isEmpty()) {
            MappingsImpl updatedMappings = MappingsImpl.from((Mappings)map).add(mapping).build();
            this.doUpdateMapping(source, updatedMappings.serialize());
        }
        this.doAddMapping(source, mapping.asString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected Mappings mapAddress(String user, Domain domain) throws RecipientRewriteTableException {
        PreparedStatement mappingStmt;
        Connection conn;
        block8: {
            ResultSet mappingRS;
            block7: {
                conn = null;
                mappingStmt = null;
                conn = this.dataSource.getConnection();
                mappingStmt = conn.prepareStatement(this.sqlQueries.getSqlString("selectMappings", true));
                mappingRS = null;
                mappingStmt.setString(1, user);
                mappingStmt.setString(2, domain.asString());
                mappingRS = mappingStmt.executeQuery();
                if (!mappingRS.next()) break block7;
                MappingsImpl mappingsImpl = MappingsImpl.fromRawString((String)mappingRS.getString(1));
                this.theJDBCUtil.closeJDBCResultSet(mappingRS);
                this.theJDBCUtil.closeJDBCStatement((Statement)mappingStmt);
                this.theJDBCUtil.closeJDBCConnection(conn);
                return mappingsImpl;
            }
            try {
                this.theJDBCUtil.closeJDBCResultSet(mappingRS);
                break block8;
                {
                    catch (Throwable throwable) {
                        this.theJDBCUtil.closeJDBCResultSet(mappingRS);
                        throw throwable;
                    }
                }
            }
            catch (SQLException sqle) {
                try {
                    LOGGER.error("Error accessing database", (Throwable)sqle);
                    throw new RecipientRewriteTableException("Error accessing database", (Throwable)sqle);
                }
                catch (Throwable throwable) {
                    this.theJDBCUtil.closeJDBCStatement(mappingStmt);
                    this.theJDBCUtil.closeJDBCConnection(conn);
                    throw throwable;
                }
            }
        }
        this.theJDBCUtil.closeJDBCStatement((Statement)mappingStmt);
        this.theJDBCUtil.closeJDBCConnection(conn);
        return MappingsImpl.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Mappings getStoredMappings(MappingSource source) throws RecipientRewriteTableException {
        PreparedStatement mappingStmt;
        Connection conn;
        block8: {
            ResultSet mappingRS;
            block7: {
                conn = null;
                mappingStmt = null;
                conn = this.dataSource.getConnection();
                mappingStmt = conn.prepareStatement(this.sqlQueries.getSqlString("selectUserDomainMapping", true));
                mappingRS = null;
                mappingStmt.setString(1, source.getFixedUser());
                mappingStmt.setString(2, source.getFixedDomain());
                mappingRS = mappingStmt.executeQuery();
                if (!mappingRS.next()) break block7;
                MappingsImpl mappingsImpl = MappingsImpl.fromRawString((String)mappingRS.getString(1));
                this.theJDBCUtil.closeJDBCResultSet(mappingRS);
                this.theJDBCUtil.closeJDBCStatement((Statement)mappingStmt);
                this.theJDBCUtil.closeJDBCConnection(conn);
                return mappingsImpl;
            }
            try {
                this.theJDBCUtil.closeJDBCResultSet(mappingRS);
                break block8;
                {
                    catch (Throwable throwable) {
                        this.theJDBCUtil.closeJDBCResultSet(mappingRS);
                        throw throwable;
                    }
                }
            }
            catch (SQLException sqle) {
                try {
                    LOGGER.error("Error accessing database", (Throwable)sqle);
                    throw new RecipientRewriteTableException("Error accessing database", (Throwable)sqle);
                }
                catch (Throwable throwable) {
                    this.theJDBCUtil.closeJDBCStatement(mappingStmt);
                    this.theJDBCUtil.closeJDBCConnection(conn);
                    throw throwable;
                }
            }
        }
        this.theJDBCUtil.closeJDBCStatement((Statement)mappingStmt);
        this.theJDBCUtil.closeJDBCConnection(conn);
        return MappingsImpl.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Map<MappingSource, Mappings> getAllMappings() throws RecipientRewriteTableException {
        PreparedStatement mappingStmt;
        Connection conn;
        block9: {
            ResultSet mappingRS;
            block8: {
                conn = null;
                mappingStmt = null;
                HashMap<MappingSource, Mappings> mapping = new HashMap<MappingSource, Mappings>();
                conn = this.dataSource.getConnection();
                mappingStmt = conn.prepareStatement(this.sqlQueries.getSqlString("selectAllMappings", true));
                mappingRS = null;
                mappingRS = mappingStmt.executeQuery();
                while (mappingRS.next()) {
                    String user = mappingRS.getString(1);
                    Domain domain = Domain.of((String)mappingRS.getString(2));
                    String map = mappingRS.getString(3);
                    mapping.put(MappingSource.fromUser((String)user, (Domain)domain), (Mappings)MappingsImpl.fromRawString((String)map));
                }
                if (mapping.size() <= 0) break block8;
                HashMap<MappingSource, Mappings> hashMap = mapping;
                this.theJDBCUtil.closeJDBCResultSet(mappingRS);
                this.theJDBCUtil.closeJDBCStatement((Statement)mappingStmt);
                this.theJDBCUtil.closeJDBCConnection(conn);
                return hashMap;
            }
            try {
                this.theJDBCUtil.closeJDBCResultSet(mappingRS);
                break block9;
                {
                    catch (Throwable throwable) {
                        this.theJDBCUtil.closeJDBCResultSet(mappingRS);
                        throw throwable;
                    }
                }
            }
            catch (SQLException sqle) {
                try {
                    LOGGER.error("Error accessing database", (Throwable)sqle);
                    throw new RecipientRewriteTableException("Error accessing database", (Throwable)sqle);
                }
                catch (Throwable throwable) {
                    this.theJDBCUtil.closeJDBCStatement(mappingStmt);
                    this.theJDBCUtil.closeJDBCConnection(conn);
                    throw throwable;
                }
            }
        }
        this.theJDBCUtil.closeJDBCStatement((Statement)mappingStmt);
        this.theJDBCUtil.closeJDBCConnection(conn);
        return ImmutableMap.of();
    }

    public void removeMapping(MappingSource source, Mapping mapping) throws RecipientRewriteTableException {
        Mappings map = this.getStoredMappings(source);
        if (map.size() > 1) {
            Mappings updatedMappings = map.remove(mapping);
            this.doUpdateMapping(source, updatedMappings.serialize());
        } else {
            this.doRemoveMapping(source, mapping.asString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateMapping(MappingSource source, String mapping) throws RecipientRewriteTableException {
        Connection conn = null;
        PreparedStatement mappingStmt = null;
        try {
            conn = this.dataSource.getConnection();
            mappingStmt = conn.prepareStatement(this.sqlQueries.getSqlString("updateMapping", true));
            ResultSet mappingRS = null;
            try {
                mappingStmt.setString(1, mapping);
                mappingStmt.setString(2, source.getFixedUser());
                mappingStmt.setString(3, source.getFixedDomain());
                if (mappingStmt.executeUpdate() < 1) {
                    throw new RecipientRewriteTableException("Mapping not found");
                }
            }
            finally {
                this.theJDBCUtil.closeJDBCResultSet(mappingRS);
            }
        }
        catch (SQLException sqle) {
            try {
                LOGGER.error("Error accessing database", (Throwable)sqle);
                throw new RecipientRewriteTableException("Error accessing database", (Throwable)sqle);
            }
            catch (Throwable throwable) {
                this.theJDBCUtil.closeJDBCStatement(mappingStmt);
                this.theJDBCUtil.closeJDBCConnection(conn);
                throw throwable;
            }
        }
        this.theJDBCUtil.closeJDBCStatement((Statement)mappingStmt);
        this.theJDBCUtil.closeJDBCConnection(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRemoveMapping(MappingSource source, String mapping) throws RecipientRewriteTableException {
        block10: {
            Connection conn = null;
            PreparedStatement mappingStmt = null;
            try {
                conn = this.dataSource.getConnection();
                mappingStmt = conn.prepareStatement(this.sqlQueries.getSqlString("deleteMapping", true));
                ResultSet mappingRS = null;
                try {
                    mappingStmt.setString(1, source.getFixedUser());
                    mappingStmt.setString(2, source.getFixedDomain());
                    mappingStmt.setString(3, mapping);
                    if (mappingStmt.executeUpdate() < 1) {
                        throw new RecipientRewriteTableException("Mapping not found");
                    }
                }
                finally {
                    this.theJDBCUtil.closeJDBCResultSet(mappingRS);
                }
                this.theJDBCUtil.closeJDBCStatement((Statement)mappingStmt);
            }
            catch (SQLException sqle) {
                LOGGER.error("Error accessing database", (Throwable)sqle);
                break block10;
            }
            finally {
                this.theJDBCUtil.closeJDBCStatement(mappingStmt);
                this.theJDBCUtil.closeJDBCConnection(conn);
            }
            this.theJDBCUtil.closeJDBCConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAddMapping(MappingSource source, String mapping) throws RecipientRewriteTableException {
        block10: {
            Connection conn = null;
            PreparedStatement mappingStmt = null;
            try {
                conn = this.dataSource.getConnection();
                mappingStmt = conn.prepareStatement(this.sqlQueries.getSqlString("addMapping", true));
                ResultSet mappingRS = null;
                try {
                    mappingStmt.setString(1, source.getFixedUser());
                    mappingStmt.setString(2, source.getFixedDomain());
                    mappingStmt.setString(3, mapping);
                    if (mappingStmt.executeUpdate() < 1) {
                        throw new RecipientRewriteTableException("Mapping not found");
                    }
                }
                finally {
                    this.theJDBCUtil.closeJDBCResultSet(mappingRS);
                }
                this.theJDBCUtil.closeJDBCStatement((Statement)mappingStmt);
            }
            catch (SQLException sqle) {
                LOGGER.error("Error accessing database", (Throwable)sqle);
                break block10;
            }
            finally {
                this.theJDBCUtil.closeJDBCStatement(mappingStmt);
                this.theJDBCUtil.closeJDBCConnection(conn);
            }
            this.theJDBCUtil.closeJDBCConnection(conn);
        }
    }
}

