/****************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one   *
 * or more contributor license agreements.  See the NOTICE file *
 * distributed with this work for additional information        *
 * regarding copyright ownership.  The ASF licenses this file   *
 * to you under the Apache License, Version 2.0 (the            *
 * "License"); you may not use this file except in compliance   *
 * with the License.  You may obtain a copy of the License at   *
 *                                                              *
 *   http://www.apache.org/licenses/LICENSE-2.0                 *
 *                                                              *
 * Unless required by applicable law or agreed to in writing,   *
 * software distributed under the License is distributed on an  *
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY       *
 * KIND, either express or implied.  See the License for the    *
 * specific language governing permissions and limitations      *
 * under the License.                                           *
 ****************************************************************/

package org.apache.james.blob.objectstorage;

import java.net.URI;

public class DockerSwift {
    private final URI keystoneV2Endpoint;
    private final URI keystoneV3Endpoint;
    private final URI swiftEndpoint;

    public DockerSwift(URI keystoneV2Endpoint, URI keystoneV3Endpoint, URI swiftEndpoint) {
        this.keystoneV2Endpoint = keystoneV2Endpoint;
        this.keystoneV3Endpoint = keystoneV3Endpoint;
        this.swiftEndpoint = swiftEndpoint;
    }

    public URI keystoneV2Endpoint() {
        return keystoneV2Endpoint;
    }

    public URI keystoneV3Endpoint() {
        return keystoneV3Endpoint;
    }

    public URI swiftEndpoint() {
        return swiftEndpoint;
    }
}
