/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.maildir.mail.model;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Date;
import java.util.List;
import javax.mail.util.SharedFileInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.james.mailbox.maildir.MaildirMessageName;
import org.apache.james.mailbox.model.MessageAttachment;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.mail.model.DefaultMessageId;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.mailbox.store.mail.model.Property;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;
import org.apache.james.mailbox.store.mail.model.impl.PropertyBuilder;
import org.apache.james.mailbox.store.streaming.CountingInputStream;
import org.apache.james.mailbox.store.streaming.LimitingFileInputStream;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.message.DefaultBodyDescriptorBuilder;
import org.apache.james.mime4j.message.MaximalBodyDescriptor;
import org.apache.james.mime4j.stream.BodyDescriptorBuilder;
import org.apache.james.mime4j.stream.EntityState;
import org.apache.james.mime4j.stream.MimeConfig;
import org.apache.james.mime4j.stream.MimeTokenStream;
import org.apache.james.mime4j.stream.RecursionMode;

public class MaildirMessage
implements Message {
    private final MaildirMessageName messageName;
    private int bodyStartOctet;
    private final PropertyBuilder propertyBuilder = new PropertyBuilder();
    private boolean parsed;

    public MaildirMessage(MaildirMessageName messageName) {
        this.messageName = messageName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void parseMessage() {
        block44: {
            if (this.parsed) {
                return;
            }
            SharedFileInputStream tmpMsgIn = null;
            try {
                String boundary;
                String subType;
                String mediaType;
                tmpMsgIn = new SharedFileInputStream(this.messageName.getFile());
                this.bodyStartOctet = this.bodyStartOctet((InputStream)tmpMsgIn);
                MimeTokenStream parser = new MimeTokenStream(MimeConfig.PERMISSIVE, (BodyDescriptorBuilder)new DefaultBodyDescriptorBuilder());
                parser.setRecursionMode(RecursionMode.M_NO_RECURSE);
                parser.parse(tmpMsgIn.newStream(0L, -1L));
                EntityState next = parser.next();
                while (next != EntityState.T_BODY && next != EntityState.T_END_OF_STREAM && next != EntityState.T_START_MULTIPART) {
                    next = parser.next();
                }
                MaximalBodyDescriptor descriptor = (MaximalBodyDescriptor)parser.getBodyDescriptor();
                String mediaTypeFromHeader = descriptor.getMediaType();
                if (mediaTypeFromHeader == null) {
                    mediaType = "text";
                    subType = "plain";
                } else {
                    mediaType = mediaTypeFromHeader;
                    subType = descriptor.getSubType();
                }
                this.propertyBuilder.setMediaType(mediaType);
                this.propertyBuilder.setSubType(subType);
                this.propertyBuilder.setContentID(descriptor.getContentId());
                this.propertyBuilder.setContentDescription(descriptor.getContentDescription());
                this.propertyBuilder.setContentLocation(descriptor.getContentLocation());
                this.propertyBuilder.setContentMD5(descriptor.getContentMD5Raw());
                this.propertyBuilder.setContentTransferEncoding(descriptor.getTransferEncoding());
                this.propertyBuilder.setContentLanguage(descriptor.getContentLanguage());
                this.propertyBuilder.setContentDispositionType(descriptor.getContentDispositionType());
                this.propertyBuilder.setContentDispositionParameters(descriptor.getContentDispositionParameters());
                this.propertyBuilder.setContentTypeParameters(descriptor.getContentTypeParameters());
                String codeset = descriptor.getCharset();
                if (codeset == null) {
                    if ("TEXT".equalsIgnoreCase(mediaType)) {
                        this.propertyBuilder.setCharset("us-ascii");
                    }
                } else {
                    this.propertyBuilder.setCharset(codeset);
                }
                if ((boundary = descriptor.getBoundary()) != null) {
                    this.propertyBuilder.setBoundary(boundary);
                }
                if (!"text".equalsIgnoreCase(mediaType)) break block44;
                long lines = -1L;
                try (CountingInputStream bodyStream = new CountingInputStream(parser.getInputStream());){
                    bodyStream.readAll();
                    lines = bodyStream.getLineCount();
                }
                next = parser.next();
                if (next == EntityState.T_EPILOGUE) {
                    var13_15 = null;
                    try (CountingInputStream epilogueStream = new CountingInputStream(parser.getInputStream());){
                        epilogueStream.readAll();
                        lines += (long)epilogueStream.getLineCount();
                    }
                    catch (Throwable throwable) {
                        var13_15 = throwable;
                        throw throwable;
                    }
                }
                this.propertyBuilder.setTextualLineCount(Long.valueOf(lines));
            }
            catch (IOException | MimeException throwable) {
            }
            finally {
                if (tmpMsgIn != null) {
                    try {
                        tmpMsgIn.close();
                    }
                    catch (IOException iOException) {}
                }
                this.parsed = true;
            }
        }
    }

    private int bodyStartOctet(InputStream msgIn) throws IOException {
        int i;
        PushbackInputStream in = new PushbackInputStream(msgIn, 3);
        int localBodyStartOctet = in.available();
        int count = 0;
        while ((i = in.read()) != -1 && in.available() > 4) {
            if (i == 13) {
                int a = in.read();
                if (a == 10) {
                    int b = in.read();
                    if (b == 13) {
                        int c = in.read();
                        if (c == 10) {
                            localBodyStartOctet = count + 4;
                            break;
                        }
                        in.unread(c);
                    }
                    in.unread(b);
                }
                in.unread(a);
            }
            ++count;
        }
        return localBodyStartOctet;
    }

    public String getMediaType() {
        this.parseMessage();
        return this.propertyBuilder.getMediaType();
    }

    public String getSubType() {
        this.parseMessage();
        return this.propertyBuilder.getSubType();
    }

    public long getBodyOctets() {
        return this.getFullContentOctets() - (long)this.getBodyStartOctet();
    }

    public long getFullContentOctets() {
        Long size = this.messageName.getSize();
        if (size != null) {
            return size;
        }
        try {
            return this.messageName.getFile().length();
        }
        catch (FileNotFoundException e) {
            return -1L;
        }
    }

    public long getHeaderOctets() {
        return this.getBodyStartOctet();
    }

    public Long getTextualLineCount() {
        this.parseMessage();
        return this.propertyBuilder.getTextualLineCount();
    }

    public List<Property> getProperties() {
        this.parseMessage();
        return this.propertyBuilder.toProperties();
    }

    public MessageId getMessageId() {
        return new DefaultMessageId();
    }

    public Date getInternalDate() {
        return this.messageName.getInternalDate();
    }

    public InputStream getFullContent() throws IOException {
        return new FileInputStream(this.messageName.getFile());
    }

    public InputStream getBodyContent() throws IOException {
        this.parseMessage();
        FileInputStream body = new FileInputStream(this.messageName.getFile());
        IOUtils.skipFully((InputStream)body, (long)this.bodyStartOctet);
        return body;
    }

    private int getBodyStartOctet() {
        this.parseMessage();
        return this.bodyStartOctet;
    }

    public InputStream getHeaderContent() throws IOException {
        this.parseMessage();
        long limit = this.getBodyStartOctet();
        if (limit < 0L) {
            limit = 0L;
        }
        return new LimitingFileInputStream(this.messageName.getFile(), limit);
    }

    public List<MessageAttachment> getAttachments() {
        try {
            return new MessageParser().retrieveAttachments(this.getFullContent());
        }
        catch (IOException | MimeException e) {
            throw new RuntimeException(e);
        }
    }
}

