/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.util.List;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.main.PathConverter;
import org.apache.james.imap.message.request.GetACLRequest;
import org.apache.james.imap.message.response.ACLResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetACLProcessor
extends AbstractMailboxProcessor<GetACLRequest>
implements CapabilityImplementingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetACLProcessor.class);
    private static final List<String> CAPABILITIES = ImmutableList.of((Object)"ACL");

    public GetACLProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(GetACLRequest.class, next, mailboxManager, factory, metricFactory);
    }

    @Override
    protected void doProcess(GetACLRequest message, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        MailboxManager mailboxManager = this.getMailboxManager();
        MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession(session);
        String mailboxName = message.getMailboxName();
        try {
            MailboxPath mailboxPath = PathConverter.forSession(session).buildFullPath(mailboxName);
            MessageManager messageManager = mailboxManager.getMailbox(mailboxPath, mailboxSession);
            if (!mailboxManager.hasRight(mailboxPath, MailboxACL.Right.Lookup, mailboxSession)) {
                this.no(command, tag, responder, HumanReadableText.MAILBOX_NOT_FOUND);
            } else if (!mailboxManager.hasRight(mailboxPath, MailboxACL.Right.Administer, mailboxSession)) {
                Object[] params = new Object[]{MailboxACL.Right.Administer.toString(), command.getName(), mailboxName};
                HumanReadableText text = new HumanReadableText("org.apache.james.imap.UNSUFFICIENT_RIGHTS", "You need the {0} right to perform command {1} on mailbox {2}.", params);
                this.no(command, tag, responder, text);
            } else {
                MessageManager.MetaData metaData = messageManager.getMetaData(false, mailboxSession, MessageManager.MetaData.FetchGroup.NO_COUNT);
                ACLResponse aclResponse = new ACLResponse(mailboxName, metaData.getACL());
                responder.respond(aclResponse);
                this.okComplete(command, tag, responder);
            }
        }
        catch (MailboxNotFoundException e) {
            this.no(command, tag, responder, HumanReadableText.MAILBOX_NOT_FOUND);
        }
        catch (MailboxException e) {
            LOGGER.error("{} failed for mailbox {}", new Object[]{command.getName(), mailboxName, e});
            this.no(command, tag, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING);
        }
    }

    @Override
    public List<String> getImplementedCapabilities(ImapSession session) {
        return CAPABILITIES;
    }

    @Override
    protected Closeable addContextToMDC(GetACLRequest message) {
        return MDCBuilder.create().addContext("action", (Object)"GET_ACL").addContext("mailbox", (Object)message.getMailboxName()).build();
    }
}

