/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.mail.Flags;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.UidRange;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.main.PathConverter;
import org.apache.james.imap.message.request.AppendRequest;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppendProcessor
extends AbstractMailboxProcessor<AppendRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppendProcessor.class);

    public AppendProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory statusResponseFactory, MetricFactory metricFactory) {
        super(AppendRequest.class, next, mailboxManager, statusResponseFactory, metricFactory);
    }

    @Override
    protected void doProcess(AppendRequest request, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        String mailboxName = request.getMailboxName();
        InputStream messageIn = request.getMessage();
        Date datetime = request.getDatetime();
        Flags flags = request.getFlags();
        MailboxPath mailboxPath = PathConverter.forSession(session).buildFullPath(mailboxName);
        try {
            MailboxManager mailboxManager = this.getMailboxManager();
            MessageManager mailbox = mailboxManager.getMailbox(mailboxPath, ImapSessionUtils.getMailboxSession(session));
            this.appendToMailbox(messageIn, datetime, flags, session, tag, command, mailbox, responder, mailboxPath);
        }
        catch (MailboxNotFoundException e) {
            this.consume(messageIn);
            LOGGER.debug("Append failed for mailbox {}", (Object)mailboxPath, (Object)e);
            this.tryCreate(session, tag, command, responder, e);
        }
        catch (MailboxException e) {
            this.consume(messageIn);
            LOGGER.error("Append failed for mailbox {}", (Object)mailboxPath, (Object)e);
            this.no(command, tag, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING);
        }
    }

    private void consume(InputStream in) {
        try {
            IOUtils.copy((InputStream)in, (OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void tryCreate(ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder, MailboxNotFoundException e) {
        LOGGER.debug("Cannot open mailbox: ", (Throwable)e);
        this.no(command, tag, responder, HumanReadableText.FAILURE_NO_SUCH_MAILBOX, StatusResponse.ResponseCode.tryCreate());
    }

    private void appendToMailbox(InputStream message, Date datetime, Flags flagsToBeSet, ImapSession session, String tag, ImapCommand command, MessageManager mailbox, ImapProcessor.Responder responder, MailboxPath mailboxPath) {
        try {
            MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession(session);
            SelectedMailbox selectedMailbox = session.getSelected();
            MailboxManager mailboxManager = this.getMailboxManager();
            boolean isSelectedMailbox = selectedMailbox != null && selectedMailbox.getPath().equals((Object)mailboxPath);
            ComposedMessageId messageId = mailbox.appendMessage(message, datetime, mailboxSession, !isSelectedMailbox, flagsToBeSet);
            if (isSelectedMailbox) {
                selectedMailbox.addRecent(messageId.getUid());
            }
            Long uidValidity = mailboxManager.getMailbox(mailboxPath, mailboxSession).getMetaData(false, mailboxSession, MessageManager.MetaData.FetchGroup.NO_COUNT).getUidValidity();
            this.unsolicitedResponses(session, responder, false);
            this.okComplete(command, tag, StatusResponse.ResponseCode.appendUid(uidValidity, new UidRange[]{new UidRange(messageId.getUid())}), responder);
        }
        catch (MailboxNotFoundException e) {
            this.tryCreate(session, tag, command, responder, e);
        }
        catch (MailboxException e) {
            LOGGER.error("Unable to append message to mailbox {}", (Object)mailboxPath, (Object)e);
            this.no(command, tag, responder, HumanReadableText.SAVE_FAILED);
        }
    }

    @Override
    protected Closeable addContextToMDC(AppendRequest message) {
        return MDCBuilder.create().addContext("action", (Object)"APPEND").addContext("mailbox", (Object)message.getMailboxName()).build();
    }
}

