/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.message.response;

import java.util.Arrays;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.mailbox.model.MailboxACL;

public final class ListRightsResponse
implements ImapResponseMessage {
    private final String identifier;
    private final String mailboxName;
    private final MailboxACL.Rfc4314Rights[] rights;

    public ListRightsResponse(String mailboxName, String identifier, MailboxACL.Rfc4314Rights[] rights) {
        this.mailboxName = mailboxName;
        this.identifier = identifier;
        this.rights = rights;
    }

    public boolean equals(Object o) {
        if (o instanceof ListRightsResponse) {
            ListRightsResponse other = (ListRightsResponse)o;
            return (this.mailboxName == other.mailboxName || this.mailboxName != null && this.mailboxName.equals(other.mailboxName)) && (this.identifier == other.identifier || this.identifier != null && this.identifier.equals(other.identifier)) && Arrays.equals(this.rights, other.rights);
        }
        return false;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getMailboxName() {
        return this.mailboxName;
    }

    public MailboxACL.Rfc4314Rights[] getRights() {
        return this.rights;
    }

    public int hashCode() {
        int PRIME = 31;
        int hashCode = this.mailboxName == null ? 0 : this.mailboxName.hashCode();
        hashCode = 31 * hashCode + (this.identifier == null ? 0 : this.identifier.hashCode());
        hashCode = 31 * hashCode + (this.rights == null ? 0 : Arrays.hashCode(this.rights));
        return hashCode;
    }

    public String toString() {
        StringBuilder result = new StringBuilder().append("LISTRIGHTS").append(' ').append(this.mailboxName).append(' ').append(this.identifier);
        for (MailboxACL.Rfc4314Rights optionalRightsGroup : this.rights) {
            result.append(' ').append(optionalRightsGroup.toString());
        }
        return result.toString();
    }
}

