/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.main;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.util.List;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.main.DeniedAccessOnSharedMailboxException;
import org.apache.james.mailbox.model.MailboxPath;

public class PathConverter {
    private static final int NAMESPACE = 0;
    private final ImapSession session;

    public static PathConverter forSession(ImapSession session) {
        return new PathConverter(session);
    }

    private PathConverter(ImapSession session) {
        this.session = session;
    }

    public MailboxPath buildFullPath(String mailboxName) {
        if (Strings.isNullOrEmpty((String)mailboxName)) {
            return this.buildDefaultPath();
        }
        if (this.isAbsolute(mailboxName)) {
            return this.buildAbsolutePath(mailboxName);
        }
        return this.buildRelativePath(mailboxName);
    }

    private MailboxPath buildDefaultPath() {
        return new MailboxPath("", "", "");
    }

    private boolean isAbsolute(String mailboxName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)mailboxName) ? 1 : 0) != 0);
        return mailboxName.charAt(0) == '#';
    }

    private MailboxPath buildRelativePath(String mailboxName) {
        return this.buildMailboxPath("#private", ImapSessionUtils.getUserName(this.session), mailboxName);
    }

    private MailboxPath buildAbsolutePath(String absolutePath) {
        char pathDelimiter = ImapSessionUtils.getMailboxSession(this.session).getPathDelimiter();
        List mailboxPathParts = Splitter.on((char)pathDelimiter).splitToList((CharSequence)absolutePath);
        String namespace = (String)mailboxPathParts.get(0);
        String mailboxName = Joiner.on((char)pathDelimiter).join(Iterables.skip((Iterable)mailboxPathParts, (int)1));
        return this.buildMailboxPath(namespace, this.retrieveUserName(namespace), mailboxName);
    }

    private String retrieveUserName(String namespace) {
        if (namespace.equals("#private")) {
            return ImapSessionUtils.getUserName(this.session);
        }
        return null;
    }

    private MailboxPath buildMailboxPath(String namespace, String user, String mailboxName) {
        if (!namespace.equals("#private")) {
            throw new DeniedAccessOnSharedMailboxException();
        }
        return new MailboxPath(namespace, user, this.sanitizeMailboxName(mailboxName));
    }

    private String sanitizeMailboxName(String mailboxName) {
        if (mailboxName.equalsIgnoreCase("INBOX")) {
            return "INBOX";
        }
        return mailboxName;
    }
}

