/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import java.io.IOException;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.base.AbstractChainedImapEncoder;
import org.apache.james.imap.message.response.ListRightsResponse;
import org.apache.james.mailbox.model.MailboxACL;

public class ListRightsResponseEncoder
extends AbstractChainedImapEncoder {
    public ListRightsResponseEncoder(ImapEncoder next) {
        super(next);
    }

    @Override
    protected void doEncode(ImapMessage acceptableMessage, ImapResponseComposer composer, ImapSession session) throws IOException {
        MailboxACL.Rfc4314Rights[] rights;
        ListRightsResponse listRightsResponse = (ListRightsResponse)acceptableMessage;
        composer.untagged();
        composer.commandName("LISTRIGHTS");
        String mailboxName = listRightsResponse.getMailboxName();
        composer.mailbox(mailboxName == null ? "" : mailboxName);
        String identifier = listRightsResponse.getIdentifier();
        composer.quote(identifier);
        for (MailboxACL.Rfc4314Rights entry : rights = listRightsResponse.getRights()) {
            composer.quote(entry.serialize());
        }
        composer.end();
    }

    @Override
    public boolean isAcceptable(ImapMessage message) {
        return message instanceof ListRightsResponse;
    }
}

