/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import javax.mail.Flags;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.parser.AbstractUidCommandParser;
import org.apache.james.imap.message.request.StoreRequest;
import org.apache.james.protocols.imap.DecodingException;

public class StoreCommandParser
extends AbstractUidCommandParser {
    private static final byte[] UNCHANGEDSINCE = "UNCHANGEDSINCE".getBytes();

    public StoreCommandParser() {
        super(ImapCommand.selectedStateCommand("STORE"));
    }

    @Override
    protected ImapMessage decode(ImapCommand command, ImapRequestLineReader request, String tag, boolean useUids, ImapSession session) throws DecodingException {
        Boolean sign;
        IdRange[] idSet = request.parseIdRange(session);
        boolean silent = false;
        long unchangedSince = -1L;
        char next = request.nextWordChar();
        if (next == '(') {
            request.consume();
            request.consumeWord(new ImapRequestLineReader.CharacterValidator(){
                private int pos = 0;

                @Override
                public boolean isValid(char chr) {
                    if (this.pos >= UNCHANGEDSINCE.length) {
                        return false;
                    }
                    return ImapRequestLineReader.cap(chr) == UNCHANGEDSINCE[this.pos++];
                }
            });
            request.consumeChar(' ');
            unchangedSince = request.number(true);
            request.consumeChar(')');
            next = request.nextWordChar();
        }
        if (next == '+') {
            sign = Boolean.TRUE;
            request.consume();
        } else if (next == '-') {
            sign = Boolean.FALSE;
            request.consume();
        } else {
            sign = null;
        }
        String directive = request.consumeWord(new ImapRequestLineReader.NoopCharValidator());
        if ("FLAGS".equalsIgnoreCase(directive)) {
            silent = false;
        } else if ("FLAGS.SILENT".equalsIgnoreCase(directive)) {
            silent = true;
        } else {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Invalid Store Directive: '" + directive + "'");
        }
        Flags flags = new Flags();
        if (request.nextWordChar() == '(') {
            flags.add(request.flagList());
        } else {
            boolean moreFlags = true;
            while (moreFlags) {
                flags.add(request.flag());
                try {
                    request.consumeChar(' ');
                }
                catch (DecodingException e) {
                    moreFlags = false;
                }
            }
        }
        request.eol();
        return new StoreRequest(command, idSet, silent, flags, useUids, tag, sign, unchangedSince);
    }
}

