/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.api;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.mailbox.MailboxSession;

public class ImapSessionUtils {
    public static final String MAILBOX_USER_ATTRIBUTE_SESSION_KEY = "org.apache.james.api.imap.MAILBOX_USER_ATTRIBUTE_SESSION_KEY";
    public static final String MAILBOX_SESSION_ATTRIBUTE_SESSION_KEY = "org.apache.james.api.imap.MAILBOX_SESSION_ATTRIBUTE_SESSION_KEY";

    public static MailboxSession getMailboxSession(ImapSession session) {
        return (MailboxSession)session.getAttribute(MAILBOX_SESSION_ATTRIBUTE_SESSION_KEY);
    }

    public static String getUserName(ImapSession imapSession) {
        Preconditions.checkNotNull((Object)imapSession);
        return Optional.ofNullable(ImapSessionUtils.getMailboxSession(imapSession)).map(mailboxSession -> mailboxSession.getUser().asString()).orElse(null);
    }
}

