/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.events.delivery;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import javax.inject.Inject;
import org.apache.james.mailbox.events.Event;
import org.apache.james.mailbox.events.EventBus;
import org.apache.james.mailbox.events.MailboxListener;
import org.apache.james.mailbox.events.delivery.EventDelivery;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.TimeMetric;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.MDCStructuredLogger;
import org.apache.james.util.StructuredLogger;
import org.reactivestreams.Subscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;
import reactor.core.scheduler.Schedulers;

public class InVmEventDelivery
implements EventDelivery {
    private static final Logger LOGGER = LoggerFactory.getLogger(InVmEventDelivery.class);
    private final MetricFactory metricFactory;

    @Inject
    @VisibleForTesting
    public InVmEventDelivery(MetricFactory metricFactory) {
        this.metricFactory = metricFactory;
    }

    @Override
    public EventDelivery.ExecutionStages deliver(MailboxListener listener, Event event, EventDelivery.DeliveryOption option) {
        Mono<Void> executionResult = this.deliverByOption(listener, event, option);
        return this.toExecutionStages(listener.getExecutionMode(), executionResult);
    }

    private EventDelivery.ExecutionStages toExecutionStages(MailboxListener.ExecutionMode executionMode, Mono<Void> executionResult) {
        if (executionMode.equals((Object)MailboxListener.ExecutionMode.SYNCHRONOUS)) {
            return EventDelivery.ExecutionStages.synchronous(executionResult);
        }
        return EventDelivery.ExecutionStages.asynchronous(executionResult);
    }

    private Mono<Void> deliverByOption(MailboxListener listener, Event event, EventDelivery.DeliveryOption deliveryOption) {
        Mono deliveryToListener = Mono.fromRunnable(() -> this.doDeliverToListener(listener, event)).doOnError(throwable -> this.structuredLogger(event, listener).log(logger -> logger.error("Error while processing listener", throwable))).subscribeOn(Schedulers.elastic()).then();
        return ((MonoProcessor)deliveryOption.getRetrier().doRetry((Mono<Void>)deliveryToListener, event).onErrorResume(throwable -> deliveryOption.getPermanentFailureHandler().handle(event)).subscribeWith((Subscriber)MonoProcessor.create())).subscribeOn(Schedulers.elastic()).then();
    }

    private void doDeliverToListener(MailboxListener mailboxListener, Event event) {
        TimeMetric timer = this.metricFactory.timer(EventBus.Metrics.timerName((MailboxListener)mailboxListener));
        try (Closeable mdc = MDCBuilder.create().addContext("eventId", (Object)event.getEventId()).addContext("eventClass", event.getClass()).addContext("user", (Object)event.getUser()).addContext("listenerClass", mailboxListener.getClass()).build();){
            mailboxListener.event(event);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            timer.stopAndPublish();
        }
    }

    private StructuredLogger structuredLogger(Event event, MailboxListener mailboxListener) {
        return MDCStructuredLogger.forLogger((Logger)LOGGER).addField("eventId", (Object)event.getEventId()).addField("eventClass", event.getClass()).addField("user", (Object)event.getUser()).addField("listenerClass", mailboxListener.getClass());
    }
}

