/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.events;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import org.apache.james.mailbox.events.Event;
import org.apache.james.mailbox.events.EventDeadLetters;
import org.apache.james.mailbox.events.Group;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;

public class MemoryEventDeadLetters
implements EventDeadLetters {
    private static final String REGISTERED_GROUP_CANNOT_BE_NULL = "registeredGroup cannot be null";
    private static final String FAIL_DELIVERED_EVENT_CANNOT_BE_NULL = "failDeliveredEvent cannot be null";
    private static final String FAIL_DELIVERED_ID_EVENT_CANNOT_BE_NULL = "failDeliveredEventId cannot be null";
    private final Multimap<Group, Event> deadLetters = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());

    public Mono<Void> store(Group registeredGroup, Event failDeliveredEvent) {
        Preconditions.checkArgument((registeredGroup != null ? 1 : 0) != 0, (Object)REGISTERED_GROUP_CANNOT_BE_NULL);
        Preconditions.checkArgument((failDeliveredEvent != null ? 1 : 0) != 0, (Object)FAIL_DELIVERED_EVENT_CANNOT_BE_NULL);
        return ((MonoProcessor)Mono.fromRunnable(() -> this.deadLetters.put((Object)registeredGroup, (Object)failDeliveredEvent)).subscribeWith((Subscriber)MonoProcessor.create())).then();
    }

    public Mono<Void> remove(Group registeredGroup, Event.EventId failDeliveredEventId) {
        Preconditions.checkArgument((registeredGroup != null ? 1 : 0) != 0, (Object)REGISTERED_GROUP_CANNOT_BE_NULL);
        Preconditions.checkArgument((failDeliveredEventId != null ? 1 : 0) != 0, (Object)FAIL_DELIVERED_ID_EVENT_CANNOT_BE_NULL);
        return ((MonoProcessor)Flux.fromIterable((Iterable)this.deadLetters.get((Object)registeredGroup)).filter(event -> event.getEventId().equals((Object)failDeliveredEventId)).next().doOnNext(event -> this.deadLetters.remove((Object)registeredGroup, event)).subscribeWith((Subscriber)MonoProcessor.create())).then();
    }

    public Mono<Event> failedEvent(Group registeredGroup, Event.EventId failDeliveredEventId) {
        Preconditions.checkArgument((registeredGroup != null ? 1 : 0) != 0, (Object)REGISTERED_GROUP_CANNOT_BE_NULL);
        Preconditions.checkArgument((failDeliveredEventId != null ? 1 : 0) != 0, (Object)FAIL_DELIVERED_ID_EVENT_CANNOT_BE_NULL);
        return Flux.fromIterable((Iterable)this.deadLetters.get((Object)registeredGroup)).filter(event -> event.getEventId().equals((Object)failDeliveredEventId)).next();
    }

    public Flux<Event.EventId> failedEventIds(Group registeredGroup) {
        Preconditions.checkArgument((registeredGroup != null ? 1 : 0) != 0, (Object)REGISTERED_GROUP_CANNOT_BE_NULL);
        return Flux.fromIterable((Iterable)this.deadLetters.get((Object)registeredGroup)).map(Event::getEventId);
    }

    public Flux<Group> groupsWithFailedEvents() {
        return Flux.fromIterable((Iterable)this.deadLetters.keySet());
    }
}

