/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.meta;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.StringDistance;
import org.apache.openjpa.lib.util.StringUtil;
import org.apache.openjpa.meta.MetaDataRepository;

public abstract class Extensions
implements Serializable {
    public static final String OPENJPA = "openjpa";
    private static final Localizer _loc = Localizer.forPackage(Extensions.class);
    private Map _exts = null;
    private Map _embed = null;

    public boolean isEmpty() {
        return !(this._exts != null && !this._exts.isEmpty() || this._embed != null && !this._embed.isEmpty());
    }

    public String[] getExtensionVendors() {
        if (this._exts == null || this._exts.isEmpty()) {
            return new String[0];
        }
        TreeSet<String> vendors = new TreeSet<String>();
        Iterator itr = this._exts.keySet().iterator();
        while (itr.hasNext()) {
            vendors.add(this.getVendor(itr.next()));
        }
        return vendors.toArray(new String[vendors.size()]);
    }

    public String[] getExtensionKeys() {
        return this.getExtensionKeys(OPENJPA);
    }

    public String[] getExtensionKeys(String vendor) {
        if (this._exts == null || this._exts.isEmpty()) {
            return new String[0];
        }
        TreeSet<String> keys = new TreeSet<String>();
        for (Object key : this._exts.keySet()) {
            if (!vendor.equals(this.getVendor(key))) continue;
            keys.add(this.getKey(key));
        }
        return keys.toArray(new String[keys.size()]);
    }

    public boolean hasExtension(String key) {
        return this.hasExtension(OPENJPA, key);
    }

    public boolean hasExtension(String vendor, String key) {
        return this._exts != null && this._exts.containsKey(this.getHashKey(vendor, key));
    }

    public void addExtension(String key, Object value) {
        this.addExtension(OPENJPA, key, value);
    }

    public void addExtension(String vendor, String key, Object value) {
        if (this._exts == null) {
            this._exts = new HashMap();
        }
        this._exts.put(this.getHashKey(vendor, key), value);
    }

    public boolean removeExtension(String key) {
        return this.removeExtension(OPENJPA, key);
    }

    public boolean removeExtension(String vendor, String key) {
        if (this._exts != null && this._exts.remove(this.getHashKey(vendor, key)) != null) {
            this.removeEmbeddedExtensions(key);
            return true;
        }
        return false;
    }

    public Object getObjectExtension(String key) {
        return this.getObjectExtension(OPENJPA, key);
    }

    public Object getObjectExtension(String vendor, String key) {
        if (this._exts == null) {
            return null;
        }
        return this._exts.get(this.getHashKey(vendor, key));
    }

    public String getStringExtension(String key) {
        return this.getStringExtension(OPENJPA, key);
    }

    public String getStringExtension(String vendor, String key) {
        Object val = this.getObjectExtension(vendor, key);
        return val == null ? null : val.toString();
    }

    public int getIntExtension(String key) {
        return this.getIntExtension(OPENJPA, key);
    }

    public int getIntExtension(String vendor, String key) {
        String str = this.getStringExtension(vendor, key);
        return str == null ? 0 : Integer.parseInt(str);
    }

    public double getDoubleExtension(String key) {
        return this.getDoubleExtension(OPENJPA, key);
    }

    public double getDoubleExtension(String vendor, String key) {
        String str = this.getStringExtension(vendor, key);
        return str == null ? 0.0 : Double.parseDouble(str);
    }

    public boolean getBooleanExtension(String key) {
        return this.getBooleanExtension(OPENJPA, key);
    }

    public boolean getBooleanExtension(String vendor, String key) {
        String str = this.getStringExtension(vendor, key);
        return str == null ? false : Boolean.valueOf(str);
    }

    public Extensions getEmbeddedExtensions(String key, boolean create) {
        return this.getEmbeddedExtensions(OPENJPA, key, create);
    }

    public Extensions getEmbeddedExtensions(String vendor, String key, boolean create) {
        Object hk;
        Extensions exts;
        if (this._embed == null && !create) {
            return null;
        }
        if (this._embed == null) {
            this._embed = new HashMap();
        }
        if ((exts = (Extensions)this._embed.get(hk = this.getHashKey(vendor, key))) == null && !create) {
            return null;
        }
        if (exts == null) {
            exts = new EmbeddedExtensions(this);
            this._embed.put(hk, exts);
            if (this._exts == null) {
                this._exts = new HashMap();
            }
            if (!this._exts.containsKey(hk)) {
                this._exts.put(hk, null);
            }
        }
        return exts;
    }

    public boolean removeEmbeddedExtensions(String key) {
        return this.removeEmbeddedExtensions(OPENJPA, key);
    }

    public boolean removeEmbeddedExtensions(String vendor, String key) {
        return this._embed != null && this._embed.remove(this.getHashKey(vendor, key)) != null;
    }

    protected void copy(Extensions exts) {
        if (exts.isEmpty()) {
            return;
        }
        if (exts._exts != null && !exts._exts.isEmpty()) {
            if (this._exts == null) {
                this._exts = new HashMap();
            }
            for (Map.Entry entry : exts._exts.entrySet()) {
                if (this._exts.containsKey(entry.getKey())) continue;
                this._exts.put(entry.getKey(), entry.getValue());
            }
        }
        if (exts._embed != null && !exts._embed.isEmpty()) {
            if (this._embed == null) {
                this._embed = new HashMap();
            }
            for (Map.Entry entry : exts._embed.entrySet()) {
                Extensions embedded = (Extensions)this._embed.get(entry.getKey());
                if (embedded == null) {
                    embedded = new EmbeddedExtensions(this);
                    this._embed.put(entry.getKey(), embedded);
                }
                embedded.copy((Extensions)entry.getValue());
            }
        }
    }

    public void validateExtensionKeys() {
        if (this._exts == null || this._exts.isEmpty()) {
            return;
        }
        OpenJPAConfiguration conf = this.getRepository().getConfiguration();
        Log log = conf.getLog("openjpa.MetaData");
        if (!log.isWarnEnabled()) {
            return;
        }
        TreeSet validNames = new TreeSet();
        this.addExtensionKeys(validNames);
        String prefixes = _loc.get("extension-datastore-prefix").getMessage();
        String[] allowedPrefixes = null;
        if (prefixes != null) {
            allowedPrefixes = StringUtil.split(prefixes, ",", 0);
        }
        block0: for (Object next : this._exts.keySet()) {
            String closestName;
            String key;
            if (!OPENJPA.equals(this.getVendor(next)) || validNames.contains(key = this.getKey(next))) continue;
            if (allowedPrefixes != null) {
                for (int j = 0; j < allowedPrefixes.length; ++j) {
                    if (key.startsWith(allowedPrefixes[j]) && !this.validateDataStoreExtensionPrefix(allowedPrefixes[j])) continue block0;
                }
            }
            if ((closestName = StringDistance.getClosestLevenshteinDistance(key, validNames, 0.5f)) == null) {
                log.warn(_loc.get("unrecognized-extension", this, key, validNames));
                continue;
            }
            log.warn(_loc.get("unrecognized-extension-hint", new Object[]{this, key, validNames, closestName}));
        }
    }

    protected void addExtensionKeys(Collection exts) {
    }

    protected boolean validateDataStoreExtensionPrefix(String prefix) {
        return false;
    }

    public abstract MetaDataRepository getRepository();

    private Object getHashKey(String vendor, String key) {
        if (OPENJPA.equals(vendor)) {
            return key;
        }
        return new HashKey(vendor, key);
    }

    private String getVendor(Object hashKey) {
        return hashKey instanceof String ? OPENJPA : ((HashKey)hashKey).vendor;
    }

    private String getKey(Object hashKey) {
        return hashKey instanceof String ? (String)hashKey : ((HashKey)hashKey).key;
    }

    private static class EmbeddedExtensions
    extends Extensions {
        private final Extensions _parent;

        public EmbeddedExtensions(Extensions parent) {
            this._parent = parent;
        }

        @Override
        public MetaDataRepository getRepository() {
            return this._parent.getRepository();
        }
    }

    private static class HashKey
    implements Serializable {
        public final String vendor;
        public final String key;

        public HashKey(String vendor, String key) {
            this.vendor = vendor;
            this.key = key;
        }

        public int hashCode() {
            int i = 0;
            if (this.vendor != null) {
                i = this.vendor.hashCode();
            }
            if (this.key != null) {
                i += 17 * this.key.hashCode();
            }
            return i;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            HashKey hk = (HashKey)other;
            return Objects.equals(this.vendor, hk.vendor) && Objects.equals(this.key, hk.key);
        }
    }
}

