/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.message.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.LinkedList;
import java.util.Set;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQPropertyConversionException;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RefCountMessage;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.buffers.impl.ChannelBufferWrapper;
import org.apache.activemq.artemis.core.buffers.impl.ResetLimitWrappedActiveMQBuffer;
import org.apache.activemq.artemis.core.message.LargeBodyEncoder;
import org.apache.activemq.artemis.core.message.impl.CoreMessageObjectPools;
import org.apache.activemq.artemis.core.message.impl.CoreMessagePersister;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.reader.MessageUtil;
import org.apache.activemq.artemis.utils.ByteUtil;
import org.apache.activemq.artemis.utils.UUID;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.jboss.logging.Logger;

public class CoreMessage
extends RefCountMessage
implements ICoreMessage {
    public static final int BUFFER_HEADER_SPACE = 13;
    private volatile int memoryEstimate = -1;
    private static final Logger logger = Logger.getLogger(CoreMessage.class);
    public static final int BODY_OFFSET = 4;
    protected ByteBuf buffer;
    private volatile boolean validBuffer = false;
    protected volatile ResetLimitWrappedActiveMQBuffer writableBuffer;
    Object body;
    protected int endOfBodyPosition = -1;
    protected int messageIDPosition = -1;
    protected long messageID;
    protected SimpleString address;
    protected byte type;
    protected boolean durable;
    private long expiration;
    protected long timestamp;
    protected byte priority;
    private UUID userID;
    private int propertiesLocation = -1;
    protected volatile TypedProperties properties;
    private final CoreMessageObjectPools coreMessageObjectPools;

    public CoreMessage(CoreMessageObjectPools coreMessageObjectPools) {
        this.coreMessageObjectPools = coreMessageObjectPools;
    }

    public CoreMessage() {
        this.coreMessageObjectPools = null;
    }

    @Override
    public Object getAnnotation(SimpleString key) {
        return this.getObjectProperty(key);
    }

    @Override
    public Object removeAnnotation(SimpleString key) {
        return this.removeProperty(key);
    }

    @Override
    public void cleanupInternalProperties() {
        if (this.properties.hasInternalProperties()) {
            LinkedList<SimpleString> valuesToRemove = null;
            for (SimpleString name : this.getPropertyNames()) {
                if ((!name.startsWith(Message.HDR_ROUTE_TO_IDS) || name.equals((Object)Message.HDR_ROUTE_TO_IDS)) && (!name.startsWith(Message.HDR_ROUTE_TO_ACK_IDS) || name.equals((Object)Message.HDR_ROUTE_TO_ACK_IDS))) continue;
                if (valuesToRemove == null) {
                    valuesToRemove = new LinkedList<SimpleString>();
                }
                valuesToRemove.add(name);
            }
            if (valuesToRemove != null) {
                for (SimpleString removal : valuesToRemove) {
                    this.removeProperty(removal);
                }
            }
        }
    }

    @Override
    public Persister<Message> getPersister() {
        return CoreMessagePersister.getInstance();
    }

    public CoreMessage initBuffer(int initialMessageBufferSize) {
        this.buffer = ActiveMQBuffers.dynamicBuffer((int)initialMessageBufferSize).byteBuf();
        this.buffer.writeByte(0);
        this.buffer.setIndex(4, 4);
        return this;
    }

    @Override
    public SimpleString getReplyTo() {
        return this.getSimpleStringProperty(MessageUtil.REPLYTO_HEADER_NAME);
    }

    @Override
    public RoutingType getRoutingType() {
        if (this.containsProperty(Message.HDR_ROUTING_TYPE)) {
            return RoutingType.getType((byte)this.getByteProperty(Message.HDR_ROUTING_TYPE));
        }
        return null;
    }

    @Override
    public Message setRoutingType(RoutingType routingType) {
        if (routingType == null) {
            this.removeProperty(Message.HDR_ROUTING_TYPE);
        } else {
            this.putByteProperty(Message.HDR_ROUTING_TYPE, routingType.getType());
        }
        return this;
    }

    @Override
    public CoreMessage setReplyTo(SimpleString address) {
        if (address == null) {
            this.checkProperties();
            this.properties.removeProperty(MessageUtil.REPLYTO_HEADER_NAME);
        } else {
            this.putStringProperty(MessageUtil.REPLYTO_HEADER_NAME, address);
        }
        return this;
    }

    @Override
    public void receiveBuffer(ByteBuf buffer) {
        this.buffer = buffer;
        this.buffer.retain();
        this.decode(false);
    }

    @Override
    public void receiveBuffer_1X(ByteBuf buffer) {
        this.buffer = buffer;
        this.buffer.retain();
        this.decode(true);
        this.validBuffer = false;
    }

    @Override
    public ActiveMQBuffer getReadOnlyBodyBuffer() {
        this.checkEncode();
        this.internalWritableBuffer();
        return new ChannelBufferWrapper(this.buffer.slice(4, this.endOfBodyPosition - 13).setIndex(0, this.endOfBodyPosition - 13).asReadOnly());
    }

    @Override
    public ActiveMQBuffer getDataBuffer() {
        ActiveMQBuffer buffer;
        try {
            buffer = this.isLargeMessage() ? this.getLargeMessageBuffer() : this.getReadOnlyBodyBuffer();
            if (Boolean.TRUE.equals(this.getBooleanProperty(Message.HDR_LARGE_COMPRESSED))) {
                buffer = this.inflate(buffer);
            }
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            return this.getReadOnlyBodyBuffer();
        }
        return buffer;
    }

    private ActiveMQBuffer getLargeMessageBuffer() throws ActiveMQException {
        LargeBodyEncoder encoder = this.getBodyEncoder();
        encoder.open();
        int bodySize = (int)encoder.getLargeBodySize();
        ChannelBufferWrapper buffer = new ChannelBufferWrapper(UnpooledByteBufAllocator.DEFAULT.heapBuffer(bodySize));
        encoder.encode((ActiveMQBuffer)buffer, bodySize);
        encoder.close();
        return buffer;
    }

    private ActiveMQBuffer inflate(ActiveMQBuffer buffer) throws DataFormatException {
        int bytesToRead = buffer.readableBytes();
        Inflater inflater = new Inflater();
        inflater.setInput(ByteUtil.getActiveArray((ByteBuffer)buffer.readBytes(bytesToRead).toByteBuffer()));
        long sizeBody = this.getLongProperty(Message.HDR_LARGE_BODY_SIZE);
        byte[] data = new byte[(int)sizeBody];
        inflater.inflate(data);
        inflater.end();
        ActiveMQBuffer qbuff = ActiveMQBuffers.wrappedBuffer((byte[])data);
        qbuff.resetReaderIndex();
        qbuff.resetWriterIndex();
        qbuff.writeBytes(data);
        buffer = qbuff;
        return buffer;
    }

    @Override
    public SimpleString getGroupID() {
        return this.getSimpleStringProperty(Message.HDR_GROUP_ID);
    }

    @Override
    public void sendBuffer(ByteBuf sendBuffer, int deliveryCount) {
        this.checkEncode();
        sendBuffer.writeBytes(this.buffer, 0, this.buffer.writerIndex());
    }

    @Override
    public void sendBuffer_1X(ByteBuf sendBuffer) {
        this.checkEncode();
        ByteBuf tmpBuffer = this.buffer.duplicate();
        sendBuffer.writeInt(this.endOfBodyPosition + 4);
        tmpBuffer.readerIndex(4);
        tmpBuffer.readBytes(sendBuffer, this.endOfBodyPosition - 13);
        sendBuffer.writeInt(tmpBuffer.writerIndex() + 4 + 13);
        tmpBuffer.readBytes(sendBuffer, tmpBuffer.readableBytes());
        sendBuffer.readerIndex(0);
    }

    private synchronized void checkEncode() {
        if (!this.validBuffer) {
            this.encode();
        }
    }

    @Override
    public Long getScheduledDeliveryTime() {
        this.checkProperties();
        Object property = this.getObjectProperty(Message.HDR_SCHEDULED_DELIVERY_TIME);
        if (property != null && property instanceof Number) {
            return ((Number)property).longValue();
        }
        return 0L;
    }

    @Override
    public CoreMessage setScheduledDeliveryTime(Long time) {
        this.checkProperties();
        if (time == null || time == 0L) {
            this.removeProperty(Message.HDR_SCHEDULED_DELIVERY_TIME);
        } else {
            this.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, (long)time);
        }
        return this;
    }

    @Override
    public InputStream getBodyInputStream() {
        return null;
    }

    @Override
    public ActiveMQBuffer getBodyBuffer() {
        this.checkProperties();
        this.internalWritableBuffer();
        return this.writableBuffer;
    }

    private void internalWritableBuffer() {
        if (this.writableBuffer == null) {
            this.writableBuffer = new ResetLimitWrappedActiveMQBuffer(4, this.buffer.duplicate(), (Message)this);
            if (this.endOfBodyPosition > 0) {
                this.writableBuffer.byteBuf().setIndex(4, this.endOfBodyPosition - 13 + 4);
                this.writableBuffer.resetReaderIndex();
            }
        }
    }

    @Override
    public int getEndOfBodyPosition() {
        if (this.endOfBodyPosition < 0) {
            this.endOfBodyPosition = this.getBodyBuffer().writerIndex();
        }
        return this.endOfBodyPosition;
    }

    public TypedProperties getTypedProperties() {
        return this.checkProperties();
    }

    @Override
    public void messageChanged() {
        this.validBuffer = false;
    }

    protected CoreMessage(CoreMessage other) {
        this(other, other.properties);
    }

    public CoreMessage(long id, int bufferSize) {
        this(id, bufferSize, null);
    }

    public CoreMessage(long id, int bufferSize, CoreMessageObjectPools coreMessageObjectPools) {
        this.initBuffer(bufferSize);
        this.setMessageID(id);
        this.coreMessageObjectPools = coreMessageObjectPools;
    }

    protected CoreMessage(CoreMessage other, TypedProperties copyProperties) {
        this.body = other.body;
        this.endOfBodyPosition = other.endOfBodyPosition;
        this.messageID = other.messageID;
        this.address = other.address;
        this.type = other.type;
        this.durable = other.durable;
        this.expiration = other.expiration;
        this.timestamp = other.timestamp;
        this.priority = other.priority;
        this.userID = other.userID;
        this.coreMessageObjectPools = other.coreMessageObjectPools;
        if (copyProperties != null) {
            this.properties = new TypedProperties(copyProperties);
        }
        if (other.buffer != null) {
            this.buffer = other.buffer.copy();
        }
    }

    @Override
    public void copyHeadersAndProperties(Message msg) {
        this.messageID = msg.getMessageID();
        this.address = msg.getAddressSimpleString();
        this.userID = (UUID)msg.getUserID();
        this.type = msg.toCore().getType();
        this.durable = msg.isDurable();
        this.expiration = msg.getExpiration();
        this.timestamp = msg.getTimestamp();
        this.priority = msg.getPriority();
        if (msg instanceof CoreMessage) {
            this.properties = ((CoreMessage)msg).getTypedProperties();
        }
    }

    @Override
    public Message copy() {
        this.checkProperties();
        this.checkEncode();
        return new CoreMessage(this);
    }

    @Override
    public Message copy(long newID) {
        return this.copy().setMessageID(newID);
    }

    @Override
    public long getExpiration() {
        return this.expiration;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public CoreMessage setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Override
    public long getMessageID() {
        return this.messageID;
    }

    @Override
    public byte getPriority() {
        return this.priority;
    }

    public UUID getUserID() {
        return this.userID;
    }

    @Override
    public CoreMessage setUserID(Object uuid) {
        this.userID = (UUID)uuid;
        return this;
    }

    @Override
    public String getValidatedUserID() {
        return this.getStringProperty(Message.HDR_VALIDATED_USER);
    }

    @Override
    public CoreMessage setValidatedUserID(String validatedUserID) {
        this.putStringProperty(Message.HDR_VALIDATED_USER, SimpleString.toSimpleString((String)validatedUserID, (SimpleString.StringSimpleStringPool)this.getPropertyValuesPool()));
        return this;
    }

    @Override
    public CoreMessage setMessageID(long messageID) {
        this.messageID = messageID;
        if (this.messageIDPosition >= 0 && this.validBuffer) {
            this.buffer.setLong(this.messageIDPosition, messageID);
        }
        return this;
    }

    @Override
    public CoreMessage setAddress(SimpleString address) {
        if (address == null && this.address == null) {
            return this;
        }
        if (this.validBuffer && (address == null || !address.equals((Object)this.address))) {
            this.messageChanged();
        }
        this.address = address;
        return this;
    }

    @Override
    public SimpleString getAddressSimpleString() {
        return this.address;
    }

    @Override
    public CoreMessage setExpiration(long expiration) {
        this.expiration = expiration;
        this.messageChanged();
        return this;
    }

    @Override
    public CoreMessage setPriority(byte priority) {
        this.priority = priority;
        this.messageChanged();
        return this;
    }

    public CoreMessage setUserID(UUID userID) {
        this.userID = userID;
        this.messageChanged();
        return this;
    }

    protected TypedProperties checkProperties() {
        if (this.properties == null) {
            TypedProperties properties = new TypedProperties();
            if (this.buffer != null && this.propertiesLocation >= 0) {
                ByteBuf byteBuf = this.buffer.duplicate().readerIndex(this.propertiesLocation);
                properties.decode(byteBuf, this.coreMessageObjectPools == null ? null : this.coreMessageObjectPools.getPropertiesDecoderPools());
            }
            this.properties = properties;
        }
        return this.properties;
    }

    @Override
    public int getMemoryEstimate() {
        if (this.memoryEstimate == -1) {
            this.memoryEstimate = 352 + (this.buffer != null ? this.buffer.capacity() : 0) + (this.properties != null ? this.properties.getMemoryOffset() : 0);
        }
        return this.memoryEstimate;
    }

    @Override
    public boolean isServerMessage() {
        return false;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    @Override
    public CoreMessage setType(byte type) {
        this.type = type;
        return this;
    }

    private void decode(boolean beforeAddress) {
        this.endOfBodyPosition = this.buffer.readInt();
        this.buffer.skipBytes(this.endOfBodyPosition - 13);
        this.decodeHeadersAndProperties(this.buffer, true);
        this.buffer.readerIndex(0);
        this.validBuffer = true;
        if (beforeAddress) {
            this.endOfBodyPosition -= 4;
        }
        this.internalWritableBuffer();
    }

    public void decodeHeadersAndProperties(ByteBuf buffer) {
        this.decodeHeadersAndProperties(buffer, false);
    }

    private void decodeHeadersAndProperties(ByteBuf buffer, boolean lazyProperties) {
        this.messageIDPosition = buffer.readerIndex();
        this.messageID = buffer.readLong();
        this.address = SimpleString.readNullableSimpleString((ByteBuf)buffer, this.coreMessageObjectPools == null ? null : this.coreMessageObjectPools.getAddressDecoderPool());
        if (buffer.readByte() == 1) {
            byte[] bytes = new byte[16];
            buffer.readBytes(bytes);
            this.userID = new UUID(1, bytes);
        } else {
            this.userID = null;
        }
        this.type = buffer.readByte();
        this.durable = buffer.readBoolean();
        this.expiration = buffer.readLong();
        this.timestamp = buffer.readLong();
        this.priority = buffer.readByte();
        if (lazyProperties) {
            this.properties = null;
            this.propertiesLocation = buffer.readerIndex();
        } else {
            this.properties = new TypedProperties();
            this.properties.decode(buffer, this.coreMessageObjectPools == null ? null : this.coreMessageObjectPools.getPropertiesDecoderPools());
        }
    }

    public synchronized CoreMessage encode() {
        this.checkProperties();
        if (this.writableBuffer != null) {
            this.endOfBodyPosition = this.writableBuffer.writerIndex() + 13 - 4;
        } else if (this.endOfBodyPosition <= 0) {
            this.endOfBodyPosition = 17;
        }
        this.buffer.setIndex(0, 0);
        this.buffer.writeInt(this.endOfBodyPosition);
        this.buffer.writerIndex(this.endOfBodyPosition - 13 + 4);
        this.encodeHeadersAndProperties(this.buffer);
        this.validBuffer = true;
        return this;
    }

    public void encodeHeadersAndProperties(ByteBuf buffer) {
        this.checkProperties();
        this.messageIDPosition = buffer.writerIndex();
        buffer.writeLong(this.messageID);
        SimpleString.writeNullableSimpleString((ByteBuf)buffer, (SimpleString)this.address);
        if (this.userID == null) {
            buffer.writeByte(0);
        } else {
            buffer.writeByte(1);
            buffer.writeBytes(this.userID.asBytes());
        }
        buffer.writeByte((int)this.type);
        buffer.writeBoolean(this.durable);
        buffer.writeLong(this.expiration);
        buffer.writeLong(this.timestamp);
        buffer.writeByte((int)this.priority);
        this.properties.encode(buffer);
    }

    @Override
    public int getHeadersAndPropertiesEncodeSize() {
        return 9 + (this.userID == null ? 0 : 16) + SimpleString.sizeofNullableString((SimpleString)this.address) + 1 + 1 + 8 + 8 + 1 + this.checkProperties().getEncodeSize();
    }

    @Override
    public Object getDuplicateProperty() {
        return this.getObjectProperty(Message.HDR_DUPLICATE_DETECTION_ID);
    }

    @Override
    public SimpleString getLastValueProperty() {
        return this.getSimpleStringProperty(Message.HDR_LAST_VALUE_NAME);
    }

    @Override
    public Message setLastValueProperty(SimpleString lastValueName) {
        return this.putStringProperty(Message.HDR_LAST_VALUE_NAME, lastValueName);
    }

    @Override
    public int getEncodeSize() {
        if (this.buffer == null) {
            return -1;
        }
        this.checkEncode();
        return this.buffer.writerIndex();
    }

    @Override
    public boolean isLargeMessage() {
        return false;
    }

    @Override
    public String getAddress() {
        if (this.address == null) {
            return null;
        }
        return this.address.toString();
    }

    @Override
    public CoreMessage setAddress(String address) {
        this.messageChanged();
        this.address = SimpleString.toSimpleString((String)address, this.coreMessageObjectPools == null ? null : this.coreMessageObjectPools.getAddressStringSimpleStringPool());
        return this;
    }

    @Override
    public CoreMessage setBuffer(ByteBuf buffer) {
        this.buffer = buffer;
        return this;
    }

    @Override
    public ByteBuf getBuffer() {
        return this.buffer;
    }

    @Override
    public boolean isDurable() {
        return this.durable;
    }

    @Override
    public CoreMessage setDurable(boolean durable) {
        this.messageChanged();
        this.durable = durable;
        return this;
    }

    @Override
    public CoreMessage putBooleanProperty(String key, boolean value) {
        this.messageChanged();
        this.checkProperties();
        this.properties.putBooleanProperty(SimpleString.toSimpleString((String)key, (SimpleString.StringSimpleStringPool)this.getPropertyKeysPool()), value);
        return this;
    }

    @Override
    public CoreMessage putBooleanProperty(SimpleString key, boolean value) {
        this.messageChanged();
        this.checkProperties();
        this.properties.putBooleanProperty(key, value);
        return this;
    }

    @Override
    public Boolean getBooleanProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        this.checkProperties();
        return this.properties.getBooleanProperty(key);
    }

    @Override
    public Boolean getBooleanProperty(String key) throws ActiveMQPropertyConversionException {
        this.checkProperties();
        return this.properties.getBooleanProperty(SimpleString.toSimpleString((String)key, (SimpleString.StringSimpleStringPool)this.getPropertyKeysPool()));
    }

    @Override
    public CoreMessage putByteProperty(SimpleString key, byte value) {
        this.messageChanged();
        this.checkProperties();
        this.properties.putByteProperty(key, value);
        return this;
    }

    @Override
    public CoreMessage putByteProperty(String key, byte value) {
        this.messageChanged();
        this.checkProperties();
        this.properties.putByteProperty(SimpleString.toSimpleString((String)key, (SimpleString.StringSimpleStringPool)this.getPropertyKeysPool()), value);
        return this;
    }

    @Override
    public Byte getByteProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        this.checkProperties();
        return this.properties.getByteProperty(key);
    }

    @Override
    public Byte getByteProperty(String key) throws ActiveMQPropertyConversionException {
        return this.getByteProperty(SimpleString.toSimpleString((String)key, (SimpleString.StringSimpleStringPool)this.getPropertyKeysPool()));
    }

    @Override
    public CoreMessage putBytesProperty(SimpleString key, byte[] value) {
        this.messageChanged();
        this.checkProperties();
        this.properties.putBytesProperty(key, value);
        return this;
    }

    @Override
    public CoreMessage putBytesProperty(String key, byte[] value) {
        this.messageChanged();
        this.checkProperties();
        this.properties.putBytesProperty(SimpleString.toSimpleString((String)key, (SimpleString.StringSimpleStringPool)this.getPropertyKeysPool()), value);
        return this;
    }

    @Override
    public byte[] getBytesProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        this.checkProperties();
        return this.properties.getBytesProperty(key);
    }

    @Override
    public byte[] getBytesProperty(String key) throws ActiveMQPropertyConversionException {
        return this.getBytesProperty(SimpleString.toSimpleString((String)key, (SimpleString.StringSimpleStringPool)this.getPropertyKeysPool()));
    }

    @Override
    public CoreMessage putCharProperty(SimpleString key, char value) {
        this.messageChanged();
        this.checkProperties();
        this.properties.putCharProperty(key, value);
        return this;
    }

    @Override
    public CoreMessage putCharProperty(String key, char value) {
        this.messageChanged();
        this.checkProperties();
        this.properties.putCharProperty(SimpleString.toSimpleString((String)key, (SimpleString.StringSimpleStringPool)this.getPropertyKeysPool()), value);
        return this;
    }

    @Override
    public CoreMessage putShortProperty(SimpleString key, short value) {
        this.messageChanged();
        this.checkProperties();
        this.properties.putShortProperty(key, value);
        return this;
    }

    @Override
    public CoreMessage putShortProperty(String key, short value) {
        this.messageChanged();
        this.checkProperties();
        this.properties.putShortProperty(SimpleString.toSimpleString((String)key, (SimpleString.StringSimpleStringPool)this.getPropertyKeysPool()), value);
        return this;
    }

    @Override
    public CoreMessage putIntProperty(SimpleString key, int value) {
        this.messageChanged();
        this.checkProperties();
        this.properties.putIntProperty(key, value);
        return this;
    }

    @Override
    public CoreMessage putIntProperty(String key, int value) {
        this.messageChanged();
        this.checkProperties();
        this.properties.putIntProperty(SimpleString.toSimpleString((String)key, (SimpleString.StringSimpleStringPool)this.getPropertyKeysPool()), value);
        return this;
    }

    @Override
    public Integer getIntProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        this.checkProperties();
        return this.properties.getIntProperty(key);
    }

    @Override
    public Integer getIntProperty(String key) throws ActiveMQPropertyConversionException {
        return this.getIntProperty(SimpleString.toSimpleString((String)key));
    }

    @Override
    public CoreMessage putLongProperty(SimpleString key, long value) {
        this.messageChanged();
        this.checkProperties();
        this.properties.putLongProperty(key, value);
        return this;
    }

    @Override
    public CoreMessage putLongProperty(String key, long value) {
        this.messageChanged();
        this.checkProperties();
        this.properties.putLongProperty(SimpleString.toSimpleString((String)key, (SimpleString.StringSimpleStringPool)this.getPropertyKeysPool()), value);
        return this;
    }

    @Override
    public Long getLongProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        this.checkProperties();
        return this.properties.getLongProperty(key);
    }

    @Override
    public Long getLongProperty(String key) throws ActiveMQPropertyConversionException {
        this.checkProperties();
        return this.getLongProperty(SimpleString.toSimpleString((String)key));
    }

    @Override
    public CoreMessage putFloatProperty(SimpleString key, float value) {
        this.messageChanged();
        this.checkProperties();
        this.properties.putFloatProperty(key, value);
        return this;
    }

    @Override
    public CoreMessage putFloatProperty(String key, float value) {
        this.messageChanged();
        this.checkProperties();
        this.properties.putFloatProperty(SimpleString.toSimpleString((String)key, (SimpleString.StringSimpleStringPool)this.getPropertyKeysPool()), value);
        return this;
    }

    @Override
    public CoreMessage putDoubleProperty(SimpleString key, double value) {
        this.messageChanged();
        this.checkProperties();
        this.properties.putDoubleProperty(key, value);
        return this;
    }

    @Override
    public CoreMessage putDoubleProperty(String key, double value) {
        this.messageChanged();
        this.checkProperties();
        this.properties.putDoubleProperty(SimpleString.toSimpleString((String)key, (SimpleString.StringSimpleStringPool)this.getPropertyKeysPool()), value);
        return this;
    }

    @Override
    public Double getDoubleProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        this.messageChanged();
        this.checkProperties();
        return this.properties.getDoubleProperty(key);
    }

    @Override
    public Double getDoubleProperty(String key) throws ActiveMQPropertyConversionException {
        this.checkProperties();
        return this.getDoubleProperty(SimpleString.toSimpleString((String)key));
    }

    @Override
    public CoreMessage putStringProperty(SimpleString key, SimpleString value) {
        this.messageChanged();
        this.checkProperties();
        this.properties.putSimpleStringProperty(key, value);
        return this;
    }

    @Override
    public CoreMessage putStringProperty(SimpleString key, String value) {
        this.messageChanged();
        this.checkProperties();
        this.properties.putSimpleStringProperty(key, SimpleString.toSimpleString((String)value, (SimpleString.StringSimpleStringPool)this.getPropertyValuesPool()));
        return this;
    }

    @Override
    public CoreMessage putStringProperty(String key, String value) {
        this.messageChanged();
        this.checkProperties();
        this.properties.putSimpleStringProperty(SimpleString.toSimpleString((String)key, (SimpleString.StringSimpleStringPool)this.getPropertyKeysPool()), SimpleString.toSimpleString((String)value, (SimpleString.StringSimpleStringPool)this.getPropertyValuesPool()));
        return this;
    }

    @Override
    public CoreMessage putObjectProperty(SimpleString key, Object value) throws ActiveMQPropertyConversionException {
        this.checkProperties();
        this.messageChanged();
        TypedProperties.setObjectProperty((SimpleString)key, (Object)value, (TypedProperties)this.properties);
        return this;
    }

    @Override
    public Object getObjectProperty(String key) {
        this.checkProperties();
        return this.getObjectProperty(SimpleString.toSimpleString((String)key, (SimpleString.StringSimpleStringPool)this.getPropertyKeysPool()));
    }

    @Override
    public Object getObjectProperty(SimpleString key) {
        this.checkProperties();
        return this.properties.getProperty(key);
    }

    @Override
    public CoreMessage putObjectProperty(String key, Object value) throws ActiveMQPropertyConversionException {
        this.messageChanged();
        this.putObjectProperty(SimpleString.toSimpleString((String)key, (SimpleString.StringSimpleStringPool)this.getPropertyKeysPool()), value);
        return this;
    }

    @Override
    public Short getShortProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        this.checkProperties();
        return this.properties.getShortProperty(key);
    }

    @Override
    public Short getShortProperty(String key) throws ActiveMQPropertyConversionException {
        this.checkProperties();
        return this.properties.getShortProperty(SimpleString.toSimpleString((String)key, (SimpleString.StringSimpleStringPool)this.getPropertyKeysPool()));
    }

    @Override
    public Float getFloatProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        this.checkProperties();
        return this.properties.getFloatProperty(key);
    }

    @Override
    public Float getFloatProperty(String key) throws ActiveMQPropertyConversionException {
        this.checkProperties();
        return this.properties.getFloatProperty(SimpleString.toSimpleString((String)key, (SimpleString.StringSimpleStringPool)this.getPropertyKeysPool()));
    }

    @Override
    public String getStringProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        SimpleString str = this.getSimpleStringProperty(key);
        if (str == null) {
            return null;
        }
        return str.toString();
    }

    @Override
    public String getStringProperty(String key) throws ActiveMQPropertyConversionException {
        return this.getStringProperty(SimpleString.toSimpleString((String)key, (SimpleString.StringSimpleStringPool)this.getPropertyKeysPool()));
    }

    @Override
    public SimpleString getSimpleStringProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        this.checkProperties();
        return this.properties.getSimpleStringProperty(key);
    }

    @Override
    public SimpleString getSimpleStringProperty(String key) throws ActiveMQPropertyConversionException {
        this.checkProperties();
        return this.properties.getSimpleStringProperty(SimpleString.toSimpleString((String)key, (SimpleString.StringSimpleStringPool)this.getPropertyKeysPool()));
    }

    @Override
    public Object removeProperty(SimpleString key) {
        this.checkProperties();
        Object oldValue = this.properties.removeProperty(key);
        if (oldValue != null) {
            this.messageChanged();
        }
        return oldValue;
    }

    @Override
    public Object removeProperty(String key) {
        this.messageChanged();
        this.checkProperties();
        Object oldValue = this.properties.removeProperty(SimpleString.toSimpleString((String)key, (SimpleString.StringSimpleStringPool)this.getPropertyKeysPool()));
        if (oldValue != null) {
            this.messageChanged();
        }
        return oldValue;
    }

    @Override
    public boolean containsProperty(SimpleString key) {
        this.checkProperties();
        return this.properties.containsProperty(key);
    }

    @Override
    public boolean containsProperty(String key) {
        this.checkProperties();
        return this.properties.containsProperty(SimpleString.toSimpleString((String)key, (SimpleString.StringSimpleStringPool)this.getPropertyKeysPool()));
    }

    @Override
    public Set<SimpleString> getPropertyNames() {
        this.checkProperties();
        return this.properties.getPropertyNames();
    }

    @Override
    public LargeBodyEncoder getBodyEncoder() throws ActiveMQException {
        return new DecodingContext();
    }

    @Override
    public int getPersistSize() {
        this.checkEncode();
        return this.buffer.writerIndex() + 4;
    }

    @Override
    public void persist(ActiveMQBuffer targetRecord) {
        this.checkEncode();
        targetRecord.writeInt(this.buffer.writerIndex());
        targetRecord.writeBytes(this.buffer, 0, this.buffer.writerIndex());
    }

    @Override
    public void reloadPersistence(ActiveMQBuffer record) {
        int size = record.readInt();
        this.initBuffer(size);
        this.buffer.setIndex(0, 0).writeBytes(record.byteBuf(), size);
        this.decode(false);
    }

    @Override
    public CoreMessage toCore() {
        return this;
    }

    @Override
    public CoreMessage toCore(CoreMessageObjectPools coreMessageObjectPools) {
        return this;
    }

    public String toString() {
        try {
            this.checkProperties();
            return "CoreMessage[messageID=" + this.messageID + ",durable=" + this.isDurable() + ",userID=" + this.getUserID() + ",priority=" + this.getPriority() + ", timestamp=" + CoreMessage.toDate(this.getTimestamp()) + ",expiration=" + CoreMessage.toDate(this.getExpiration()) + ", durable=" + this.durable + ", address=" + this.getAddress() + ",size=" + this.getPersistentSize() + ",properties=" + this.properties + "]@" + System.identityHashCode(this);
        }
        catch (Throwable e) {
            logger.warn((Object)"Error creating String for message: ", e);
            return "ServerMessage[messageID=" + this.messageID + "]";
        }
    }

    private static String toDate(long timestamp) {
        if (timestamp == 0L) {
            return "0";
        }
        return new Date(timestamp).toString();
    }

    private SimpleString.StringSimpleStringPool getPropertyKeysPool() {
        return this.coreMessageObjectPools == null ? null : this.coreMessageObjectPools.getPropertiesStringSimpleStringPools().getPropertyKeysPool();
    }

    private SimpleString.StringSimpleStringPool getPropertyValuesPool() {
        return this.coreMessageObjectPools == null ? null : this.coreMessageObjectPools.getPropertiesStringSimpleStringPools().getPropertyValuesPool();
    }

    @Override
    public long getPersistentSize() throws ActiveMQException {
        return this.getEncodeSize();
    }

    private final class DecodingContext
    implements LargeBodyEncoder {
        private int lastPos = 0;

        private DecodingContext() {
        }

        @Override
        public void open() {
        }

        @Override
        public void close() {
        }

        @Override
        public long getLargeBodySize() {
            return CoreMessage.this.buffer.writerIndex();
        }

        @Override
        public int encode(ByteBuffer bufferRead) throws ActiveMQException {
            ActiveMQBuffer buffer = ActiveMQBuffers.wrappedBuffer((ByteBuffer)bufferRead);
            return this.encode(buffer, bufferRead.capacity());
        }

        @Override
        public int encode(ActiveMQBuffer bufferOut, int size) {
            bufferOut.byteBuf().writeBytes(CoreMessage.this.buffer, this.lastPos, size);
            this.lastPos += size;
            return size;
        }
    }
}

