/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.lib;

import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.core.User;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.user.api.AlreadyExistInUsersRepositoryException;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;

public abstract class AbstractUsersRepository
implements UsersRepository,
Configurable {
    private DomainList domainList;
    private boolean virtualHosting;
    private Optional<String> administratorId;

    public void configure(HierarchicalConfiguration configuration) throws ConfigurationException {
        this.virtualHosting = configuration.getBoolean("enableVirtualHosting", this.getDefaultVirtualHostingValue());
        this.administratorId = Optional.ofNullable(configuration.getString("administratorId"));
        this.doConfigure(configuration);
    }

    protected boolean getDefaultVirtualHostingValue() {
        return false;
    }

    protected void doConfigure(HierarchicalConfiguration config) throws ConfigurationException {
    }

    public void setEnableVirtualHosting(boolean virtualHosting) {
        this.virtualHosting = virtualHosting;
    }

    @Inject
    public void setDomainList(DomainList domainList) {
        this.domainList = domainList;
    }

    protected void isValidUsername(String username) throws UsersRepositoryException {
        block6: {
            User user = User.fromUsername((String)username);
            if (this.supportVirtualHosting()) {
                if (!user.hasDomainPart()) {
                    throw new UsersRepositoryException("Given Username needs to contain a @domainpart");
                }
                Domain domain = (Domain)user.getDomainPart().get();
                try {
                    if (!this.domainList.containsDomain(domain)) {
                        throw new UsersRepositoryException("Domain does not exist in DomainList");
                    }
                    break block6;
                }
                catch (DomainListException e) {
                    throw new UsersRepositoryException("Unable to query DomainList", (Throwable)e);
                }
            }
            if (user.hasDomainPart()) {
                throw new UsersRepositoryException("Given Username contains a @domainpart but virtualhosting support is disabled");
            }
        }
    }

    public void addUser(String username, String password) throws UsersRepositoryException {
        if (this.contains(username)) {
            throw new AlreadyExistInUsersRepositoryException("User with username " + username + " already exists!");
        }
        this.isValidUsername(username);
        this.doAddUser(username, password);
    }

    public boolean supportVirtualHosting() {
        return this.virtualHosting;
    }

    protected abstract void doAddUser(String var1, String var2) throws UsersRepositoryException;

    public String getUser(MailAddress mailAddress) throws UsersRepositoryException {
        if (this.supportVirtualHosting()) {
            return mailAddress.asString();
        }
        return mailAddress.getLocalPart();
    }

    @VisibleForTesting
    void setAdministratorId(Optional<String> username) {
        this.administratorId = username;
    }

    public boolean isAdministrator(String username) throws UsersRepositoryException {
        if (this.administratorId.isPresent()) {
            return this.administratorId.get().equals(username);
        }
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    public MailAddress getMailAddressFor(User user) throws UsersRepositoryException {
        try {
            if (this.supportVirtualHosting()) {
                return new MailAddress(user.asString());
            }
            return new MailAddress(user.getLocalPart(), this.domainList.getDefaultDomain());
        }
        catch (Exception e) {
            throw new UsersRepositoryException("Failed to compute mail address associated with the user", (Throwable)e);
        }
    }
}

