/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeConverter {
    private static final String PATTERN_STRING = "\\s*([0-9]+)\\s*([a-z,A-Z]*)\\s*";
    private static Pattern PATTERN = Pattern.compile("\\s*([0-9]+)\\s*([a-z,A-Z]*)\\s*");

    private TimeConverter() {
    }

    public static long getMilliSeconds(long amount, String unit) throws NumberFormatException {
        return TimeConverter.getMilliSeconds(amount, Unit.parse(unit));
    }

    public static long getMilliSeconds(long amount, Unit unit) throws NumberFormatException {
        int multiplier = unit.multiplier;
        return amount * (long)multiplier;
    }

    public static long getMilliSeconds(String rawString) throws NumberFormatException {
        return TimeConverter.getMilliSeconds(rawString, Unit.MILLI_SECONDS);
    }

    public static long getMilliSeconds(String rawString, Unit defaultUnit) throws NumberFormatException {
        Matcher res = PATTERN.matcher(rawString);
        if (res.matches()) {
            if (res.group(1) != null && res.group(2) != null) {
                long time = Integer.parseInt(res.group(1).trim());
                String unit = res.group(2);
                if (Strings.isNullOrEmpty((String)unit)) {
                    return TimeConverter.getMilliSeconds(time, defaultUnit);
                }
                return TimeConverter.getMilliSeconds(time, Unit.parse(unit));
            }
            throw new NumberFormatException("The supplied String is not a supported format " + rawString);
        }
        throw new NumberFormatException("The supplied String is not a supported format " + rawString);
    }

    public static enum Unit {
        MILLI_SECONDS((List<String>)ImmutableList.of((Object)"ms", (Object)"msec", (Object)"msecs"), 1),
        SECONDS((List<String>)ImmutableList.of((Object)"s", (Object)"sec", (Object)"secs"), 1000),
        MINUTES((List<String>)ImmutableList.of((Object)"m", (Object)"min", (Object)"mins", (Object)"minute", (Object)"minutes"), 60000),
        HOURS((List<String>)ImmutableList.of((Object)"h", (Object)"hour", (Object)"hours"), 3600000),
        DAYS((List<String>)ImmutableList.of((Object)"d", (Object)"day", (Object)"days"), 86400000);

        private final List<String> validPatterns;
        private final int multiplier;

        public static Unit parse(String string) {
            return Arrays.stream(Unit.values()).filter(value -> value.validPatterns.contains(string.toLowerCase(Locale.US))).findFirst().orElseThrow(() -> new NumberFormatException("Unknown unit: " + string));
        }

        private Unit(List<String> validPatterns, int multiplier) {
            this.validPatterns = validPatterns;
            this.multiplier = multiplier;
        }
    }
}

