/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.search.comparator;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mailbox.store.ResultUtils;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHeaderComparator
implements Comparator<MailboxMessage> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractHeaderComparator.class);
    public static final String FROM = "from";
    public static final String TO = "to";
    public static final String CC = "cc";

    protected String getHeaderValue(String headerName, MailboxMessage message) {
        try {
            List<MessageResult.Header> headers = ResultUtils.createHeaders(message);
            for (MessageResult.Header header : headers) {
                String name = header.getName();
                if (!headerName.equalsIgnoreCase(name)) continue;
                String value = header.getValue();
                return value.toUpperCase(Locale.US);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Exception encountered, skipping header line", (Throwable)e);
        }
        return "";
    }
}

