/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.search;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.events.Event;
import org.apache.james.mailbox.events.MailboxListener;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.SessionProvider;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ListeningMessageSearchIndex
implements MessageSearchIndex,
MailboxListener.GroupMailboxListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListeningMessageSearchIndex.class);
    private static final int UNLIMITED = -1;
    private final MailboxSessionMapperFactory factory;
    private final SessionProvider sessionProvider;
    private static final ImmutableList<Class<? extends Event>> INTERESTING_EVENTS = ImmutableList.of(MailboxListener.Added.class, MailboxListener.Expunged.class, MailboxListener.FlagsUpdated.class, MailboxListener.MailboxDeletion.class);

    public ListeningMessageSearchIndex(MailboxSessionMapperFactory factory, SessionProvider sessionProvider) {
        this.factory = factory;
        this.sessionProvider = sessionProvider;
    }

    public void event(Event event) throws Exception {
        if (INTERESTING_EVENTS.contains(event.getClass())) {
            this.handleMailboxEvent(event, this.sessionProvider.createSystemSession(event.getUser().asString()), (MailboxListener.MailboxEvent)event);
        }
    }

    private void handleMailboxEvent(Event event, MailboxSession session, MailboxListener.MailboxEvent mailboxEvent) throws Exception {
        Mailbox mailbox = this.factory.getMailboxMapper(session).findMailboxById(mailboxEvent.getMailboxId());
        if (event instanceof MailboxListener.Added) {
            this.handleAdded(session, mailbox, (MailboxListener.Added)event);
        } else if (event instanceof MailboxListener.Expunged) {
            MailboxListener.Expunged expunged = (MailboxListener.Expunged)event;
            this.delete(session, mailbox, expunged.getUids());
        } else if (event instanceof MailboxListener.FlagsUpdated) {
            MailboxListener.FlagsUpdated flagsUpdated = (MailboxListener.FlagsUpdated)event;
            this.update(session, mailbox, flagsUpdated.getUpdatedFlags());
        } else if (event instanceof MailboxListener.MailboxDeletion) {
            this.deleteAll(session, mailbox);
        }
    }

    private void handleAdded(MailboxSession session, Mailbox mailbox, MailboxListener.Added added) {
        MessageRange.toRanges((Collection)added.getUids()).stream().flatMap(range -> this.retrieveMailboxMessages(session, mailbox, (MessageRange)range)).forEach(Throwing.consumer(mailboxMessage -> this.add(session, mailbox, (MailboxMessage)mailboxMessage)).sneakyThrow());
    }

    private Stream<MailboxMessage> retrieveMailboxMessages(MailboxSession session, Mailbox mailbox, MessageRange range) {
        try {
            return Stream.of(this.factory.getMessageMapper(session).findInMailbox(mailbox, range, MessageMapper.FetchType.Full, -1).next());
        }
        catch (Exception e) {
            LOGGER.error("Could not retrieve message {} in mailbox {}", new Object[]{range.toString(), mailbox.getMailboxId().serialize(), e});
            return Stream.empty();
        }
    }

    public abstract void add(MailboxSession var1, Mailbox var2, MailboxMessage var3) throws Exception;

    public abstract void delete(MailboxSession var1, Mailbox var2, Collection<MessageUid> var3) throws Exception;

    public abstract void deleteAll(MailboxSession var1, Mailbox var2) throws Exception;

    public abstract void update(MailboxSession var1, Mailbox var2, List<UpdatedFlags> var3) throws Exception;
}

