/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.quota;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.apache.james.core.Domain;
import org.apache.james.core.quota.QuotaCount;
import org.apache.james.core.quota.QuotaSize;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.UnsupportedOperationException;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.MaxQuotaManager;

public class FixedMaxQuotaManager
implements MaxQuotaManager {
    private Optional<QuotaSize> maxStorage = Optional.empty();
    private Optional<QuotaCount> maxMessage = Optional.empty();

    public void setMaxStorage(QuotaRoot quotaRoot, QuotaSize maxStorageQuota) throws MailboxException {
        throw new UnsupportedOperationException("Can not modify QuotaRoot specific upper limit for FixedMaxQuotaManager");
    }

    public void setMaxMessage(QuotaRoot quotaRoot, QuotaCount maxMessageCount) throws MailboxException {
        throw new UnsupportedOperationException("Can not modify QuotaRoot specific upper limit for FixedMaxQuotaManager");
    }

    public void removeMaxMessage(QuotaRoot quotaRoot) throws MailboxException {
        throw new UnsupportedOperationException("Can not modify QuotaRoot specific upper limit for FixedMaxQuotaManager");
    }

    public void removeMaxStorage(QuotaRoot quotaRoot) throws MailboxException {
        throw new UnsupportedOperationException("Can not modify QuotaRoot specific upper limit for FixedMaxQuotaManager");
    }

    public void setDomainMaxMessage(Domain domain, QuotaCount count) throws MailboxException {
        throw new UnsupportedOperationException("Can not modify domain specific upper limit for FixedMaxQuotaManager");
    }

    public void setDomainMaxStorage(Domain domain, QuotaSize size) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Can not modify domain specific upper limit for FixedMaxQuotaManager");
    }

    public void setGlobalMaxStorage(QuotaSize globalMaxStorage) {
        this.maxStorage = Optional.of(globalMaxStorage);
    }

    public void removeGlobalMaxStorage() throws MailboxException {
        throw new UnsupportedOperationException("Can not modify QuotaRoot specific upper limit for FixedMaxQuotaManager");
    }

    public void removeGlobalMaxMessage() {
        this.maxMessage = Optional.empty();
    }

    public void setGlobalMaxMessage(QuotaCount globalMaxMessageCount) {
        this.maxMessage = Optional.empty();
    }

    public Optional<QuotaSize> getMaxStorage(QuotaRoot quotaRoot) {
        return this.maxStorage;
    }

    public Optional<QuotaCount> getMaxMessage(QuotaRoot quotaRoot) {
        return this.maxMessage;
    }

    public Map<Quota.Scope, QuotaCount> listMaxMessagesDetails(QuotaRoot quotaRoot) {
        return (Map)this.maxMessage.map(value -> ImmutableMap.of((Object)Quota.Scope.Global, (Object)value)).orElse(ImmutableMap.of());
    }

    public Map<Quota.Scope, QuotaSize> listMaxStorageDetails(QuotaRoot quotaRoot) {
        return (Map)this.maxStorage.map(value -> ImmutableMap.of((Object)Quota.Scope.Global, (Object)value)).orElse(ImmutableMap.of());
    }

    public Optional<QuotaCount> getDomainMaxMessage(Domain domain) {
        return Optional.empty();
    }

    public Optional<QuotaSize> getDomainMaxStorage(Domain domain) {
        return Optional.empty();
    }

    public Optional<QuotaCount> getMaxMessage() {
        return Optional.empty();
    }

    public void removeDomainMaxMessage(Domain domain) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Can not modify domain specific upper limit for FixedMaxQuotaManager");
    }

    public void removeDomainMaxStorage(Domain domain) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Can not modify domain specific upper limit for FixedMaxQuotaManager");
    }

    public Optional<QuotaSize> getGlobalMaxStorage() {
        return this.maxStorage;
    }

    public Optional<QuotaCount> getGlobalMaxMessage() {
        return this.maxMessage;
    }
}

