/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.mail.Flags;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxCounters;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.store.FlagsUpdateCalculator;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.transaction.Mapper;

public interface MessageMapper
extends Mapper {
    public Iterator<MailboxMessage> findInMailbox(Mailbox var1, MessageRange var2, FetchType var3, int var4) throws MailboxException;

    public Map<MessageUid, MessageMetaData> expungeMarkedForDeletionInMailbox(Mailbox var1, MessageRange var2) throws MailboxException;

    public long countMessagesInMailbox(Mailbox var1) throws MailboxException;

    public long countUnseenMessagesInMailbox(Mailbox var1) throws MailboxException;

    public MailboxCounters getMailboxCounters(Mailbox var1) throws MailboxException;

    public void delete(Mailbox var1, MailboxMessage var2) throws MailboxException;

    public MessageUid findFirstUnseenMessageUid(Mailbox var1) throws MailboxException;

    public List<MessageUid> findRecentMessageUidsInMailbox(Mailbox var1) throws MailboxException;

    public MessageMetaData add(Mailbox var1, MailboxMessage var2) throws MailboxException;

    public Iterator<UpdatedFlags> updateFlags(Mailbox var1, FlagsUpdateCalculator var2, MessageRange var3) throws MailboxException;

    public MessageMetaData copy(Mailbox var1, MailboxMessage var2) throws MailboxException;

    public MessageMetaData move(Mailbox var1, MailboxMessage var2) throws MailboxException;

    public Optional<MessageUid> getLastUid(Mailbox var1) throws MailboxException;

    public long getHighestModSeq(Mailbox var1) throws MailboxException;

    public Flags getApplicableFlag(Mailbox var1) throws MailboxException;

    public Iterator<MessageUid> listAllMessageUids(Mailbox var1) throws MailboxException;

    public static enum FetchType {
        Metadata,
        Headers,
        Body,
        Full;

    }
}

