/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.event;

import java.util.List;
import javax.inject.Inject;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.events.Event;
import org.apache.james.mailbox.events.Group;
import org.apache.james.mailbox.events.MailboxListener;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxAnnotation;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.SessionProvider;
import org.apache.james.mailbox.store.mail.AnnotationMapper;

public class MailboxAnnotationListener
implements MailboxListener.GroupMailboxListener {
    private static final Group GROUP = new MailboxAnnotationListenerGroup();
    private final MailboxSessionMapperFactory mailboxSessionMapperFactory;
    private final SessionProvider sessionProvider;

    @Inject
    public MailboxAnnotationListener(MailboxSessionMapperFactory mailboxSessionMapperFactory, SessionProvider sessionProvider) {
        this.mailboxSessionMapperFactory = mailboxSessionMapperFactory;
        this.sessionProvider = sessionProvider;
    }

    public Group getDefaultGroup() {
        return GROUP;
    }

    public void event(Event event) throws MailboxException {
        if (event instanceof MailboxListener.MailboxDeletion) {
            MailboxSession mailboxSession = this.sessionProvider.createSystemSession(event.getUser().asString());
            AnnotationMapper annotationMapper = this.mailboxSessionMapperFactory.getAnnotationMapper(mailboxSession);
            MailboxId mailboxId = ((MailboxListener.MailboxDeletion)event).getMailboxId();
            this.deleteRelatedAnnotations(mailboxId, annotationMapper);
        }
    }

    private void deleteRelatedAnnotations(MailboxId mailboxId, AnnotationMapper annotationMapper) {
        List<MailboxAnnotation> annotations = annotationMapper.getAllAnnotations(mailboxId);
        for (MailboxAnnotation annotation : annotations) {
            annotationMapper.deleteAnnotation(mailboxId, annotation.getKey());
        }
    }

    private static final class MailboxAnnotationListenerGroup
    extends Group {
        private MailboxAnnotationListenerGroup() {
        }
    }
}

