/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.event;

import com.github.steveash.guavate.Guavate;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import java.time.Instant;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import org.apache.james.core.User;
import org.apache.james.core.quota.QuotaCount;
import org.apache.james.core.quota.QuotaSize;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.acl.ACLDiff;
import org.apache.james.mailbox.events.Event;
import org.apache.james.mailbox.events.MailboxListener;
import org.apache.james.mailbox.events.MessageMoveEvent;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;

public class EventFactory {
    public static RequireMailboxEvent<RequireMetadata<AddedFinalStage>> added() {
        return eventId -> user -> sessionId -> mailboxId -> path -> metaData -> new AddedFinalStage(eventId, path, mailboxId, user, sessionId, metaData);
    }

    public static RequireMailboxEvent<RequireMetadata<ExpungedFinalStage>> expunged() {
        return eventId -> user -> sessionId -> mailboxId -> path -> metaData -> new ExpungedFinalStage(eventId, path, mailboxId, user, sessionId, metaData);
    }

    public static RequireMailboxEvent<RequireUpdatedFlags<FlagsUpdatedFinalStage>> flagsUpdated() {
        return eventId -> user -> sessionId -> mailboxId -> path -> updatedFlags -> new FlagsUpdatedFinalStage(eventId, path, mailboxId, user, sessionId, (ImmutableList<UpdatedFlags>)updatedFlags);
    }

    public static RequireEventId<RequireSession<RequireMailboxId<RequireOldPath<RequireNewPath<MailboxRenamedFinalStage>>>>> mailboxRenamed() {
        return eventId -> user -> sessionId -> mailboxId -> oldPath -> newPath -> new MailboxRenamedFinalStage(eventId, oldPath, mailboxId, user, sessionId, newPath);
    }

    public static RequireMailboxEvent<RequireQuotaRoot<RequireQuotaCountValue<RequireQuotaSizeValue<MailboxDeletionFinalStage>>>> mailboxDeleted() {
        return eventId -> user -> sessionId -> mailboxId -> path -> quotaRoot -> quotaCount -> quotaSize -> new MailboxDeletionFinalStage(eventId, path, mailboxId, user, sessionId, quotaRoot, quotaCount, quotaSize);
    }

    public static RequireMailboxEvent<MailboxAddedFinalStage> mailboxAdded() {
        return eventId -> user -> sessionId -> mailboxId -> path -> new MailboxAddedFinalStage(eventId, path, mailboxId, user, sessionId);
    }

    public static RequireMailboxEvent<RequireAclDiff<MailboxAclUpdatedFinalStage>> aclUpdated() {
        return eventId -> user -> sessionId -> mailboxId -> path -> aclDiff -> new MailboxAclUpdatedFinalStage(eventId, path, mailboxId, user, sessionId, aclDiff);
    }

    public static RequireEventId<RequireUser<RequireQuotaRoot<RequireQuotaCount<RequireQuotaSize<RequireInstant<QuotaUsageUpdatedFinalStage>>>>>> quotaUpdated() {
        return eventId -> user -> quotaRoot -> quotaCount -> quotaSize -> instant -> new QuotaUsageUpdatedFinalStage(eventId, user, quotaRoot, (Quota<QuotaCount>)quotaCount, (Quota<QuotaSize>)quotaSize, instant);
    }

    public static MessageMoveEvent.Builder moved() {
        return MessageMoveEvent.builder();
    }

    public static final class QuotaUsageUpdatedFinalStage {
        private final Event.EventId eventId;
        private final User user;
        private final QuotaRoot quotaRoot;
        private final Quota<QuotaCount> countQuota;
        private final Quota<QuotaSize> sizeQuota;
        private final Instant instant;

        QuotaUsageUpdatedFinalStage(Event.EventId eventId, User user, QuotaRoot quotaRoot, Quota<QuotaCount> countQuota, Quota<QuotaSize> sizeQuota, Instant instant) {
            this.eventId = eventId;
            this.user = user;
            this.quotaRoot = quotaRoot;
            this.countQuota = countQuota;
            this.sizeQuota = sizeQuota;
            this.instant = instant;
        }

        public MailboxListener.QuotaUsageUpdatedEvent build() {
            return new MailboxListener.QuotaUsageUpdatedEvent(this.eventId, this.user, this.quotaRoot, this.countQuota, this.sizeQuota, this.instant);
        }
    }

    public static class FlagsUpdatedFinalStage {
        private final Event.EventId eventId;
        private final MailboxPath path;
        private final MailboxId mailboxId;
        private final User user;
        private final MailboxSession.SessionId sessionId;
        private final ImmutableList<UpdatedFlags> updatedFlags;

        FlagsUpdatedFinalStage(Event.EventId eventId, MailboxPath path, MailboxId mailboxId, User user, MailboxSession.SessionId sessionId, ImmutableList<UpdatedFlags> updatedFlags) {
            this.eventId = eventId;
            this.path = path;
            this.mailboxId = mailboxId;
            this.user = user;
            this.sessionId = sessionId;
            this.updatedFlags = updatedFlags;
        }

        public MailboxListener.FlagsUpdated build() {
            Preconditions.checkNotNull((Object)this.path);
            Preconditions.checkNotNull((Object)this.mailboxId);
            Preconditions.checkNotNull((Object)this.user);
            Preconditions.checkNotNull((Object)this.sessionId);
            Preconditions.checkNotNull(this.updatedFlags);
            return new MailboxListener.FlagsUpdated(this.sessionId, this.user, this.path, this.mailboxId, this.updatedFlags, this.eventId);
        }
    }

    public static class MailboxRenamedFinalStage {
        private final Event.EventId eventId;
        private final MailboxPath oldPath;
        private final MailboxId mailboxId;
        private final User user;
        private final MailboxSession.SessionId sessionId;
        private final MailboxPath newPath;

        MailboxRenamedFinalStage(Event.EventId eventId, MailboxPath oldPath, MailboxId mailboxId, User user, MailboxSession.SessionId sessionId, MailboxPath newPath) {
            this.eventId = eventId;
            this.oldPath = oldPath;
            this.mailboxId = mailboxId;
            this.user = user;
            this.sessionId = sessionId;
            this.newPath = newPath;
        }

        public MailboxListener.MailboxRenamed build() {
            Preconditions.checkNotNull((Object)this.oldPath);
            Preconditions.checkNotNull((Object)this.newPath);
            Preconditions.checkNotNull((Object)this.mailboxId);
            Preconditions.checkNotNull((Object)this.user);
            Preconditions.checkNotNull((Object)this.sessionId);
            return new MailboxListener.MailboxRenamed(this.sessionId, this.user, this.oldPath, this.mailboxId, this.newPath, this.eventId);
        }
    }

    public static class MailboxDeletionFinalStage {
        private final Event.EventId eventId;
        private final MailboxPath path;
        private final MailboxId mailboxId;
        private final User user;
        private final MailboxSession.SessionId sessionId;
        private final QuotaRoot quotaRoot;
        private final QuotaCount deletedMessageCount;
        private final QuotaSize totalDeletedSize;

        MailboxDeletionFinalStage(Event.EventId eventId, MailboxPath path, MailboxId mailboxId, User user, MailboxSession.SessionId sessionId, QuotaRoot quotaRoot, QuotaCount deletedMessageCount, QuotaSize totalDeletedSize) {
            this.eventId = eventId;
            this.path = path;
            this.mailboxId = mailboxId;
            this.user = user;
            this.sessionId = sessionId;
            this.quotaRoot = quotaRoot;
            this.deletedMessageCount = deletedMessageCount;
            this.totalDeletedSize = totalDeletedSize;
        }

        public MailboxListener.MailboxDeletion build() {
            Preconditions.checkNotNull((Object)this.path);
            Preconditions.checkNotNull((Object)this.mailboxId);
            Preconditions.checkNotNull((Object)this.user);
            Preconditions.checkNotNull((Object)this.sessionId);
            Preconditions.checkNotNull((Object)this.quotaRoot);
            Preconditions.checkNotNull((Object)this.deletedMessageCount);
            Preconditions.checkNotNull((Object)this.totalDeletedSize);
            return new MailboxListener.MailboxDeletion(this.sessionId, this.user, this.path, this.quotaRoot, this.deletedMessageCount, this.totalDeletedSize, this.mailboxId, this.eventId);
        }
    }

    public static class MailboxAclUpdatedFinalStage {
        private final Event.EventId eventId;
        private final MailboxPath path;
        private final MailboxId mailboxId;
        private final User user;
        private final MailboxSession.SessionId sessionId;
        private final ACLDiff aclDiff;

        MailboxAclUpdatedFinalStage(Event.EventId eventId, MailboxPath path, MailboxId mailboxId, User user, MailboxSession.SessionId sessionId, ACLDiff aclDiff) {
            this.eventId = eventId;
            this.path = path;
            this.mailboxId = mailboxId;
            this.user = user;
            this.sessionId = sessionId;
            this.aclDiff = aclDiff;
        }

        public MailboxListener.MailboxACLUpdated build() {
            Preconditions.checkNotNull((Object)this.path);
            Preconditions.checkNotNull((Object)this.mailboxId);
            Preconditions.checkNotNull((Object)this.user);
            Preconditions.checkNotNull((Object)this.sessionId);
            Preconditions.checkNotNull((Object)this.aclDiff);
            return new MailboxListener.MailboxACLUpdated(this.sessionId, this.user, this.path, this.aclDiff, this.mailboxId, this.eventId);
        }
    }

    public static class ExpungedFinalStage {
        private final Event.EventId eventId;
        private final MailboxPath path;
        private final MailboxId mailboxId;
        private final User user;
        private final MailboxSession.SessionId sessionId;
        private final ImmutableSortedMap<MessageUid, MessageMetaData> metaData;

        ExpungedFinalStage(Event.EventId eventId, MailboxPath path, MailboxId mailboxId, User user, MailboxSession.SessionId sessionId, Map<MessageUid, MessageMetaData> metaData) {
            this.eventId = eventId;
            this.path = path;
            this.mailboxId = mailboxId;
            this.user = user;
            this.sessionId = sessionId;
            this.metaData = ImmutableSortedMap.copyOf(metaData);
        }

        public MailboxListener.Expunged build() {
            Preconditions.checkNotNull((Object)this.path);
            Preconditions.checkNotNull((Object)this.mailboxId);
            Preconditions.checkNotNull((Object)this.user);
            Preconditions.checkNotNull((Object)this.sessionId);
            Preconditions.checkNotNull(this.metaData);
            return new MailboxListener.Expunged(this.sessionId, this.user, this.path, this.mailboxId, this.metaData, this.eventId);
        }
    }

    public static class AddedFinalStage {
        private final Event.EventId eventId;
        private final MailboxPath path;
        private final MailboxId mailboxId;
        private final User user;
        private final MailboxSession.SessionId sessionId;
        private final ImmutableSortedMap<MessageUid, MessageMetaData> metaData;

        AddedFinalStage(Event.EventId eventId, MailboxPath path, MailboxId mailboxId, User user, MailboxSession.SessionId sessionId, Map<MessageUid, MessageMetaData> metaData) {
            this.eventId = eventId;
            this.path = path;
            this.mailboxId = mailboxId;
            this.user = user;
            this.sessionId = sessionId;
            this.metaData = ImmutableSortedMap.copyOf(metaData);
        }

        public MailboxListener.Added build() {
            Preconditions.checkNotNull((Object)this.path);
            Preconditions.checkNotNull((Object)this.mailboxId);
            Preconditions.checkNotNull((Object)this.user);
            Preconditions.checkNotNull((Object)this.sessionId);
            Preconditions.checkNotNull(this.metaData);
            return new MailboxListener.Added(this.sessionId, this.user, this.path, this.mailboxId, this.metaData, this.eventId);
        }
    }

    public static class MailboxAddedFinalStage {
        private final Event.EventId eventId;
        private final MailboxPath path;
        private final MailboxId mailboxId;
        private final User user;
        private final MailboxSession.SessionId sessionId;

        MailboxAddedFinalStage(Event.EventId eventId, MailboxPath path, MailboxId mailboxId, User user, MailboxSession.SessionId sessionId) {
            this.eventId = eventId;
            this.path = path;
            this.mailboxId = mailboxId;
            this.user = user;
            this.sessionId = sessionId;
        }

        public MailboxListener.MailboxAdded build() {
            Preconditions.checkNotNull((Object)this.path);
            Preconditions.checkNotNull((Object)this.mailboxId);
            Preconditions.checkNotNull((Object)this.user);
            Preconditions.checkNotNull((Object)this.sessionId);
            return new MailboxListener.MailboxAdded(this.sessionId, this.user, this.path, this.mailboxId, this.eventId);
        }
    }

    @FunctionalInterface
    public static interface RequireMailboxEvent<T>
    extends RequireEventId<RequireSession<RequireMailbox<T>>> {
    }

    @FunctionalInterface
    public static interface RequireInstant<T> {
        public T instant(Instant var1);
    }

    @FunctionalInterface
    public static interface RequireQuotaSize<T> {
        public T quotaSize(Quota<QuotaSize> var1);
    }

    @FunctionalInterface
    public static interface RequireQuotaCount<T> {
        public T quotaCount(Quota<QuotaCount> var1);
    }

    @FunctionalInterface
    public static interface RequireQuotaSizeValue<T> {
        public T quotaSize(QuotaSize var1);
    }

    @FunctionalInterface
    public static interface RequireQuotaCountValue<T> {
        public T quotaCount(QuotaCount var1);
    }

    @FunctionalInterface
    public static interface RequireQuotaRoot<T> {
        public T quotaRoot(QuotaRoot var1);
    }

    @FunctionalInterface
    public static interface RequireUpdatedFlags<T> {
        public T updatedFlags(ImmutableList<UpdatedFlags> var1);

        default public T updatedFlags(Iterable<UpdatedFlags> updatedFlags) {
            return this.updatedFlags((ImmutableList<UpdatedFlags>)ImmutableList.copyOf(updatedFlags));
        }

        default public T updatedFlag(UpdatedFlags updatedFlags) {
            return this.updatedFlags((ImmutableList<UpdatedFlags>)ImmutableList.of((Object)updatedFlags));
        }
    }

    @FunctionalInterface
    public static interface RequireAclDiff<T> {
        public T aclDiff(ACLDiff var1);
    }

    @FunctionalInterface
    public static interface RequireMetadata<T> {
        public T metaData(SortedMap<MessageUid, MessageMetaData> var1);

        default public T addMetaData(MessageMetaData metaData) {
            return this.metaData((SortedMap<MessageUid, MessageMetaData>)ImmutableSortedMap.of((Comparable)metaData.getUid(), (Object)metaData));
        }

        default public T addMessage(MailboxMessage message) {
            return this.addMetaData(message.metaData());
        }

        default public T addMetaData(Iterable<MessageMetaData> metaData) {
            return this.metaData((SortedMap)ImmutableList.copyOf(metaData).stream().collect(Guavate.toImmutableSortedMap(MessageMetaData::getUid)));
        }

        default public T addMetaData(Iterator<MessageMetaData> metaData) {
            return this.addMetaData((Iterable<MessageMetaData>)ImmutableList.copyOf(metaData));
        }

        default public T addMessages(Iterable<MailboxMessage> messages) {
            return this.metaData((SortedMap)ImmutableList.copyOf(messages).stream().map(MailboxMessage::metaData).collect(Guavate.toImmutableSortedMap(MessageMetaData::getUid)));
        }
    }

    @FunctionalInterface
    public static interface RequireOldPath<T> {
        public T oldPath(MailboxPath var1);
    }

    @FunctionalInterface
    public static interface RequireNewPath<T> {
        public T newPath(MailboxPath var1);
    }

    @FunctionalInterface
    public static interface RequireMailbox<T>
    extends RequireMailboxId<RequirePath<T>> {
        default public T mailbox(Mailbox mailbox) {
            return ((RequirePath)this.mailboxId(mailbox.getMailboxId())).mailboxPath(mailbox.generateAssociatedPath());
        }
    }

    @FunctionalInterface
    public static interface RequirePath<T> {
        public T mailboxPath(MailboxPath var1);
    }

    @FunctionalInterface
    public static interface RequireMailboxId<T> {
        public T mailboxId(MailboxId var1);
    }

    @FunctionalInterface
    public static interface RequireSession<T>
    extends RequireUser<RequireSessionId<T>> {
        default public T mailboxSession(MailboxSession session) {
            return ((RequireSessionId)this.user(session.getUser())).sessionId(session.getSessionId());
        }
    }

    @FunctionalInterface
    public static interface RequireSessionId<T> {
        public T sessionId(MailboxSession.SessionId var1);
    }

    @FunctionalInterface
    public static interface RequireUser<T> {
        public T user(User var1);
    }

    @FunctionalInterface
    public static interface RequireEventId<T> {
        public T eventId(Event.EventId var1);

        default public T randomEventId() {
            return this.eventId(Event.EventId.random());
        }
    }
}

