/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import com.github.fge.lambdas.Throwing;
import com.github.fge.lambdas.functions.ThrowingFunction;
import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.mail.Flags;
import javax.mail.internet.SharedInputStream;
import org.apache.james.core.quota.QuotaCount;
import org.apache.james.core.quota.QuotaSize;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.events.Event;
import org.apache.james.mailbox.events.EventBus;
import org.apache.james.mailbox.events.MailboxIdRegistrationKey;
import org.apache.james.mailbox.events.RegistrationKey;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.DeleteResult;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageAttachment;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.MessageMoves;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.ResultUtils;
import org.apache.james.mailbox.store.event.EventFactory;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.MessageIdMapper;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.FlagsFactory;
import org.apache.james.mailbox.store.mail.model.FlagsFilter;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.mailbox.store.mail.model.impl.PropertyBuilder;
import org.apache.james.mailbox.store.mail.model.impl.SimpleMailboxMessage;
import org.apache.james.mailbox.store.quota.QuotaChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public class StoreMessageIdManager
implements MessageIdManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(StoreMessageIdManager.class);
    private final MailboxManager mailboxManager;
    private final MailboxSessionMapperFactory mailboxSessionMapperFactory;
    private final EventBus eventBus;
    private final MessageId.Factory messageIdFactory;
    private final QuotaManager quotaManager;
    private final QuotaRootResolver quotaRootResolver;

    private static MetadataWithMailboxId toMetadataWithMailboxId(MailboxMessage message) {
        return new MetadataWithMailboxId(message.metaData(), message.getMailboxId());
    }

    public static ImmutableSet<MailboxId> toMailboxIds(List<MailboxMessage> mailboxMessages) {
        return (ImmutableSet)mailboxMessages.stream().map(MailboxMessage::getMailboxId).collect(Guavate.toImmutableSet());
    }

    @Inject
    public StoreMessageIdManager(MailboxManager mailboxManager, MailboxSessionMapperFactory mailboxSessionMapperFactory, EventBus eventBus, MessageId.Factory messageIdFactory, QuotaManager quotaManager, QuotaRootResolver quotaRootResolver) {
        this.mailboxManager = mailboxManager;
        this.mailboxSessionMapperFactory = mailboxSessionMapperFactory;
        this.eventBus = eventBus;
        this.messageIdFactory = messageIdFactory;
        this.quotaManager = quotaManager;
        this.quotaRootResolver = quotaRootResolver;
    }

    public void setFlags(Flags newState, MessageManager.FlagsUpdateMode replace, MessageId messageId, List<MailboxId> mailboxIds, MailboxSession mailboxSession) throws MailboxException {
        MessageIdMapper messageIdMapper = this.mailboxSessionMapperFactory.getMessageIdMapper(mailboxSession);
        this.assertRightsOnMailboxes(mailboxIds, mailboxSession, MailboxACL.Right.Write);
        Map<MailboxId, UpdatedFlags> updatedFlags = messageIdMapper.setFlags(messageId, mailboxIds, newState, replace);
        for (Map.Entry<MailboxId, UpdatedFlags> entry : updatedFlags.entrySet()) {
            this.dispatchFlagsChange(mailboxSession, entry.getKey(), entry.getValue());
        }
    }

    public Set<MessageId> accessibleMessages(Collection<MessageId> messageIds, MailboxSession mailboxSession) throws MailboxException {
        MessageIdMapper messageIdMapper = this.mailboxSessionMapperFactory.getMessageIdMapper(mailboxSession);
        List<MailboxMessage> messageList = messageIdMapper.find(messageIds, MessageMapper.FetchType.Metadata);
        ImmutableSet<MailboxId> allowedMailboxIds = this.getAllowedMailboxIds(mailboxSession, messageList, MailboxACL.Right.Read);
        return (Set)messageList.stream().filter(message -> allowedMailboxIds.contains((Object)message.getMailboxId())).map(Message::getMessageId).collect(Guavate.toImmutableSet());
    }

    public List<MessageResult> getMessages(List<MessageId> messageIds, MessageResult.FetchGroup fetchGroup, MailboxSession mailboxSession) throws MailboxException {
        MessageIdMapper messageIdMapper = this.mailboxSessionMapperFactory.getMessageIdMapper(mailboxSession);
        List<MailboxMessage> messageList = messageIdMapper.find(messageIds, MessageMapper.FetchType.Full);
        ImmutableSet<MailboxId> allowedMailboxIds = this.getAllowedMailboxIds(mailboxSession, messageList, MailboxACL.Right.Read);
        return (List)messageList.stream().filter(this.inMailboxes((Collection<MailboxId>)allowedMailboxIds)).map(Throwing.function(this.messageResultConverter(fetchGroup)).sneakyThrow()).collect(Guavate.toImmutableList());
    }

    private ImmutableSet<MailboxId> getAllowedMailboxIds(MailboxSession mailboxSession, List<MailboxMessage> messageList, MailboxACL.Right ... rights) {
        return (ImmutableSet)messageList.stream().map(MailboxMessage::getMailboxId).distinct().filter(this.hasRightsOnMailbox(mailboxSession, rights)).collect(Guavate.toImmutableSet());
    }

    public DeleteResult delete(MessageId messageId, List<MailboxId> mailboxIds, MailboxSession mailboxSession) throws MailboxException {
        MessageIdMapper messageIdMapper = this.mailboxSessionMapperFactory.getMessageIdMapper(mailboxSession);
        this.assertRightsOnMailboxes(mailboxIds, mailboxSession, MailboxACL.Right.DeleteMessages);
        List messageList = (List)messageIdMapper.find((Collection<MessageId>)ImmutableList.of((Object)messageId), MessageMapper.FetchType.Metadata).stream().filter(this.inMailboxes(mailboxIds)).collect(Guavate.toImmutableList());
        if (!messageList.isEmpty()) {
            this.delete(messageIdMapper, messageList, mailboxSession);
            return DeleteResult.destroyed((MessageId)messageId);
        }
        return DeleteResult.notFound((MessageId)messageId);
    }

    public DeleteResult delete(List<MessageId> messageIds, MailboxSession mailboxSession) throws MailboxException {
        MessageIdMapper messageIdMapper = this.mailboxSessionMapperFactory.getMessageIdMapper(mailboxSession);
        List<MailboxMessage> messageList = messageIdMapper.find(messageIds, MessageMapper.FetchType.Metadata);
        ImmutableSet<MailboxId> allowedMailboxIds = this.getAllowedMailboxIds(mailboxSession, messageList, MailboxACL.Right.DeleteMessages);
        ImmutableSet accessibleMessages = (ImmutableSet)messageList.stream().filter(message -> allowedMailboxIds.contains((Object)message.getMailboxId())).map(Message::getMessageId).distinct().collect(Guavate.toImmutableSet());
        Sets.SetView nonAccessibleMessages = Sets.difference((Set)ImmutableSet.copyOf(messageIds), (Set)accessibleMessages);
        this.delete(messageIdMapper, messageList, mailboxSession);
        return DeleteResult.builder().addDestroyed((Collection)accessibleMessages).addNotFound((Collection)nonAccessibleMessages).build();
    }

    private void delete(MessageIdMapper messageIdMapper, List<MailboxMessage> messageList, MailboxSession mailboxSession) throws MailboxException {
        ImmutableList metadataWithMailbox = (ImmutableList)messageList.stream().map(StoreMessageIdManager::toMetadataWithMailboxId).collect(Guavate.toImmutableList());
        messageIdMapper.delete((Multimap<MessageId, MailboxId>)((Multimap)messageList.stream().collect(Guavate.toImmutableListMultimap(Message::getMessageId, MailboxMessage::getMailboxId))));
        MailboxMapper mailboxMapper = this.mailboxSessionMapperFactory.getMailboxMapper(mailboxSession);
        Flux.fromIterable((Iterable)metadataWithMailbox).flatMap(Throwing.function(metadataWithMailboxId -> this.eventBus.dispatch((Event)((EventFactory.ExpungedFinalStage)((EventFactory.RequireMetadata)((EventFactory.RequireMailbox)((EventFactory.RequireSession)EventFactory.expunged().randomEventId()).mailboxSession(mailboxSession)).mailbox(mailboxMapper.findMailboxById(((MetadataWithMailboxId)metadataWithMailboxId).mailboxId))).addMetaData(((MetadataWithMailboxId)metadataWithMailboxId).messageMetaData)).build(), (RegistrationKey)new MailboxIdRegistrationKey(((MetadataWithMailboxId)metadataWithMailboxId).mailboxId))).sneakyThrow()).then().block();
    }

    public void setInMailboxes(MessageId messageId, Collection<MailboxId> targetMailboxIds, MailboxSession mailboxSession) throws MailboxException {
        this.assertRightsOnMailboxes(targetMailboxIds, mailboxSession, MailboxACL.Right.Read);
        List<MailboxMessage> currentMailboxMessages = this.findRelatedMailboxMessages(messageId, mailboxSession);
        if (currentMailboxMessages.isEmpty()) {
            LOGGER.info("Tried to access {} not accessible for {}", (Object)messageId, (Object)mailboxSession.getUser().asString());
            return;
        }
        MessageMoves messageMoves = MessageMoves.builder().targetMailboxIds(targetMailboxIds).previousMailboxIds(StoreMessageIdManager.toMailboxIds(currentMailboxMessages)).build();
        if (messageMoves.isChange()) {
            this.applyMessageMoves(mailboxSession, currentMailboxMessages, messageMoves);
        }
    }

    public void setInMailboxesNoCheck(MessageId messageId, MailboxId targetMailboxId, MailboxSession mailboxSession) throws MailboxException {
        MessageIdMapper messageIdMapper = this.mailboxSessionMapperFactory.getMessageIdMapper(mailboxSession);
        List<MailboxMessage> currentMailboxMessages = messageIdMapper.find((Collection<MessageId>)ImmutableList.of((Object)messageId), MessageMapper.FetchType.Full);
        MessageMoves messageMoves = MessageMoves.builder().previousMailboxIds(StoreMessageIdManager.toMailboxIds(currentMailboxMessages)).targetMailboxIds(new MailboxId[]{targetMailboxId}).build();
        if (messageMoves.isChange()) {
            this.applyMessageMoveNoMailboxChecks(mailboxSession, currentMailboxMessages, messageMoves);
        }
    }

    private List<MailboxMessage> findRelatedMailboxMessages(MessageId messageId, MailboxSession mailboxSession) throws MailboxException {
        MessageIdMapper messageIdMapper = this.mailboxSessionMapperFactory.getMessageIdMapper(mailboxSession);
        return (List)messageIdMapper.find((Collection<MessageId>)ImmutableList.of((Object)messageId), MessageMapper.FetchType.Full).stream().filter(this.hasRightsOn(mailboxSession, MailboxACL.Right.Read)).collect(Guavate.toImmutableList());
    }

    private void applyMessageMoves(MailboxSession mailboxSession, List<MailboxMessage> currentMailboxMessages, MessageMoves messageMoves) throws MailboxException {
        this.assertRightsOnMailboxes(messageMoves.addedMailboxIds(), mailboxSession, MailboxACL.Right.Insert);
        this.assertRightsOnMailboxes(messageMoves.removedMailboxIds(), mailboxSession, MailboxACL.Right.DeleteMessages);
        this.applyMessageMoveNoMailboxChecks(mailboxSession, currentMailboxMessages, messageMoves);
    }

    private void applyMessageMoveNoMailboxChecks(MailboxSession mailboxSession, List<MailboxMessage> currentMailboxMessages, MessageMoves messageMoves) throws MailboxException {
        MailboxMessage mailboxMessage = (MailboxMessage)currentMailboxMessages.stream().findAny().orElseThrow(() -> new MailboxNotFoundException("can't load message"));
        this.validateQuota(messageMoves, mailboxSession, mailboxMessage);
        this.addMessageToMailboxes(mailboxMessage, messageMoves.addedMailboxIds(), mailboxSession);
        this.removeMessageFromMailboxes(mailboxMessage, messageMoves.removedMailboxIds(), mailboxSession);
        this.eventBus.dispatch((Event)EventFactory.moved().session(mailboxSession).messageMoves(messageMoves).messageId(mailboxMessage.getMessageId()).build(), (Set)messageMoves.impactedMailboxIds().map(MailboxIdRegistrationKey::new).collect(Guavate.toImmutableSet())).block();
    }

    private void removeMessageFromMailboxes(MailboxMessage message, Set<MailboxId> mailboxesToRemove, MailboxSession mailboxSession) throws MailboxException {
        MessageIdMapper messageIdMapper = this.mailboxSessionMapperFactory.getMessageIdMapper(mailboxSession);
        MailboxMapper mailboxMapper = this.mailboxSessionMapperFactory.getMailboxMapper(mailboxSession);
        MessageMetaData eventPayload = message.metaData();
        for (MailboxId mailboxId : mailboxesToRemove) {
            messageIdMapper.delete(message.getMessageId(), mailboxesToRemove);
            this.eventBus.dispatch((Event)((EventFactory.ExpungedFinalStage)((EventFactory.RequireMetadata)((EventFactory.RequireMailbox)((EventFactory.RequireSession)EventFactory.expunged().randomEventId()).mailboxSession(mailboxSession)).mailbox(mailboxMapper.findMailboxById(mailboxId))).addMetaData(eventPayload)).build(), (RegistrationKey)new MailboxIdRegistrationKey(mailboxId)).block();
        }
    }

    protected MailboxMessage createMessage(Date internalDate, int size, int bodyStartOctet, SharedInputStream content, Flags flags, PropertyBuilder propertyBuilder, List<MessageAttachment> attachments, MailboxId mailboxId) throws MailboxException {
        return new SimpleMailboxMessage(this.messageIdFactory.generate(), internalDate, size, bodyStartOctet, content, flags, propertyBuilder, mailboxId, attachments);
    }

    private void dispatchFlagsChange(MailboxSession mailboxSession, MailboxId mailboxId, UpdatedFlags updatedFlags) throws MailboxException {
        if (updatedFlags.flagsChanged()) {
            Mailbox mailbox = this.mailboxSessionMapperFactory.getMailboxMapper(mailboxSession).findMailboxById(mailboxId);
            this.eventBus.dispatch((Event)((EventFactory.FlagsUpdatedFinalStage)((EventFactory.RequireUpdatedFlags)((EventFactory.RequireMailbox)((EventFactory.RequireSession)EventFactory.flagsUpdated().randomEventId()).mailboxSession(mailboxSession)).mailbox(mailbox)).updatedFlag(updatedFlags)).build(), (RegistrationKey)new MailboxIdRegistrationKey(mailboxId)).block();
        }
    }

    private void validateQuota(MessageMoves messageMoves, MailboxSession mailboxSession, MailboxMessage mailboxMessage) throws MailboxException {
        MailboxMapper mailboxMapper = this.mailboxSessionMapperFactory.getMailboxMapper(mailboxSession);
        Map<QuotaRoot, Integer> messageCountByQuotaRoot = this.buildMapQuotaRoot(messageMoves, mailboxMapper);
        for (Map.Entry<QuotaRoot, Integer> entry : messageCountByQuotaRoot.entrySet()) {
            Integer additionalCopyCount = entry.getValue();
            if (additionalCopyCount <= 0) continue;
            long additionalOccupiedSpace = (long)additionalCopyCount.intValue() * mailboxMessage.getFullContentOctets();
            new QuotaChecker((Quota<QuotaCount>)this.quotaManager.getMessageQuota(entry.getKey()), (Quota<QuotaSize>)this.quotaManager.getStorageQuota(entry.getKey()), entry.getKey()).tryAddition(additionalCopyCount.intValue(), additionalOccupiedSpace);
        }
    }

    private Map<QuotaRoot, Integer> buildMapQuotaRoot(MessageMoves messageMoves, MailboxMapper mailboxMapper) throws MailboxException {
        int currentCount;
        QuotaRoot quotaRoot;
        HashMap<QuotaRoot, Integer> messageCountByQuotaRoot = new HashMap<QuotaRoot, Integer>();
        for (MailboxId mailboxId : messageMoves.addedMailboxIds()) {
            quotaRoot = this.retrieveQuotaRoot(mailboxMapper, mailboxId);
            currentCount = Optional.ofNullable(messageCountByQuotaRoot.get(quotaRoot)).orElse(0);
            messageCountByQuotaRoot.put(quotaRoot, currentCount + 1);
        }
        for (MailboxId mailboxId : messageMoves.removedMailboxIds()) {
            quotaRoot = this.retrieveQuotaRoot(mailboxMapper, mailboxId);
            currentCount = Optional.ofNullable(messageCountByQuotaRoot.get(quotaRoot)).orElse(0);
            messageCountByQuotaRoot.put(quotaRoot, currentCount - 1);
        }
        return messageCountByQuotaRoot;
    }

    private QuotaRoot retrieveQuotaRoot(MailboxMapper mailboxMapper, MailboxId mailboxId) throws MailboxException {
        Mailbox mailbox = mailboxMapper.findMailboxById(mailboxId);
        return this.quotaRootResolver.getQuotaRoot(mailbox.generateAssociatedPath());
    }

    private void addMessageToMailboxes(MailboxMessage mailboxMessage, Set<MailboxId> mailboxIds, MailboxSession mailboxSession) throws MailboxException {
        MessageIdMapper messageIdMapper = this.mailboxSessionMapperFactory.getMessageIdMapper(mailboxSession);
        MailboxMapper mailboxMapper = this.mailboxSessionMapperFactory.getMailboxMapper(mailboxSession);
        for (MailboxId mailboxId : mailboxIds) {
            boolean shouldPreserveFlags = this.mailboxManager.myRights(mailboxId, mailboxSession).contains(MailboxACL.Right.Write);
            SimpleMailboxMessage copy = SimpleMailboxMessage.from(mailboxMessage).mailboxId(mailboxId).flags(FlagsFactory.builder().flags(mailboxMessage.createFlags()).filteringFlags(FlagsFilter.builder().systemFlagFilter(f -> shouldPreserveFlags).userFlagFilter(f -> shouldPreserveFlags).build()).build()).build();
            this.save(mailboxSession, messageIdMapper, copy);
            this.eventBus.dispatch((Event)((EventFactory.AddedFinalStage)((EventFactory.RequireMetadata)((EventFactory.RequireMailbox)((EventFactory.RequireSession)EventFactory.added().randomEventId()).mailboxSession(mailboxSession)).mailbox(mailboxMapper.findMailboxById(mailboxId))).addMessage(copy)).build(), (RegistrationKey)new MailboxIdRegistrationKey(mailboxId)).block();
        }
    }

    private void save(MailboxSession mailboxSession, MessageIdMapper messageIdMapper, MailboxMessage mailboxMessage) throws MailboxException {
        long modSeq = this.mailboxSessionMapperFactory.getModSeqProvider().nextModSeq(mailboxSession, mailboxMessage.getMailboxId());
        MessageUid uid = this.mailboxSessionMapperFactory.getUidProvider().nextUid(mailboxSession, mailboxMessage.getMailboxId());
        mailboxMessage.setModSeq(modSeq);
        mailboxMessage.setUid(uid);
        messageIdMapper.copyInMailbox(mailboxMessage);
    }

    private ThrowingFunction<MailboxMessage, MessageResult> messageResultConverter(MessageResult.FetchGroup fetchGroup) {
        return input -> ResultUtils.loadMessageResult(input, fetchGroup);
    }

    private Predicate<MailboxMessage> inMailboxes(Collection<MailboxId> mailboxIds) {
        return mailboxMessage -> mailboxIds.contains(mailboxMessage.getMailboxId());
    }

    private Predicate<MailboxMessage> hasRightsOn(MailboxSession session, MailboxACL.Right ... rights) {
        return message -> this.hasRightsOnMailbox(session, rights).test(message.getMailboxId());
    }

    private Predicate<MailboxId> hasRightsOnMailbox(MailboxSession session, MailboxACL.Right ... rights) {
        return Throwing.predicate(mailboxId -> this.mailboxManager.myRights(mailboxId, session).contains(rights)).fallbackTo(any -> false);
    }

    private void assertRightsOnMailboxes(Collection<MailboxId> mailboxIds, MailboxSession mailboxSession, MailboxACL.Right ... rights) throws MailboxNotFoundException {
        Optional<MailboxId> mailboxForbidden = mailboxIds.stream().filter(this.hasRightsOnMailbox(mailboxSession, rights).negate()).findFirst();
        if (mailboxForbidden.isPresent()) {
            LOGGER.info("Mailbox with Id {} does not belong to {}", (Object)mailboxForbidden.get(), (Object)mailboxSession.getUser().asString());
            throw new MailboxNotFoundException(mailboxForbidden.get());
        }
    }

    private static class MetadataWithMailboxId {
        private final MessageMetaData messageMetaData;
        private final MailboxId mailboxId;

        public MetadataWithMailboxId(MessageMetaData messageMetaData, MailboxId mailboxId) {
            this.messageMetaData = messageMetaData;
            this.mailboxId = mailboxId;
        }
    }
}

