/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import com.github.fge.lambdas.Throwing;
import com.github.steveash.guavate.Guavate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.james.core.quota.QuotaCount;
import org.apache.james.core.quota.QuotaSize;
import org.apache.james.mailbox.MailboxAnnotationManager;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.StandardMailboxMetaDataComparator;
import org.apache.james.mailbox.events.Event;
import org.apache.james.mailbox.events.EventBus;
import org.apache.james.mailbox.events.MailboxIdRegistrationKey;
import org.apache.james.mailbox.events.RegistrationKey;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.exception.TooLongMailboxNameException;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxAnnotation;
import org.apache.james.mailbox.model.MailboxAnnotationKey;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MultimailboxesSearchQuery;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.model.search.MailboxNameExpression;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.mailbox.store.MailboxManagerConfiguration;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.SessionProvider;
import org.apache.james.mailbox.store.StoreMessageManager;
import org.apache.james.mailbox.store.StoreRightManager;
import org.apache.james.mailbox.store.event.EventFactory;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;
import org.apache.james.mailbox.store.mail.model.impl.SimpleMailbox;
import org.apache.james.mailbox.store.quota.QuotaComponents;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import org.apache.james.mailbox.store.transaction.Mapper;
import org.apache.james.util.streams.Iterators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreMailboxManager
implements MailboxManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(StoreMailboxManager.class);
    public static final char SQL_WILDCARD_CHAR = '%';
    public static final EnumSet<MailboxManager.MessageCapabilities> DEFAULT_NO_MESSAGE_CAPABILITIES = EnumSet.noneOf(MailboxManager.MessageCapabilities.class);
    private static final SecureRandom RANDOM = new SecureRandom();
    private final StoreRightManager storeRightManager;
    private final EventBus eventBus;
    private final MailboxSessionMapperFactory mailboxSessionMapperFactory;
    private final MailboxAnnotationManager annotationManager;
    private final MailboxPathLocker locker;
    private final MessageParser messageParser;
    private final MessageId.Factory messageIdFactory;
    private final SessionProvider sessionProvider;
    private final QuotaManager quotaManager;
    private final QuotaRootResolver quotaRootResolver;
    private final QuotaComponents quotaComponents;
    private final MessageSearchIndex index;
    protected final MailboxManagerConfiguration configuration;

    @Inject
    public StoreMailboxManager(MailboxSessionMapperFactory mailboxSessionMapperFactory, SessionProvider sessionProvider, MailboxPathLocker locker, MessageParser messageParser, MessageId.Factory messageIdFactory, MailboxAnnotationManager annotationManager, EventBus eventBus, StoreRightManager storeRightManager, QuotaComponents quotaComponents, MessageSearchIndex searchIndex, MailboxManagerConfiguration configuration) {
        Preconditions.checkNotNull((Object)eventBus);
        Preconditions.checkNotNull((Object)mailboxSessionMapperFactory);
        this.annotationManager = annotationManager;
        this.sessionProvider = sessionProvider;
        this.locker = locker;
        this.mailboxSessionMapperFactory = mailboxSessionMapperFactory;
        this.messageParser = messageParser;
        this.messageIdFactory = messageIdFactory;
        this.eventBus = eventBus;
        this.storeRightManager = storeRightManager;
        this.quotaRootResolver = quotaComponents.getQuotaRootResolver();
        this.quotaManager = quotaComponents.getQuotaManager();
        this.quotaComponents = quotaComponents;
        this.index = searchIndex;
        this.configuration = configuration;
    }

    public QuotaComponents getQuotaComponents() {
        return this.quotaComponents;
    }

    public MessageId.Factory getMessageIdFactory() {
        return this.messageIdFactory;
    }

    public SessionProvider getSessionProvider() {
        return this.sessionProvider;
    }

    public EnumSet<MailboxManager.MailboxCapabilities> getSupportedMailboxCapabilities() {
        return EnumSet.noneOf(MailboxManager.MailboxCapabilities.class);
    }

    public EnumSet<MailboxManager.MessageCapabilities> getSupportedMessageCapabilities() {
        return DEFAULT_NO_MESSAGE_CAPABILITIES;
    }

    public EnumSet<MailboxManager.SearchCapabilities> getSupportedSearchCapabilities() {
        return this.index.getSupportedCapabilities(this.getSupportedMessageCapabilities());
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public MessageSearchIndex getMessageSearchIndex() {
        return this.index;
    }

    public MailboxSessionMapperFactory getMapperFactory() {
        return this.mailboxSessionMapperFactory;
    }

    public MailboxPathLocker getLocker() {
        return this.locker;
    }

    protected StoreRightManager getStoreRightManager() {
        return this.storeRightManager;
    }

    public MessageParser getMessageParser() {
        return this.messageParser;
    }

    protected int randomUidValidity() {
        return Math.abs(RANDOM.nextInt());
    }

    public MailboxSession createSystemSession(String userName) {
        return this.sessionProvider.createSystemSession(userName);
    }

    public char getDelimiter() {
        return this.sessionProvider.getDelimiter();
    }

    public MailboxSession login(String userid, String passwd) throws MailboxException {
        return this.sessionProvider.login(userid, passwd);
    }

    public MailboxSession loginAsOtherUser(String adminUserid, String passwd, String otherUserId) throws MailboxException {
        return this.sessionProvider.loginAsOtherUser(adminUserid, passwd, otherUserId);
    }

    public void logout(MailboxSession session, boolean force) {
        this.sessionProvider.logout(session);
    }

    protected StoreMessageManager createMessageManager(Mailbox mailbox, MailboxSession session) throws MailboxException {
        return new StoreMessageManager(DEFAULT_NO_MESSAGE_CAPABILITIES, this.getMapperFactory(), this.getMessageSearchIndex(), this.getEventBus(), this.getLocker(), mailbox, this.quotaManager, this.getQuotaComponents().getQuotaRootResolver(), this.getMessageParser(), this.getMessageIdFactory(), this.configuration.getBatchSizes(), this.getStoreRightManager());
    }

    protected Mailbox doCreateMailbox(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        return new SimpleMailbox(mailboxPath, this.randomUidValidity());
    }

    public MessageManager getMailbox(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        Mailbox mailboxRow = mapper.findMailboxByPath(mailboxPath);
        if (mailboxRow == null) {
            LOGGER.info("Mailbox '{}' not found.", (Object)mailboxPath);
            throw new MailboxNotFoundException(mailboxPath);
        }
        LOGGER.debug("Loaded mailbox {}", (Object)mailboxPath);
        return this.createMessageManager(mailboxRow, session);
    }

    public MessageManager getMailbox(MailboxId mailboxId, MailboxSession session) throws MailboxException {
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        Mailbox mailboxRow = mapper.findMailboxById(mailboxId);
        if (mailboxRow == null) {
            LOGGER.info("Mailbox '{}' not found.", (Object)mailboxId.serialize());
            throw new MailboxNotFoundException(mailboxId);
        }
        if (!this.assertUserHasAccessTo(mailboxRow, session)) {
            LOGGER.info("Mailbox '{}' does not belong to user '{}' but to '{}'", new Object[]{mailboxId.serialize(), session.getUser(), mailboxRow.getUser()});
            throw new MailboxNotFoundException(mailboxId);
        }
        LOGGER.debug("Loaded mailbox {}", (Object)mailboxId.serialize());
        return this.createMessageManager(mailboxRow, session);
    }

    private boolean assertUserHasAccessTo(Mailbox mailbox, MailboxSession session) throws MailboxException {
        return this.belongsToCurrentUser(mailbox, session) || this.userHasLookupRightsOn(mailbox, session);
    }

    private boolean belongsToCurrentUser(Mailbox mailbox, MailboxSession session) {
        return mailbox.generateAssociatedPath().belongsTo(session);
    }

    private boolean userHasLookupRightsOn(Mailbox mailbox, MailboxSession session) throws MailboxException {
        return this.storeRightManager.hasRight(mailbox, MailboxACL.Right.Lookup, session);
    }

    public Optional<MailboxId> createMailbox(MailboxPath mailboxPath, MailboxSession mailboxSession) throws MailboxException {
        LOGGER.debug("createMailbox {}", (Object)mailboxPath);
        if (mailboxPath.getName().isEmpty()) {
            LOGGER.warn("Ignoring mailbox with empty name");
        } else {
            MailboxPath sanitizedMailboxPath = mailboxPath.sanitize(mailboxSession.getPathDelimiter());
            if (this.isMailboxNameTooLong(mailboxPath)) {
                throw new TooLongMailboxNameException("Mailbox name exceed maximum size of 200 characters");
            }
            if (this.mailboxExists(sanitizedMailboxPath, mailboxSession)) {
                throw new MailboxExistsException(sanitizedMailboxPath.asString());
            }
            ArrayList mailboxIds = new ArrayList();
            for (MailboxPath mailbox : sanitizedMailboxPath.getHierarchyLevels(this.getDelimiter())) {
                this.locker.executeWithLock(mailboxSession, mailbox, () -> {
                    if (!this.mailboxExists(mailbox, mailboxSession)) {
                        Mailbox m = this.doCreateMailbox(mailbox, mailboxSession);
                        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(mailboxSession);
                        try {
                            mapper.execute(Mapper.toTransaction(() -> mailboxIds.add(mapper.save(m))));
                            this.eventBus.dispatch((Event)((EventFactory.MailboxAddedFinalStage)((EventFactory.RequireMailbox)((EventFactory.RequireSession)EventFactory.mailboxAdded().randomEventId()).mailboxSession(mailboxSession)).mailbox(m)).build(), (RegistrationKey)new MailboxIdRegistrationKey(m.getMailboxId())).block();
                        }
                        catch (MailboxExistsException e) {
                            LOGGER.info("{} mailbox was created concurrently", (Object)m.generateAssociatedPath());
                        }
                    }
                    return null;
                }, true);
            }
            if (!mailboxIds.isEmpty()) {
                return Optional.ofNullable(Iterables.getLast(mailboxIds));
            }
        }
        return Optional.empty();
    }

    public boolean isMailboxNameTooLong(MailboxPath mailboxPath) {
        return mailboxPath.getName().length() > 200;
    }

    public void deleteMailbox(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        LOGGER.info("deleteMailbox {}", (Object)mailboxPath);
        this.assertIsOwner(session, mailboxPath);
        MailboxMapper mailboxMapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        MessageMapper messageMapper = this.mailboxSessionMapperFactory.getMessageMapper(session);
        mailboxMapper.execute(() -> {
            Mailbox mailbox = mailboxMapper.findMailboxByPath(mailboxPath);
            if (mailbox == null) {
                throw new MailboxNotFoundException(mailboxPath);
            }
            QuotaRoot quotaRoot = this.quotaRootResolver.getQuotaRoot(mailboxPath);
            long messageCount = messageMapper.countMessagesInMailbox(mailbox);
            long totalSize = Iterators.toStream(messageMapper.findInMailbox(mailbox, MessageRange.all(), MessageMapper.FetchType.Metadata, -1)).mapToLong(Message::getFullContentOctets).sum();
            SimpleMailbox m = new SimpleMailbox(mailbox);
            mailboxMapper.delete(mailbox);
            this.eventBus.dispatch((Event)((EventFactory.MailboxDeletionFinalStage)((EventFactory.RequireQuotaSizeValue)((EventFactory.RequireQuotaCountValue)((EventFactory.RequireQuotaRoot)((EventFactory.RequireMailbox)((EventFactory.RequireSession)EventFactory.mailboxDeleted().randomEventId()).mailboxSession(session)).mailbox(mailbox)).quotaRoot(quotaRoot)).quotaCount(QuotaCount.count((long)messageCount))).quotaSize(QuotaSize.size((long)totalSize))).build(), (RegistrationKey)new MailboxIdRegistrationKey(mailbox.getMailboxId())).block();
            return m;
        });
    }

    public void renameMailbox(MailboxPath from, MailboxPath to, MailboxSession session) throws MailboxException {
        LOGGER.debug("renameMailbox {} to {}", (Object)from, (Object)to);
        if (this.mailboxExists(to, session)) {
            throw new MailboxExistsException(to.toString());
        }
        if (this.isMailboxNameTooLong(to)) {
            throw new TooLongMailboxNameException("Mailbox name exceed maximum size of 200 characters");
        }
        this.assertIsOwner(session, from);
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        mapper.execute(Mapper.toTransaction(() -> this.doRenameMailbox(from, to, session, mapper)));
    }

    private void assertIsOwner(MailboxSession mailboxSession, MailboxPath mailboxPath) throws MailboxNotFoundException {
        if (!mailboxPath.belongsTo(mailboxSession)) {
            LOGGER.info("Mailbox {} does not belong to {}", (Object)mailboxPath.asString(), (Object)mailboxSession.getUser().asString());
            throw new MailboxNotFoundException(mailboxPath.asString());
        }
    }

    private void doRenameMailbox(MailboxPath from, MailboxPath to, MailboxSession session, MailboxMapper mapper) throws MailboxException {
        Mailbox mailbox = Optional.ofNullable(mapper.findMailboxByPath(from)).orElseThrow(() -> new MailboxNotFoundException(from));
        mailbox.setNamespace(to.getNamespace());
        mailbox.setUser(to.getUser());
        mailbox.setName(to.getName());
        mapper.save(mailbox);
        this.eventBus.dispatch((Event)EventFactory.mailboxRenamed().randomEventId().mailboxSession(session).mailboxId(mailbox.getMailboxId()).oldPath(from).newPath(to).build(), (RegistrationKey)new MailboxIdRegistrationKey(mailbox.getMailboxId())).block();
        MailboxPath children = new MailboxPath(from.getNamespace(), from.getUser(), from.getName() + this.getDelimiter() + "%");
        this.locker.executeWithLock(session, children, () -> {
            List<Mailbox> subMailboxes = mapper.findMailboxWithPathLike(children);
            for (Mailbox sub : subMailboxes) {
                String subOriginalName = sub.getName();
                String subNewName = to.getName() + subOriginalName.substring(from.getName().length());
                MailboxPath fromPath = new MailboxPath(children, subOriginalName);
                sub.setName(subNewName);
                mapper.save(sub);
                this.eventBus.dispatch((Event)EventFactory.mailboxRenamed().randomEventId().mailboxSession(session).mailboxId(sub.getMailboxId()).oldPath(fromPath).newPath(sub.generateAssociatedPath()).build(), (RegistrationKey)new MailboxIdRegistrationKey(sub.getMailboxId())).block();
                LOGGER.debug("Rename mailbox sub-mailbox {} to {}", (Object)subOriginalName, (Object)subNewName);
            }
            return null;
        }, true);
    }

    public List<MessageRange> copyMessages(MessageRange set, MailboxPath from, MailboxPath to, MailboxSession session) throws MailboxException {
        StoreMessageManager toMailbox = (StoreMessageManager)this.getMailbox(to, session);
        StoreMessageManager fromMailbox = (StoreMessageManager)this.getMailbox(from, session);
        return this.copyMessages(set, session, toMailbox, fromMailbox);
    }

    public List<MessageRange> copyMessages(MessageRange set, MailboxId from, MailboxId to, MailboxSession session) throws MailboxException {
        StoreMessageManager toMailbox = (StoreMessageManager)this.getMailbox(to, session);
        StoreMessageManager fromMailbox = (StoreMessageManager)this.getMailbox(from, session);
        return this.copyMessages(set, session, toMailbox, fromMailbox);
    }

    private List<MessageRange> copyMessages(MessageRange set, MailboxSession session, StoreMessageManager toMailbox, StoreMessageManager fromMailbox) throws MailboxException {
        return this.configuration.getCopyBatcher().batchMessages(set, messageRange -> fromMailbox.copyTo(messageRange, toMailbox, session));
    }

    public List<MessageRange> moveMessages(MessageRange set, MailboxPath from, MailboxPath to, MailboxSession session) throws MailboxException {
        StoreMessageManager toMailbox = (StoreMessageManager)this.getMailbox(to, session);
        StoreMessageManager fromMailbox = (StoreMessageManager)this.getMailbox(from, session);
        return this.configuration.getMoveBatcher().batchMessages(set, messageRange -> fromMailbox.moveTo(messageRange, toMailbox, session));
    }

    public List<MailboxMetaData> search(MailboxQuery mailboxExpression, MailboxSession session) throws MailboxException {
        return this.searchMailboxes(mailboxExpression, session, MailboxACL.Right.Lookup);
    }

    private List<MailboxMetaData> searchMailboxes(MailboxQuery mailboxExpression, MailboxSession session, MailboxACL.Right right) throws MailboxException {
        MailboxMapper mailboxMapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        Stream baseMailboxes = mailboxMapper.findMailboxWithPathLike(StoreMailboxManager.getPathLike(mailboxExpression, session)).stream();
        Stream<Mailbox> delegatedMailboxes = this.getDelegatedMailboxes(mailboxMapper, mailboxExpression, right, session);
        List mailboxes = (List)Stream.concat(baseMailboxes, delegatedMailboxes).distinct().filter((Predicate<Mailbox>)Throwing.predicate(mailbox -> this.storeRightManager.hasRight((Mailbox)mailbox, right, session))).collect(Guavate.toImmutableList());
        return (List)mailboxes.stream().filter(mailbox -> mailboxExpression.isPathMatch(mailbox.generateAssociatedPath())).map(mailbox -> this.toMailboxMetadata(session, mailboxes, (Mailbox)mailbox)).sorted((Comparator<MailboxMetaData>)new StandardMailboxMetaDataComparator()).collect(Guavate.toImmutableList());
    }

    @VisibleForTesting
    public static MailboxPath getPathLike(MailboxQuery mailboxQuery, MailboxSession mailboxSession) {
        MailboxNameExpression nameExpression = mailboxQuery.getMailboxNameExpression();
        String combinedName = nameExpression.getCombinedName().replace(nameExpression.getFreeWildcard(), '%').replace(nameExpression.getLocalWildcard(), '%') + '%';
        MailboxPath base = new MailboxPath(mailboxQuery.getNamespace().orElse("#private"), mailboxQuery.getUser().orElse(mailboxSession.getUser().asString()), combinedName);
        return new MailboxPath(base, combinedName);
    }

    private Stream<Mailbox> getDelegatedMailboxes(MailboxMapper mailboxMapper, MailboxQuery mailboxQuery, MailboxACL.Right right, MailboxSession session) throws MailboxException {
        if (mailboxQuery.isPrivateMailboxes(session)) {
            return Stream.of(new Mailbox[0]);
        }
        return mailboxMapper.findNonPersonalMailboxes(session.getUser().asString(), right).stream();
    }

    private MailboxMetaData toMailboxMetadata(MailboxSession session, List<Mailbox> mailboxes, Mailbox mailbox) {
        return new MailboxMetaData(mailbox.generateAssociatedPath(), mailbox.getMailboxId(), this.getDelimiter(), this.computeChildren(session, mailboxes, mailbox), MailboxMetaData.Selectability.NONE);
    }

    private MailboxMetaData.Children computeChildren(MailboxSession session, List<Mailbox> potentialChildren, Mailbox mailbox) {
        if (this.hasChildIn(mailbox, potentialChildren, session)) {
            return MailboxMetaData.Children.HAS_CHILDREN;
        }
        return MailboxMetaData.Children.HAS_NO_CHILDREN;
    }

    private boolean hasChildIn(Mailbox parentMailbox, List<Mailbox> mailboxesWithPathLike, MailboxSession mailboxSession) {
        return mailboxesWithPathLike.stream().anyMatch(mailbox -> mailbox.isChildOf(parentMailbox, mailboxSession));
    }

    public List<MessageId> search(MultimailboxesSearchQuery expression, MailboxSession session, long limit) throws MailboxException {
        ImmutableSet wantedMailboxesId = (ImmutableSet)this.getInMailboxes((ImmutableSet<MailboxId>)expression.getInMailboxes(), session).filter(id -> !expression.getNotInMailboxes().contains(id)).collect(Guavate.toImmutableSet());
        return this.index.search(session, (Collection<MailboxId>)wantedMailboxesId, expression.getSearchQuery(), limit);
    }

    private Stream<MailboxId> getInMailboxes(ImmutableSet<MailboxId> inMailboxes, MailboxSession session) throws MailboxException {
        if (inMailboxes.isEmpty()) {
            return this.getAllReadableMailbox(session);
        }
        return this.getAllReadableMailbox(session).filter(arg_0 -> inMailboxes.contains(arg_0));
    }

    private Stream<MailboxId> getAllReadableMailbox(MailboxSession session) throws MailboxException {
        return this.searchMailboxes(MailboxQuery.builder().matchesAllMailboxNames().build(), session, MailboxACL.Right.Read).stream().map(MailboxMetaData::getId);
    }

    public boolean mailboxExists(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        try {
            MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
            mapper.findMailboxByPath(mailboxPath);
            return true;
        }
        catch (MailboxNotFoundException e) {
            return false;
        }
    }

    public void endProcessingRequest(MailboxSession session) {
        this.mailboxSessionMapperFactory.endProcessingRequest(session);
    }

    public void startProcessingRequest(MailboxSession session) {
    }

    public List<MailboxPath> list(MailboxSession session) throws MailboxException {
        return (List)this.mailboxSessionMapperFactory.getMailboxMapper(session).list().stream().map(Mailbox::generateAssociatedPath).collect(Guavate.toImmutableList());
    }

    public boolean hasRight(MailboxPath mailboxPath, MailboxACL.Right right, MailboxSession session) throws MailboxException {
        return this.storeRightManager.hasRight(mailboxPath, right, session);
    }

    public boolean hasRight(MailboxId mailboxId, MailboxACL.Right right, MailboxSession session) throws MailboxException {
        return this.storeRightManager.hasRight(mailboxId, right, session);
    }

    public MailboxACL.Rfc4314Rights myRights(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        return this.storeRightManager.myRights(mailboxPath, session);
    }

    public MailboxACL.Rfc4314Rights myRights(MailboxId mailboxId, MailboxSession session) throws MailboxException {
        return this.storeRightManager.myRights(mailboxId, session);
    }

    public MailboxACL.Rfc4314Rights[] listRights(MailboxPath mailboxPath, MailboxACL.EntryKey key, MailboxSession session) throws MailboxException {
        return this.storeRightManager.listRights(mailboxPath, key, session);
    }

    public MailboxACL listRights(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        return this.storeRightManager.listRights(mailboxPath, session);
    }

    public void applyRightsCommand(MailboxPath mailboxPath, MailboxACL.ACLCommand mailboxACLCommand, MailboxSession session) throws MailboxException {
        this.storeRightManager.applyRightsCommand(mailboxPath, mailboxACLCommand, session);
    }

    public void setRights(MailboxPath mailboxPath, MailboxACL mailboxACL, MailboxSession session) throws MailboxException {
        this.storeRightManager.setRights(mailboxPath, mailboxACL, session);
    }

    public void setRights(MailboxId mailboxId, MailboxACL mailboxACL, MailboxSession session) throws MailboxException {
        this.storeRightManager.setRights(mailboxId, mailboxACL, session);
    }

    public List<MailboxAnnotation> getAllAnnotations(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        return this.annotationManager.getAllAnnotations(mailboxPath, session);
    }

    public List<MailboxAnnotation> getAnnotationsByKeys(MailboxPath mailboxPath, MailboxSession session, Set<MailboxAnnotationKey> keys) throws MailboxException {
        return this.annotationManager.getAnnotationsByKeys(mailboxPath, session, keys);
    }

    public void updateAnnotations(MailboxPath mailboxPath, MailboxSession session, List<MailboxAnnotation> mailboxAnnotations) throws MailboxException {
        this.annotationManager.updateAnnotations(mailboxPath, session, mailboxAnnotations);
    }

    public boolean hasCapability(MailboxManager.MailboxCapabilities capability) {
        return this.getSupportedMailboxCapabilities().contains(capability);
    }

    public List<MailboxAnnotation> getAnnotationsByKeysWithOneDepth(MailboxPath mailboxPath, MailboxSession session, Set<MailboxAnnotationKey> keys) throws MailboxException {
        return this.annotationManager.getAnnotationsByKeysWithOneDepth(mailboxPath, session, keys);
    }

    public List<MailboxAnnotation> getAnnotationsByKeysWithAllDepth(MailboxPath mailboxPath, MailboxSession session, Set<MailboxAnnotationKey> keys) throws MailboxException {
        return this.annotationManager.getAnnotationsByKeysWithAllDepth(mailboxPath, session, keys);
    }

    public boolean hasChildren(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        Mailbox mailbox = mapper.findMailboxByPath(mailboxPath);
        return mapper.hasChildren(mailbox, session.getPathDelimiter());
    }
}

