/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import java.util.Optional;
import org.apache.james.mailbox.store.Authorizator;

public class FakeAuthorizator
implements Authorizator {
    private final Optional<String> adminId;
    private final Optional<String> delegatedUserId;

    public static FakeAuthorizator defaultReject() {
        return new FakeAuthorizator(Optional.empty(), Optional.empty());
    }

    public static FakeAuthorizator forUserAndAdmin(String admin, String user) {
        return new FakeAuthorizator(Optional.of(admin), Optional.of(user));
    }

    private FakeAuthorizator(Optional<String> adminId, Optional<String> userId) {
        this.adminId = adminId;
        this.delegatedUserId = userId;
    }

    @Override
    public Authorizator.AuthorizationState canLoginAsOtherUser(String userId, String otherUserId) {
        if (!this.adminId.isPresent() || !this.delegatedUserId.isPresent()) {
            return Authorizator.AuthorizationState.NOT_ADMIN;
        }
        if (!this.adminId.get().equals(userId)) {
            return Authorizator.AuthorizationState.NOT_ADMIN;
        }
        if (!otherUserId.equals(this.delegatedUserId.get())) {
            return Authorizator.AuthorizationState.UNKNOWN_USER;
        }
        return Authorizator.AuthorizationState.ALLOWED;
    }
}

