/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.eventsourcing.eventstore;

import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.EventId;
import org.apache.james.eventsourcing.eventstore.EventStoreFailedException;

public class History {
    private final List<Event> events;

    public static History empty() {
        return new History((List<Event>)ImmutableList.of());
    }

    public static History of(List<Event> events) {
        return new History((List<Event>)ImmutableList.copyOf(events));
    }

    public static History of(Event ... events) {
        return History.of((List<Event>)ImmutableList.copyOf((Object[])events));
    }

    private History(List<Event> events) {
        if (this.hasEventIdDuplicates(events)) {
            throw new EventStoreFailedException("Event History contains duplicated EventId");
        }
        this.events = events;
    }

    public boolean hasEventIdDuplicates(List<Event> events) {
        Set eventIds = (Set)events.stream().map(Event::eventId).collect(Guavate.toImmutableSet());
        return eventIds.size() != events.size();
    }

    public Optional<EventId> getVersion() {
        return this.events.stream().map(Event::eventId).max(Comparator.naturalOrder());
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public EventId getNextEventId() {
        return this.getVersion().map(EventId::next).orElse(EventId.first());
    }

    public final boolean equals(Object o) {
        if (o instanceof History) {
            History history = (History)o;
            return Objects.equals(this.events, history.events);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.events);
    }
}

