/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail.model.openjpa;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.mail.Flags;
import javax.mail.internet.SharedInputStream;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Lob;
import javax.persistence.Table;
import org.apache.commons.io.IOUtils;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.jpa.mail.model.JPAMailbox;
import org.apache.james.mailbox.jpa.mail.model.openjpa.AbstractJPAMailboxMessage;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.impl.PropertyBuilder;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;

@Entity(name="MailboxMessage")
@Table(name="JAMES_MAIL")
public class JPAMailboxMessage
extends AbstractJPAMailboxMessage
implements PersistenceCapable {
    private static final byte[] EMPTY_BODY = new byte[0];
    @Basic(optional=false, fetch=FetchType.LAZY)
    @Column(name="MAIL_BYTES", length=1048576000, nullable=false)
    @Lob
    private byte[] body;
    @Basic(optional=false, fetch=FetchType.LAZY)
    @Column(name="HEADER_BYTES", length=0xA00000, nullable=false)
    @Lob
    private byte[] header;
    private static int pcInheritedFieldCount = AbstractJPAMailboxMessage.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMailboxMessage;
    static /* synthetic */ Class class$L$B;
    static /* synthetic */ Class class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$JPAMailboxMessage;

    public JPAMailboxMessage() {
    }

    @VisibleForTesting
    protected JPAMailboxMessage(byte[] header, byte[] body) {
        this.header = header;
        this.body = body;
    }

    public JPAMailboxMessage(JPAMailbox mailbox, Date internalDate, int size, Flags flags, SharedInputStream content, int bodyStartOctet, PropertyBuilder propertyBuilder) throws MailboxException {
        super(mailbox, internalDate, flags, size, bodyStartOctet, propertyBuilder);
        try {
            int headerEnd = bodyStartOctet;
            if (headerEnd < 0) {
                headerEnd = 0;
            }
            this.header = IOUtils.toByteArray((InputStream)content.newStream(0L, (long)headerEnd));
            this.body = IOUtils.toByteArray((InputStream)content.newStream((long)this.getBodyStartOctet(), -1L));
        }
        catch (IOException e) {
            throw new MailboxException("Unable to parse message", (Throwable)e);
        }
    }

    public JPAMailboxMessage(JPAMailbox mailbox, MessageUid uid, long modSeq, MailboxMessage message) throws MailboxException {
        super(mailbox, uid, modSeq, message);
        try {
            this.body = IOUtils.toByteArray((InputStream)message.getBodyContent());
            this.header = IOUtils.toByteArray((InputStream)message.getHeaderContent());
        }
        catch (IOException e) {
            throw new MailboxException("Unable to parse message", (Throwable)e);
        }
    }

    public InputStream getBodyContent() throws IOException {
        if (JPAMailboxMessage.pcGetbody(this) == null) {
            return new ByteArrayInputStream(EMPTY_BODY);
        }
        return new ByteArrayInputStream(JPAMailboxMessage.pcGetbody(this));
    }

    public InputStream getHeaderContent() throws IOException {
        return new ByteArrayInputStream(JPAMailboxMessage.pcGetheader(this));
    }

    static {
        Class clazz = class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMailboxMessage != null ? class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMailboxMessage : (class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$AbstractJPAMailboxMessage = JPAMailboxMessage.class$("org.apache.james.mailbox.jpa.mail.model.openjpa.AbstractJPAMailboxMessage"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"body", "header"};
        Class[] classArray = new Class[2];
        Class clazz2 = class$L$B != null ? class$L$B : (class$L$B = JPAMailboxMessage.class$("[B"));
        classArray[0] = clazz2;
        classArray[1] = class$L$B != null ? class$L$B : (class$L$B = JPAMailboxMessage.class$("[B"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{21, 21};
        Class clazz3 = class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$JPAMailboxMessage != null ? class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$JPAMailboxMessage : (class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$JPAMailboxMessage = JPAMailboxMessage.class$("org.apache.james.mailbox.jpa.mail.model.openjpa.JPAMailboxMessage"));
        PCRegistry.register((Class)clazz3, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"MailboxMessage", (PersistenceCapable)new JPAMailboxMessage());
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 1759663;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.body = null;
        this.header = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPAMailboxMessage jPAMailboxMessage = new JPAMailboxMessage();
        if (bl) {
            jPAMailboxMessage.pcClearFields();
        }
        jPAMailboxMessage.pcStateManager = stateManager;
        jPAMailboxMessage.pcCopyKeyFieldsFromObjectId(object);
        return jPAMailboxMessage;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPAMailboxMessage jPAMailboxMessage = new JPAMailboxMessage();
        if (bl) {
            jPAMailboxMessage.pcClearFields();
        }
        jPAMailboxMessage.pcStateManager = stateManager;
        return jPAMailboxMessage;
    }

    protected static int pcGetManagedFieldCount() {
        return 2 + AbstractJPAMailboxMessage.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.body = (byte[])this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.header = (byte[])this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.body);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.header);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(JPAMailboxMessage jPAMailboxMessage, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(jPAMailboxMessage, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.body = jPAMailboxMessage.body;
                return;
            }
            case 1: {
                this.header = jPAMailboxMessage.header;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        JPAMailboxMessage jPAMailboxMessage = (JPAMailboxMessage)object;
        if (jPAMailboxMessage.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(jPAMailboxMessage, nArray[n]);
            ++n;
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        Class clazz = class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$JPAMailboxMessage != null ? class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$JPAMailboxMessage : (class$Lorg$apache$james$mailbox$jpa$mail$model$openjpa$JPAMailboxMessage = JPAMailboxMessage.class$("org.apache.james.mailbox.jpa.mail.model.openjpa.JPAMailboxMessage"));
        return clazz;
    }

    private static final byte[] pcGetbody(JPAMailboxMessage jPAMailboxMessage) {
        if (jPAMailboxMessage.pcStateManager == null) {
            return jPAMailboxMessage.body;
        }
        int n = pcInheritedFieldCount + 0;
        jPAMailboxMessage.pcStateManager.accessingField(n);
        return jPAMailboxMessage.body;
    }

    private static final void pcSetbody(JPAMailboxMessage jPAMailboxMessage, byte[] byArray) {
        if (jPAMailboxMessage.pcStateManager == null) {
            jPAMailboxMessage.body = byArray;
            return;
        }
        jPAMailboxMessage.pcStateManager.settingObjectField((PersistenceCapable)jPAMailboxMessage, pcInheritedFieldCount + 0, (Object)jPAMailboxMessage.body, (Object)byArray, 0);
    }

    private static final byte[] pcGetheader(JPAMailboxMessage jPAMailboxMessage) {
        if (jPAMailboxMessage.pcStateManager == null) {
            return jPAMailboxMessage.header;
        }
        int n = pcInheritedFieldCount + 1;
        jPAMailboxMessage.pcStateManager.accessingField(n);
        return jPAMailboxMessage.header;
    }

    private static final void pcSetheader(JPAMailboxMessage jPAMailboxMessage, byte[] byArray) {
        if (jPAMailboxMessage.pcStateManager == null) {
            jPAMailboxMessage.header = byArray;
            return;
        }
        jPAMailboxMessage.pcStateManager.settingObjectField((PersistenceCapable)jPAMailboxMessage, pcInheritedFieldCount + 1, (Object)jPAMailboxMessage.header, (Object)byArray, 0);
    }
}

