/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa;

import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.jpa.mail.JPAAnnotationMapper;
import org.apache.james.mailbox.jpa.mail.JPAMailboxMapper;
import org.apache.james.mailbox.jpa.mail.JPAMessageMapper;
import org.apache.james.mailbox.jpa.user.JPASubscriptionMapper;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.mail.AnnotationMapper;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.MessageIdMapper;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.mailbox.store.user.SubscriptionMapper;

public class JPAMailboxSessionMapperFactory
extends MailboxSessionMapperFactory {
    private final EntityManagerFactory entityManagerFactory;
    private final UidProvider uidProvider;
    private final ModSeqProvider modSeqProvider;

    @Inject
    public JPAMailboxSessionMapperFactory(EntityManagerFactory entityManagerFactory, UidProvider uidProvider, ModSeqProvider modSeqProvider) {
        this.entityManagerFactory = entityManagerFactory;
        this.uidProvider = uidProvider;
        this.modSeqProvider = modSeqProvider;
        this.createEntityManager().close();
    }

    public MailboxMapper createMailboxMapper(MailboxSession session) {
        return new JPAMailboxMapper(this.entityManagerFactory);
    }

    public MessageMapper createMessageMapper(MailboxSession session) {
        return new JPAMessageMapper(session, this.uidProvider, this.modSeqProvider, this.entityManagerFactory);
    }

    public MessageIdMapper createMessageIdMapper(MailboxSession session) throws MailboxException {
        throw new NotImplementedException("not implemented");
    }

    public SubscriptionMapper createSubscriptionMapper(MailboxSession session) {
        return new JPASubscriptionMapper(this.entityManagerFactory);
    }

    private EntityManager createEntityManager() {
        return this.entityManagerFactory.createEntityManager();
    }

    public AnnotationMapper createAnnotationMapper(MailboxSession session) throws MailboxException {
        return new JPAAnnotationMapper(this.entityManagerFactory);
    }

    public UidProvider getUidProvider() {
        return this.uidProvider;
    }

    public ModSeqProvider getModSeqProvider() {
        return this.modSeqProvider;
    }
}

