/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.quota;

import com.github.fge.lambdas.Throwing;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.james.core.Domain;
import org.apache.james.core.quota.QuotaCount;
import org.apache.james.core.quota.QuotaSize;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.util.OptionalUtils;

public interface MaxQuotaManager {
    public void setMaxStorage(QuotaRoot var1, QuotaSize var2) throws MailboxException;

    public void setMaxMessage(QuotaRoot var1, QuotaCount var2) throws MailboxException;

    public void removeMaxMessage(QuotaRoot var1) throws MailboxException;

    public void removeMaxStorage(QuotaRoot var1) throws MailboxException;

    public void setGlobalMaxStorage(QuotaSize var1) throws MailboxException;

    public void removeGlobalMaxStorage() throws MailboxException;

    public void setGlobalMaxMessage(QuotaCount var1) throws MailboxException;

    public void removeGlobalMaxMessage() throws MailboxException;

    public Optional<QuotaSize> getGlobalMaxStorage() throws MailboxException;

    public Optional<QuotaCount> getGlobalMaxMessage() throws MailboxException;

    public Optional<QuotaSize> getMaxStorage(QuotaRoot var1) throws MailboxException;

    public Optional<QuotaCount> getMaxMessage(QuotaRoot var1) throws MailboxException;

    public Map<Quota.Scope, QuotaCount> listMaxMessagesDetails(QuotaRoot var1);

    public Map<Quota.Scope, QuotaSize> listMaxStorageDetails(QuotaRoot var1);

    public Optional<QuotaCount> getDomainMaxMessage(Domain var1);

    public void setDomainMaxMessage(Domain var1, QuotaCount var2) throws MailboxException;

    public void removeDomainMaxMessage(Domain var1) throws MailboxException;

    public void setDomainMaxStorage(Domain var1, QuotaSize var2) throws MailboxException;

    public Optional<QuotaSize> getDomainMaxStorage(Domain var1);

    public void removeDomainMaxStorage(Domain var1) throws MailboxException;

    default public Optional<QuotaCount> getComputedMaxMessage(Domain domain) throws MailboxException {
        return OptionalUtils.orSuppliers((Supplier[])new Supplier[]{Throwing.supplier(() -> this.getDomainMaxMessage(domain)).sneakyThrow(), Throwing.supplier(this::getGlobalMaxMessage).sneakyThrow()});
    }

    default public Optional<QuotaSize> getComputedMaxStorage(Domain domain) throws MailboxException {
        return OptionalUtils.orSuppliers((Supplier[])new Supplier[]{Throwing.supplier(() -> this.getDomainMaxStorage(domain)).sneakyThrow(), Throwing.supplier(this::getGlobalMaxStorage).sneakyThrow()});
    }
}

