/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model.search;

import com.google.common.base.Preconditions;
import org.apache.james.mailbox.model.search.MailboxNameExpression;

public class ExactName
implements MailboxNameExpression {
    private final String name;

    public ExactName(String name) {
        Preconditions.checkNotNull((Object)name);
        this.name = name;
    }

    @Override
    public boolean isExpressionMatch(String mailboxName) {
        Preconditions.checkNotNull((Object)mailboxName);
        return this.name.equals(mailboxName);
    }

    @Override
    public String getCombinedName() {
        return this.name;
    }

    @Override
    public boolean isWild() {
        return false;
    }
}

