/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.acl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.HashSet;
import java.util.Set;
import org.apache.james.mailbox.acl.GroupMembershipResolver;

public class SimpleGroupMembershipResolver
implements GroupMembershipResolver {
    private final Set<Membership> memberships = new HashSet<Membership>(32);

    public void addMembership(String group, String user) {
        this.memberships.add(new Membership(user, group));
    }

    @Override
    public boolean isMember(String user, String group) {
        return this.memberships.contains(new Membership(user, group));
    }

    public static class Membership {
        private final String group;
        private final String user;

        public Membership(String user, String group) {
            this.group = group;
            this.user = user;
        }

        public boolean equals(Object o) {
            if (o instanceof Membership) {
                Membership that = (Membership)o;
                return Objects.equal((Object)this.user, (Object)that.user) && Objects.equal((Object)this.group, (Object)that.group);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.group, this.user});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("group", (Object)this.group).add("user", (Object)this.user).toString();
        }
    }
}

