/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.adapter.mailbox;

import com.github.steveash.guavate.Guavate;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.james.adapter.mailbox.MailboxManagerManagementMBean;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.util.MDCBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailboxManagerManagement
extends StandardMBean
implements MailboxManagerManagementMBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailboxManagerManagement.class);
    private MailboxManager mailboxManager;

    @Inject
    public void setMailboxManager(@Named(value="mailboxmanager") MailboxManager mailboxManager) {
        this.mailboxManager = mailboxManager;
    }

    public MailboxManagerManagement() throws NotCompliantMBeanException {
        super(MailboxManagerManagementMBean.class);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean deleteMailboxes(String username) {
        boolean bl;
        Throwable throwable;
        Closeable closeable;
        MailboxSession session;
        block18: {
            block19: {
                this.checkString(username, "Username");
                session = null;
                closeable = MDCBuilder.create().addContext("protocol", (Object)"CLI").addContext("action", (Object)"deleteMailboxes").addContext("concernedUser", (Object)username).build();
                throwable = null;
                session = this.mailboxManager.createSystemSession(username);
                this.mailboxManager.startProcessingRequest(session);
                List<MailboxMetaData> mList = this.retrieveAllUserMailboxes(session);
                for (MailboxMetaData aMList : mList) {
                    this.mailboxManager.deleteMailbox(aMList.getPath(), session);
                }
                bl = true;
                if (closeable == null) break block18;
                if (throwable == null) break block19;
                try {
                    closeable.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                break block18;
            }
            closeable.close();
        }
        this.closeSession(session);
        return bl;
        catch (Throwable throwable3) {
            try {
                try {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (closeable == null) throw throwable4;
                    if (throwable != null) {
                        try {
                            closeable.close();
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        throw throwable4;
                    } else {
                        closeable.close();
                    }
                    throw throwable4;
                }
            }
            catch (MailboxException e) {
                LOGGER.error("Error while remove mailboxes for user {}", (Object)username, (Object)e);
                this.closeSession(session);
                return false;
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable6) {
                    this.closeSession(session);
                    throw throwable6;
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public List<String> listMailboxes(String username) {
        this.checkString(username, "Username");
        List<String> boxes = new ArrayList<String>();
        MailboxSession session = null;
        try {
            try (Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)"CLI").addContext("action", (Object)"listMailboxes").addContext("concernedUser", (Object)username).build();){
                session = this.mailboxManager.createSystemSession(username);
                this.mailboxManager.startProcessingRequest(session);
                List<MailboxMetaData> mList = this.retrieveAllUserMailboxes(session);
                boxes = (List)mList.stream().map(aMList -> aMList.getPath().getName()).sorted().collect(Guavate.toImmutableList());
            }
            this.closeSession(session);
        }
        catch (MailboxException e) {
            LOGGER.error("Error list mailboxes for user {}", (Object)username, (Object)e);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.closeSession(session);
        }
        return boxes;
    }

    /*
     * Exception decompiling
     */
    @Override
    public MailboxId createMailbox(String namespace, String user, String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteMailbox(String namespace, String user, String name) {
        this.checkMailboxArguments(namespace, user, name);
        MailboxSession session = null;
        MailboxPath mailboxPath = new MailboxPath(namespace, user, name);
        try {
            try (Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)"CLI").addContext("action", (Object)"deleteMailbox").addContext("mailboxPath", (Object)mailboxPath.asString()).build();){
                session = this.mailboxManager.createSystemSession(user);
                this.mailboxManager.startProcessingRequest(session);
                this.mailboxManager.deleteMailbox(mailboxPath, session);
            }
            this.closeSession(session);
        }
        catch (Exception e) {
            LOGGER.error("Unable to create mailbox", (Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importEmlFileToMailbox(String namespace, String user, String name, String emlPath) {
        this.checkMailboxArguments(namespace, user, name);
        this.checkString(emlPath, "email file path name");
        MailboxSession session = null;
        MailboxPath mailboxPath = new MailboxPath(namespace, user, name);
        try {
            try (Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)"CLI").addContext("action", (Object)"importEmlFileToMailbox").addContext("mailboxPath", (Object)mailboxPath.asString()).addContext("emlPath", (Object)emlPath).build();){
                session = this.mailboxManager.createSystemSession(user);
                this.mailboxManager.startProcessingRequest(session);
                MessageManager messageManager = this.mailboxManager.getMailbox(mailboxPath, session);
                FileInputStream emlFileAsStream = new FileInputStream(emlPath);
                messageManager.appendMessage(MessageManager.AppendCommand.builder().recent().build((InputStream)emlFileAsStream), session);
            }
            this.closeSession(session);
        }
        catch (Exception e) {
            LOGGER.error("Unable to create mailbox", (Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    private void closeSession(MailboxSession session) {
        if (session != null) {
            this.mailboxManager.endProcessingRequest(session);
            try {
                this.mailboxManager.logout(session, true);
            }
            catch (MailboxException e) {
                LOGGER.error("Can not log session out", (Throwable)e);
            }
        }
    }

    private List<MailboxMetaData> retrieveAllUserMailboxes(MailboxSession session) throws MailboxException {
        return this.mailboxManager.search(MailboxQuery.privateMailboxesBuilder((MailboxSession)session).matchesAllMailboxNames().build(), session);
    }

    private void checkMailboxArguments(String namespace, String user, String name) {
        this.checkString(namespace, "mailbox path namespace");
        this.checkString(user, "mailbox path user");
        this.checkString(name, "mailbox name");
    }

    private void checkString(String argument, String role) {
        Preconditions.checkNotNull((Object)argument, (Object)("Provided " + role + " should not be null."));
        Preconditions.checkArgument((!argument.equals("") ? 1 : 0) != 0, (Object)("Provided " + role + " should not be empty."));
    }

    private static /* synthetic */ MailboxException lambda$createMailbox$1() {
        return new MailboxException("mailbox name is probably empty");
    }
}

