/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.decode.ImapDecoder;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imapserver.netty.IMAPServer;
import org.apache.james.imapserver.netty.ImapMetrics;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.protocols.lib.netty.AbstractConfigurableAsyncServer;
import org.apache.james.protocols.lib.netty.AbstractServerFactory;
import org.jboss.netty.util.HashedWheelTimer;

public class IMAPServerFactory
extends AbstractServerFactory {
    protected final FileSystem fileSystem;
    protected final ImapDecoder decoder;
    protected final ImapEncoder encoder;
    protected final ImapProcessor processor;
    protected final ImapMetrics imapMetrics;
    private final HashedWheelTimer hashedWheelTimer;

    @Inject
    public IMAPServerFactory(FileSystem fileSystem, ImapDecoder decoder, ImapEncoder encoder, ImapProcessor processor, MetricFactory metricFactory, HashedWheelTimer hashedWheelTimer) {
        this.fileSystem = fileSystem;
        this.decoder = decoder;
        this.encoder = encoder;
        this.processor = processor;
        this.imapMetrics = new ImapMetrics(metricFactory);
        this.hashedWheelTimer = hashedWheelTimer;
    }

    protected IMAPServer createServer() {
        return new IMAPServer(this.decoder, this.encoder, this.processor, this.imapMetrics);
    }

    protected List<AbstractConfigurableAsyncServer> createServers(HierarchicalConfiguration config) throws Exception {
        ArrayList<AbstractConfigurableAsyncServer> servers = new ArrayList<AbstractConfigurableAsyncServer>();
        List configs = config.configurationsAt("imapserver");
        for (HierarchicalConfiguration serverConfig : configs) {
            IMAPServer server = this.createServer();
            server.setFileSystem(this.fileSystem);
            server.setHashWheelTimer(this.hashedWheelTimer);
            server.configure(serverConfig);
            servers.add(server);
        }
        return servers;
    }
}

