/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.file;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.queue.api.MailQueueItemDecoratorFactory;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.queue.file.FileMailQueue;

public class FileMailQueueFactory
implements MailQueueFactory<ManageableMailQueue> {
    private final Map<String, ManageableMailQueue> queues = new HashMap<String, ManageableMailQueue>();
    private MailQueueItemDecoratorFactory mailQueueActionItemDecoratorFactory;
    private FileSystem fs;
    private boolean sync = true;

    @Inject
    public FileMailQueueFactory(FileSystem fs, MailQueueItemDecoratorFactory mailQueueItemDecoratorFactory) {
        this.fs = fs;
        this.mailQueueActionItemDecoratorFactory = mailQueueItemDecoratorFactory;
    }

    public Set<ManageableMailQueue> listCreatedMailQueues() {
        return ImmutableSet.copyOf(this.queues.values());
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public Optional<ManageableMailQueue> getQueue(String name) {
        return Optional.ofNullable(this.queues.get(name));
    }

    public ManageableMailQueue createQueue(String name) {
        return this.getQueue(name).orElseGet(() -> this.createAndRegisterQueue(name));
    }

    private ManageableMailQueue createAndRegisterQueue(String name) {
        Map<String, ManageableMailQueue> map = this.queues;
        synchronized (map) {
            try {
                FileMailQueue queue = new FileMailQueue(this.mailQueueActionItemDecoratorFactory, this.fs.getFile("file://var/store/queue"), name, this.sync);
                this.queues.put(name, queue);
                return queue;
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to access queue " + name, e);
            }
        }
    }
}

