/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.jdbc;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.user.api.model.User;
import org.apache.james.user.lib.AbstractJamesUsersRepository;
import org.apache.james.util.sql.JDBCUtil;
import org.apache.james.util.sql.SqlResources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public abstract class AbstractJdbcUsersRepository
extends AbstractJamesUsersRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractJdbcUsersRepository.class);
    protected Map<String, String> sqlParameters;
    private String sqlFileName;
    private DataSource datasource;
    private String getUsersSql;
    private String userByNameCaseInsensitiveSql;
    private String insertUserSql;
    private String updateUserSql;
    private String deleteUserSql;
    private JDBCUtil theJDBCUtil;
    private FileSystem fileSystem;

    public void removeUser(String userName) throws UsersRepositoryException {
        User user = this.getUserByName(userName);
        if (user == null) {
            throw new UsersRepositoryException("User " + userName + " does not exist");
        }
        this.doRemoveUser(user);
    }

    public User getUserByName(String name) throws UsersRepositoryException {
        return this.getUserByName(name, this.ignoreCase);
    }

    public boolean contains(String name) throws UsersRepositoryException {
        User user = this.getUserByName(name, this.ignoreCase);
        return user != null;
    }

    public boolean containsCaseInsensitive(String name) throws UsersRepositoryException {
        User user = this.getUserByName(name, true);
        return user != null;
    }

    public boolean test(String name, String password) throws UsersRepositoryException {
        User user = this.getUserByName(name, this.ignoreCase);
        return user != null && user.verifyPassword(password);
    }

    public int countUsers() throws UsersRepositoryException {
        List<String> usernames = this.listUserNames();
        return usernames.size();
    }

    public Iterator<String> list() throws UsersRepositoryException {
        return this.listUserNames().iterator();
    }

    @Inject
    public void setDatasource(DataSource datasource) {
        this.datasource = datasource;
    }

    @Inject
    public void setFileSystem(FileSystem system) {
        this.fileSystem = system;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void init() throws Exception {
        block10: {
            LOGGER.debug("{}.initialize()", (Object)((Object)((Object)this)).getClass().getName());
            this.theJDBCUtil = new JDBCUtil();
            Connection conn = this.openConnection();
            try {
                InputStream sqlFile;
                DatabaseMetaData dbMetaData = conn.getMetaData();
                try {
                    sqlFile = this.fileSystem.getResource(this.sqlFileName);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    throw e;
                }
                LOGGER.debug("Reading SQL resources from: {}, section {}.", (Object)this.sqlFileName, (Object)((Object)((Object)this)).getClass().getName());
                SqlResources sqlStatements = new SqlResources();
                sqlStatements.init(sqlFile, ((Object)((Object)this)).getClass().getName(), conn, this.sqlParameters);
                this.getUsersSql = sqlStatements.getSqlString("select", true);
                this.userByNameCaseInsensitiveSql = sqlStatements.getSqlString("selectByLowercaseName");
                this.insertUserSql = sqlStatements.getSqlString("insert", true);
                this.updateUserSql = sqlStatements.getSqlString("update", true);
                this.deleteUserSql = sqlStatements.getSqlString("delete", true);
                String createUserTableSql = sqlStatements.getSqlString("createTable", true);
                String tableName = sqlStatements.getSqlString("tableName", true);
                if (!this.theJDBCUtil.tableExists(dbMetaData, tableName)) {
                    PreparedStatement createStatement = null;
                    try {
                        createStatement = conn.prepareStatement(createUserTableSql);
                        createStatement.execute();
                    }
                    finally {
                        this.theJDBCUtil.closeJDBCStatement((Statement)createStatement);
                    }
                    LOGGER.info("{}: Created table '{}'.", (Object)((Object)((Object)this)).getClass().getName(), (Object)tableName);
                    break block10;
                }
                LOGGER.debug("Using table: {}", (Object)tableName);
            }
            finally {
                this.theJDBCUtil.closeJDBCConnection(conn);
            }
        }
    }

    protected void doConfigure(HierarchicalConfiguration configuration) throws ConfigurationException {
        LOGGER.debug("{}.configure()", (Object)((Object)((Object)this)).getClass().getName());
        String destUrl = configuration.getString("[@destinationURL]", null);
        if (destUrl == null) {
            throw new ConfigurationException("destinationURL attribute is missing from Configuration");
        }
        if (!destUrl.endsWith("/")) {
            destUrl = destUrl + "/";
        }
        ArrayList<String> urlParams = new ArrayList<String>();
        int start = 5;
        int end = destUrl.indexOf(47, start);
        while (end > -1) {
            urlParams.add(destUrl.substring(start, end));
            start = end + 1;
            end = destUrl.indexOf(47, start);
        }
        this.sqlParameters = new HashMap<String, String>();
        switch (urlParams.size()) {
            case 3: {
                this.sqlParameters.put("key", (String)urlParams.get(2));
                this.sqlParameters.put("table", (String)urlParams.get(1));
                urlParams.get(0);
                break;
            }
            case 2: {
                this.sqlParameters.put("table", (String)urlParams.get(1));
                urlParams.get(0);
                break;
            }
            case 1: {
                urlParams.get(0);
                break;
            }
            default: {
                throw new ConfigurationException("Malformed destinationURL - Must be of the format \"db://<data-source>[/<table>[/<key>]]\".");
            }
        }
        LOGGER.debug("Parsed URL: table = '{}', key = '{}'", (Object)this.sqlParameters.get("table"), (Object)this.sqlParameters.get("key"));
        this.sqlFileName = configuration.getString("sqlFile", null);
        Iterator paramIt = configuration.getKeys("sqlParameters");
        while (paramIt.hasNext()) {
            String rawName = (String)paramIt.next();
            String paramName = ((String)paramIt.next()).substring("sqlParameters.[@".length(), rawName.length() - 1);
            String paramValue = configuration.getString(rawName);
            this.sqlParameters.put(paramName, paramValue);
        }
    }

    protected List<String> listUserNames() throws UsersRepositoryException {
        Collection<User> users = this.getAllUsers();
        ArrayList<String> userNames = new ArrayList<String>(users.size());
        for (User user : users) {
            userNames.add(user.getUserName());
        }
        users.clear();
        return userNames;
    }

    protected Iterator<User> listAllUsers() throws UsersRepositoryException {
        return this.getAllUsers().iterator();
    }

    private Collection<User> getAllUsers() throws UsersRepositoryException {
        ArrayList<User> userList = new ArrayList<User>();
        Connection conn = null;
        PreparedStatement getUsersStatement = null;
        ResultSet rsUsers = null;
        try {
            conn = this.openConnection();
            getUsersStatement = conn.prepareStatement(this.getUsersSql);
            rsUsers = getUsersStatement.executeQuery();
            while (rsUsers.next()) {
                User user = this.readUserFromResultSet(rsUsers);
                userList.add(user);
            }
        }
        catch (SQLException sqlExc) {
            try {
                throw new UsersRepositoryException("Error accessing database", (Throwable)sqlExc);
            }
            catch (Throwable throwable) {
                this.theJDBCUtil.closeJDBCResultSet(rsUsers);
                this.theJDBCUtil.closeJDBCStatement((Statement)getUsersStatement);
                this.theJDBCUtil.closeJDBCConnection(conn);
                throw throwable;
            }
        }
        this.theJDBCUtil.closeJDBCResultSet(rsUsers);
        this.theJDBCUtil.closeJDBCStatement((Statement)getUsersStatement);
        this.theJDBCUtil.closeJDBCConnection(conn);
        return userList;
    }

    protected void doAddUser(User user) throws UsersRepositoryException {
        Connection conn = null;
        PreparedStatement addUserStatement = null;
        try {
            conn = this.openConnection();
            addUserStatement = conn.prepareStatement(this.insertUserSql);
            this.setUserForInsertStatement(user, addUserStatement);
            addUserStatement.execute();
        }
        catch (SQLException sqlExc) {
            try {
                throw new UsersRepositoryException("Error accessing database", (Throwable)sqlExc);
            }
            catch (Throwable throwable) {
                this.theJDBCUtil.closeJDBCStatement(addUserStatement);
                this.theJDBCUtil.closeJDBCConnection(conn);
                throw throwable;
            }
        }
        this.theJDBCUtil.closeJDBCStatement((Statement)addUserStatement);
        this.theJDBCUtil.closeJDBCConnection(conn);
    }

    protected void doRemoveUser(User user) throws UsersRepositoryException {
        String username = user.getUserName();
        Connection conn = null;
        PreparedStatement removeUserStatement = null;
        try {
            conn = this.openConnection();
            removeUserStatement = conn.prepareStatement(this.deleteUserSql);
            removeUserStatement.setString(1, username);
            removeUserStatement.execute();
        }
        catch (SQLException sqlExc) {
            try {
                throw new UsersRepositoryException("Error accessing database", (Throwable)sqlExc);
            }
            catch (Throwable throwable) {
                this.theJDBCUtil.closeJDBCStatement(removeUserStatement);
                this.theJDBCUtil.closeJDBCConnection(conn);
                throw throwable;
            }
        }
        this.theJDBCUtil.closeJDBCStatement((Statement)removeUserStatement);
        this.theJDBCUtil.closeJDBCConnection(conn);
    }

    protected void doUpdateUser(User user) throws UsersRepositoryException {
        Connection conn = null;
        PreparedStatement updateUserStatement = null;
        try {
            conn = this.openConnection();
            updateUserStatement = conn.prepareStatement(this.updateUserSql);
            this.setUserForUpdateStatement(user, updateUserStatement);
            updateUserStatement.execute();
        }
        catch (SQLException sqlExc) {
            try {
                throw new UsersRepositoryException("Error accessing database", (Throwable)sqlExc);
            }
            catch (Throwable throwable) {
                this.theJDBCUtil.closeJDBCStatement(updateUserStatement);
                this.theJDBCUtil.closeJDBCConnection(conn);
                throw throwable;
            }
        }
        this.theJDBCUtil.closeJDBCStatement((Statement)updateUserStatement);
        this.theJDBCUtil.closeJDBCConnection(conn);
    }

    protected User getUserByNameIterating(String name, boolean ignoreCase) throws UsersRepositoryException {
        Iterator<User> users = this.listAllUsers();
        while (users.hasNext()) {
            User user = users.next();
            String username = user.getUserName();
            if ((ignoreCase || !username.equals(name)) && (!ignoreCase || !username.equalsIgnoreCase(name))) continue;
            return user;
        }
        return null;
    }

    protected User getUserByName(String name, boolean ignoreCase) throws UsersRepositoryException {
        User user;
        if (this.userByNameCaseInsensitiveSql == null) {
            return this.getUserByNameIterating(name, ignoreCase);
        }
        Connection conn = null;
        PreparedStatement getUsersStatement = null;
        ResultSet rsUsers = null;
        try {
            conn = this.openConnection();
            String sql = this.userByNameCaseInsensitiveSql;
            getUsersStatement = conn.prepareStatement(sql);
            getUsersStatement.setString(1, name.toLowerCase(Locale.US));
            rsUsers = getUsersStatement.executeQuery();
            User user2 = null;
            while (rsUsers.next()) {
                User rowUser = this.readUserFromResultSet(rsUsers);
                String actualName = rowUser.getUserName();
                if (!ignoreCase && !actualName.equals(name)) continue;
                user2 = rowUser;
                break;
            }
            user = user2;
        }
        catch (SQLException sqlExc) {
            try {
                throw new UsersRepositoryException("Error accessing database", (Throwable)sqlExc);
            }
            catch (Throwable throwable) {
                this.theJDBCUtil.closeJDBCResultSet(rsUsers);
                this.theJDBCUtil.closeJDBCStatement((Statement)getUsersStatement);
                this.theJDBCUtil.closeJDBCConnection(conn);
                throw throwable;
            }
        }
        this.theJDBCUtil.closeJDBCResultSet(rsUsers);
        this.theJDBCUtil.closeJDBCStatement((Statement)getUsersStatement);
        this.theJDBCUtil.closeJDBCConnection(conn);
        return user;
    }

    protected abstract User readUserFromResultSet(ResultSet var1) throws SQLException;

    protected abstract void setUserForInsertStatement(User var1, PreparedStatement var2) throws SQLException;

    protected abstract void setUserForUpdateStatement(User var1, PreparedStatement var2) throws SQLException;

    private Connection openConnection() throws SQLException {
        return this.datasource.getConnection();
    }
}

